/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.cache.CacheKey;
import kd.fi.ai.cache.CacheModule;
import kd.fi.ai.cache.LocalCacheHelper;

public class FieldReplaceUtil {
    public static VchTplExpression replaceFilterSet(VchTplExpression filterSet, Map<String, String> commonAndSourceFieldcol) {
        String formula = filterSet.getFilterString();
        for (Map.Entry<String, String> entry : commonAndSourceFieldcol.entrySet()) {
            String oldvalue = entry.getKey();
            String newValue = entry.getValue();
            if (!formula.contains(oldvalue)) continue;
            formula = FieldReplaceUtil.getReplacedFarmula(formula, oldvalue, newValue);
        }
        filterSet.setFilterString(formula);
        FilterCondition filterCondition = filterSet.getFilterCondition();
        if (filterCondition == null) {
            return filterSet;
        }
        List filterRows = filterCondition.getFilterRow();
        for (SimpleFilterRow filterRow : filterRows) {
            String fieldName = filterRow.getFieldName();
            if (commonAndSourceFieldcol.containsKey(fieldName)) {
                fieldName = commonAndSourceFieldcol.get(fieldName);
            }
            filterRow.setFieldName(fieldName);
        }
        return filterSet;
    }

    public static String getReplacedFarmula(String formula, String oldvalue, String newValue) {
        String wrapReplacer;
        if (formula.equals(oldvalue)) {
            return newValue;
        }
        String rawReplacer = newValue;
        Matcher finder = null;
        finder = Pattern.compile("^" + oldvalue + "(?<suffix>[^0-9a-zA-Z])").matcher(formula);
        if (finder.find()) {
            wrapReplacer = rawReplacer + finder.group("suffix");
            formula = formula.replaceFirst("^" + oldvalue + "(?<suffix>[^0-9a-zA-Z])", wrapReplacer);
        }
        if ((finder = Pattern.compile("(?<prefix>[^0-9a-zA-Z])" + oldvalue + "$").matcher(formula)).find()) {
            wrapReplacer = finder.group("prefix") + rawReplacer;
            formula = formula.replaceFirst("(?<prefix>[^0-9a-zA-Z])" + oldvalue + "$", wrapReplacer);
        }
        finder = Pattern.compile("(?<prefix>[^0-9a-zA-Z])" + oldvalue + "(?<suffix>[^0-9a-zA-Z])").matcher(formula);
        while (finder.find()) {
            wrapReplacer = finder.group("prefix") + rawReplacer + finder.group("suffix");
            formula = formula.replaceAll("[^0-9a-zA-Z](?<key>" + oldvalue + ")[^0-9a-zA-Z]", wrapReplacer);
        }
        return formula;
    }

    public static Map<String, String> getCommonAndSourceFieldcol(String templateEntityName, String enrityNumber) {
        CacheKey cacheKey = CacheKey.getCacheKey(CacheModule.accSys, "CommonAndSourceFieldcol", templateEntityName, enrityNumber);
        Map m = LocalCacheHelper.get(cacheKey, Map.class);
        if (m == null) {
            HashMap<String, String> commonAndSourceFieldcol = new HashMap<String, String>(50);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
            qFilters.add(new QFilter("sourcebill.id", "=", (Object)templateEntityName));
            qFilters.add(new QFilter("targetbill.id", "=", (Object)enrityNumber));
            DynamicObject one = BusinessDataServiceHelper.loadSingle((String)"ai_billmapping", (String)"billbody,billbody.sourcefielddesc,billbody.targetfielddesc", (QFilter[])qFilters.toArray(new QFilter[2]));
            if (one != null) {
                DynamicObjectCollection entrys = one.getDynamicObjectCollection("billbody");
                for (DynamicObject entry : entrys) {
                    commonAndSourceFieldcol.put(entry.getString("sourcefielddesc"), entry.getString("targetfielddesc"));
                }
            }
            LocalCacheHelper.put(cacheKey, commonAndSourceFieldcol);
            return commonAndSourceFieldcol;
        }
        return m;
    }
}

