/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.ai.cache.CacheKey;
import kd.fi.ai.cache.CacheModule;
import kd.fi.ai.util.PresetCashItemUtil;

public class GLUtil {
    public static final String entityID_exchangeRate = "bd_exrate_tree";
    private static final String ACCOUNTTYPE = "local-accttype-key";

    public static Long getDefaultAcctOrg(List<Long> orgPkList) {
        HashSet<Long> orgPkSet = new HashSet<Long>(orgPkList);
        Long curLoginOrg = RequestContext.get().getOrgId();
        if (orgPkSet.contains(curLoginOrg)) {
            return curLoginOrg;
        }
        if (!orgPkList.isEmpty()) {
            return orgPkList.get(0);
        }
        return null;
    }

    public static String toSerializedString(Object obj) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(obj);
            return Base64.getEncoder().encodeToString(out.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object fromSerializedString(String s) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(s));
            ObjectInputStream is = new ObjectInputStream(in);
            return is.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static DynamicObject getPeriodByDate(Date date, long periodType) {
        String selectField = "id,periodtype.id,periodyear,periodnumber,begindate,enddate,isadjustperiod,number,name";
        DynamicObjectCollection period = GLUtil.getPeriodByDate(date, selectField, periodType);
        if (period != null && period.size() > 0) {
            return (DynamicObject)period.get(0);
        }
        return null;
    }

    public static DynamicObjectCollection getPeriodByDate(Date date, String selectField, long periodType) {
        QFilter f = new QFilter("beginDate", "<=", (Object)date);
        QFilter g = new QFilter("enddate", ">=", (Object)date);
        QFilter t = new QFilter("periodtype", "=", (Object)periodType);
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t});
        return periods;
    }

    public static List<Object> getAssistPKByOrg(Long orgId) {
        List<Long> superOrg = GLUtil.getAllSuperiorOrgIdsOrderByLevel(orgId);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("flexid", "=", (Object)2));
        QFilter allCtrl = new QFilter("ctrlstrategy", "=", (Object)"5");
        if (superOrg != null && !superOrg.isEmpty()) {
            QFilter orgFilter = new QFilter("createorg.id", "in", superOrg).and(new QFilter("ctrlstrategy", "=", (Object)"6"));
            filters.add(allCtrl.or(orgFilter));
        } else {
            filters.add(allCtrl);
        }
        return QueryServiceHelper.queryPrimaryKeys((String)"bd_asstacttype", (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1);
    }

    public static List<Long> getAllSuperiorOrgIdsOrderByLevel(long orgid) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (orgid == 0L) {
            return ids;
        }
        QFilter f2 = new QFilter("view.number", "=", (Object)"10");
        QFilter f3 = new QFilter("org", "=", (Object)orgid);
        String longNumber = "";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)GLUtil.class.getName(), (String)"bos_org_structure", (String)"longnumber", (QFilter[])new QFilter[]{f2, f3}, null);){
            if (ds.hasNext()) {
                Row row = ds.next();
                longNumber = row.getString("longnumber");
            }
        }
        if (StringUtils.isBlank((CharSequence)longNumber) || longNumber.indexOf(33) == 0) {
            return ids;
        }
        String[] numbers = StringUtils.substringBeforeLast((String)longNumber, (String)"!").split("!");
        QFilter numberFilter = new QFilter("org.number", "in", (Object)numbers);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)PresetCashItemUtil.class.getName(), (String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{f2, numberFilter}, (String)"level");){
            while (ds.hasNext()) {
                Row row = ds.next();
                ids.add(row.getLong("org"));
            }
        }
        if (!ids.contains(orgid)) {
            ids.add(orgid);
        }
        return ids;
    }

    public static DynamicObject getExchangeRateInfo(Long exchangeTableID, Long sourceCurrencyID, Long targetCurrencyID, Date date) {
        ORM orm = ORM.create();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter exchangeTableFilter = new QFilter("exctable", "=", (Object)exchangeTableID);
        filterList.add(exchangeTableFilter);
        QFilter sourceCurrencyFilter = new QFilter("orgcur", "=", (Object)sourceCurrencyID);
        filterList.add(sourceCurrencyFilter);
        QFilter targetCurrencyFilter = new QFilter("cur", "=", (Object)targetCurrencyID);
        filterList.add(targetCurrencyFilter);
        QFilter targetEnableFilter = new QFilter("enable", "=", (Object)"1");
        filterList.add(targetEnableFilter);
        if (date != null) {
            QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
            filterList.add(dateFilter);
        }
        String selectFields = "id,excval,indirectexrate,precision,foreignexcid,effectdate";
        String orderBys = "effectdate desc";
        int top = 3;
        QFilter[] filters = new QFilter[filterList.size()];
        for (int i = 0; i < filterList.size(); ++i) {
            filters[i] = (QFilter)filterList.get(i);
        }
        DynamicObjectCollection list = orm.query(entityID_exchangeRate, selectFields, filters, orderBys, top);
        if (list != null) {
            if (list.size() == 0) {
                return null;
            }
            if (list.size() == 1) {
                return (DynamicObject)list.get(0);
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
            DynamicObject[] result = new DynamicObject[3];
            String dateStr = null;
            for (DynamicObject obj : list) {
                if (dateStr != null) {
                    if (!dateStr.equals(format.format(obj.getDate("effectdate")))) break;
                    GLUtil.resolve(result, obj);
                    continue;
                }
                dateStr = format.format(obj.getDate("effectdate"));
                GLUtil.resolve(result, obj);
            }
            return result[1] != null ? result[1] : (result[0] != null ? result[0] : result[2]);
        }
        return null;
    }

    private static void resolve(DynamicObject[] result, DynamicObject obj) {
        String excid = obj.getString("foreignexcid");
        if (excid.equals("1")) {
            result[0] = obj;
        } else if (excid.equals("2")) {
            result[1] = obj;
        } else if (excid.equals("3")) {
            result[2] = obj;
        }
    }

    public static BigDecimal getExchangeRate(Long exchangeTableID, Long sourceCurrencyID, Long targetCurrencyID, Date date) {
        int precision;
        BigDecimal exchangeRate = null;
        DynamicObject rateObj = GLUtil.getExchangeRateInfo(exchangeTableID, sourceCurrencyID, targetCurrencyID, date);
        if (null != rateObj) {
            exchangeRate = rateObj.getBigDecimal("excval");
            precision = rateObj.getInt("precision");
            if (precision != 0) {
                exchangeRate = exchangeRate.setScale(precision, 4);
            }
        }
        if (exchangeRate != null) {
            return exchangeRate;
        }
        rateObj = GLUtil.getExchangeRateInfo(exchangeTableID, targetCurrencyID, sourceCurrencyID, date);
        if (null != rateObj) {
            exchangeRate = rateObj.getBigDecimal("indirectexrate");
            precision = rateObj.getInt("precision");
            if (precision != 0) {
                exchangeRate = exchangeRate.setScale(precision, 4);
            }
        }
        return exchangeRate;
    }

    public static boolean getSysBooleanParam(String paramKey, long orgId, boolean defVal) {
        AppParam param = new AppParam("83bfebc8000017ac", "10", Long.valueOf(orgId), Long.valueOf(0L));
        Object params = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)paramKey);
        boolean result = defVal;
        if (null != params) {
            result = Boolean.parseBoolean(params.toString());
        }
        return result;
    }

    public static String getFileName(String str) {
        return str;
    }

    public static Object getObjectParam(String paramKey, long orgId) {
        AppParam param = new AppParam("83bfebc8000017ac", "10", Long.valueOf(orgId), Long.valueOf(0L));
        Object result = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)paramKey);
        return result;
    }

    public static boolean getBooleanParam(String paramKey, long orgId, boolean defVal) {
        CacheKey key = CacheKey.getCacheKey(CacheModule.SYS_PARAM, paramKey, orgId, defVal);
        return (Boolean)ThreadCache.get((Object)key.toString(), () -> {
            AppParam param = new AppParam("83bfebc8000017ac", "10", Long.valueOf(orgId), Long.valueOf(0L));
            Object params = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)paramKey);
            Boolean result = defVal;
            if (null != params) {
                result = Boolean.parseBoolean(params.toString());
            }
            return result;
        });
    }

    public static Map<Long, Boolean> getAcctType() {
        HashMap<Long, Boolean> map = (HashMap<Long, Boolean>)ThreadCache.get((Object)ACCOUNTTYPE);
        if (null == map) {
            map = new HashMap<Long, Boolean>();
            DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_accounttype", (String)"id,accounttype", null);
            for (DynamicObject obj : col) {
                if ("4".equals(obj.getString("accounttype"))) {
                    map.put(obj.getLong("id"), Boolean.TRUE);
                    continue;
                }
                map.put(obj.getLong("id"), Boolean.FALSE);
            }
            ThreadCache.put((Object)ACCOUNTTYPE, map);
        }
        return map;
    }

    public static boolean isCashAcct(DynamicObject acct) {
        if (acct == null) {
            return false;
        }
        return acct.getBoolean("iscash") || acct.getBoolean("isbank") || acct.getBoolean("iscashequivalent");
    }

    public static boolean isPLAcct(DynamicObject acct) {
        if (acct == null) {
            return false;
        }
        Map<Long, Boolean> map = GLUtil.getAcctType();
        return map.get(acct.getLong("accounttype.id")) == null ? false : map.get(acct.getLong("accounttype.id"));
    }
}

