/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class SetExpandFieldValueUtil {
    public static void setExpandFieldValue(DynamicObject voucher, Map<String, Object> expandFieldValue, Long orgId) {
        IDataEntityType voucherType = voucher.getDataEntityType();
        DataEntityPropertyCollection propertys = voucherType.getProperties();
        for (Map.Entry<String, Object> entry : expandFieldValue.entrySet()) {
            String fieldKey = entry.getKey();
            if (!propertys.containsKey((Object)fieldKey)) continue;
            IDataEntityProperty prop = (IDataEntityProperty)propertys.get((Object)fieldKey);
            Class type = prop.getPropertyType();
            Object value = entry.getValue();
            if (type.equals(DynamicObject.class)) {
                if (value instanceof String) {
                    BasedataProp baseProp = (BasedataProp)prop;
                    Object baseDataID = ThreadCache.get((Object)("SetExpandFieldValueUtil" + orgId + baseProp.getBaseEntityId() + value), () -> SetExpandFieldValueUtil.loadBasedataByNumber(orgId, value, baseProp));
                    voucher.set(fieldKey + "_id", baseDataID);
                    continue;
                }
                voucher.set(fieldKey + "_id", value);
                continue;
            }
            if (type.equals(Date.class)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date date = null;
                if (value instanceof String) {
                    try {
                        date = sdf.parse(value + "");
                    }
                    catch (ParseException e) {
                        throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
                    }
                } else {
                    date = value instanceof Long ? new Date((Long)value) : (Date)value;
                }
                if (date != null) {
                    try {
                        date = sdf.parse(sdf.format(date));
                    }
                    catch (ParseException e) {
                        throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
                    }
                }
                voucher.set(fieldKey, (Object)date);
                continue;
            }
            voucher.set(fieldKey, value);
        }
    }

    private static Object loadBasedataByNumber(Long orgId, Object value, BasedataProp baseProp) {
        List id;
        String entityId = baseProp.getBaseEntityId();
        String numberProp = baseProp.getNumberProp();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(2);
        QFilter numberFilter = new QFilter(numberProp, "=", value);
        filterList.add(numberFilter);
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)orgId);
        if (orgFilter != null) {
            filterList.add(orgFilter);
        }
        return (id = QueryServiceHelper.queryPrimaryKeys((String)entityId, (QFilter[])filterList.toArray(new QFilter[0]), (String)numberProp, (int)1)).isEmpty() ? null : id.get(0);
    }
}

