/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.VchTplAcccounts;
import kd.fi.ai.VchTplAccount;
import kd.fi.ai.VchTplAccts;
import kd.fi.ai.util.AiEventMetaUtil;
import kd.fi.ai.util.BuildTree;

public class VchtemplateGetDataUtil {
    public static List<ComboItem> getAttachmentItem(MainEntityType srcMainET, boolean isevent) {
        ArrayList<ComboItem> result = new ArrayList<ComboItem>(8);
        if (srcMainET == null) {
            return result;
        }
        String currLCId = Lang.get().toString();
        for (IDataEntityProperty prop : srcMainET.getProperties()) {
            ComboItem item;
            if (isevent) {
                if (!(prop instanceof DecimalProp) || !StringUtils.isNotEmpty((CharSequence)prop.getAlias())) continue;
                DecimalProp decimalProp = (DecimalProp)prop;
                item = new ComboItem();
                item.setValue(decimalProp.getName());
                item.setCaption(new LocaleString(currLCId, VchtemplateGetDataUtil.buildPropCaption((DynamicProperty)decimalProp)));
                result.add(item);
                continue;
            }
            if (!(prop instanceof IntegerProp) || !StringUtils.isNotEmpty((CharSequence)prop.getAlias())) continue;
            IntegerProp intProp = (IntegerProp)prop;
            item = new ComboItem();
            item.setValue(intProp.getName());
            item.setCaption(new LocaleString(currLCId, VchtemplateGetDataUtil.buildPropCaption((DynamicProperty)intProp)));
            result.add(item);
        }
        return result;
    }

    public static List<ComboItem> getRateItem(MainEntityType srcMainET) {
        ArrayList<ComboItem> result = new ArrayList<ComboItem>(8);
        if (srcMainET == null) {
            return result;
        }
        ArrayList<DynamicProperty> rateProps = new ArrayList<DynamicProperty>(8);
        VchtemplateGetDataUtil.searchCyRateProps((IDataEntityType)srcMainET, rateProps);
        String currLCId = Lang.get().toString();
        for (DynamicProperty rateProp : rateProps) {
            ComboItem item = new ComboItem();
            item.setValue(VchtemplateGetDataUtil.getFieldSelector(rateProp));
            item.setCaption(new LocaleString(currLCId, VchtemplateGetDataUtil.buildPropCaption(rateProp)));
            result.add(item);
        }
        return result;
    }

    public static List<ComboItem> getCurrencyItem(MainEntityType srcMainET) {
        ArrayList<ComboItem> result = new ArrayList<ComboItem>(8);
        if (srcMainET == null) {
            return result;
        }
        ArrayList<BasedataProp> currencyProps = new ArrayList<BasedataProp>(8);
        VchtemplateGetDataUtil.searchCurrencyProps((IDataEntityType)srcMainET, currencyProps);
        String currLCId = Lang.get().toString();
        String name = srcMainET.getName();
        for (BasedataProp bdProp : currencyProps) {
            ComboItem item = new ComboItem();
            item.setValue(VchtemplateGetDataUtil.additionCurrencyValue(VchtemplateGetDataUtil.getFieldSelector((DynamicProperty)bdProp), name));
            item.setCaption(new LocaleString(currLCId, VchtemplateGetDataUtil.buildPropCaption((DynamicProperty)bdProp)));
            result.add(item);
        }
        return result;
    }

    public static String additionCurrencyValue(String cv, String billtype) {
        if (cv == null || cv.equals("@bookCurrencyID")) {
            return cv;
        }
        return cv + "-dap-" + billtype;
    }

    public static String deletionCurrencyValue(String cv) {
        if (cv == null) {
            return cv;
        }
        String[] c = cv.split("-dap-");
        return c[0];
    }

    public static String buildPropCaption(DynamicProperty prop) {
        EntityType parentType = (EntityType)prop.getParent();
        String parentName = ResManager.loadKDString((String)"\u5355\u636e\u4f53", (String)"VchtemplateGetDataUtil_0", (String)"fi-ai-common", (Object[])new Object[0]);
        if (parentType.getDisplayName() != null) {
            parentName = parentType.getDisplayName().toString();
        }
        String propName = prop.getDisplayName() != null ? prop.getDisplayName().toString() : VchtemplateGetDataUtil.getFieldSelector(prop);
        String caption = String.format("%s.%s", parentName, propName);
        return caption;
    }

    public static String getFieldSelector(DynamicProperty rateProp) {
        String selector = rateProp.getName();
        if (rateProp.getParent() != null && rateProp.getParent().getParent() != null && rateProp.getParent().getParent().getParent() != null && rateProp.getParent().getParent().getParent().getParent() == null) {
            selector = rateProp.getParent().getParent().getName() + "." + rateProp.getParent().getName() + "." + selector;
        }
        return selector;
    }

    private static void searchCurrencyProps(IDataEntityType entityType, List<BasedataProp> currencyProps) {
        for (IDataEntityProperty prop : entityType.getProperties()) {
            BasedataProp bdProp;
            if (prop instanceof EntryProp) {
                VchtemplateGetDataUtil.searchCurrencyProps(((EntryProp)prop).getItemType(), currencyProps);
                continue;
            }
            if (!(prop instanceof BasedataProp) || (bdProp = (BasedataProp)prop).getBaseEntityId() == null || !bdProp.getBaseEntityId().equalsIgnoreCase("bd_currency") || !StringUtils.isNotEmpty((CharSequence)prop.getAlias())) continue;
            currencyProps.add(bdProp);
        }
    }

    private static void searchCyRateProps(IDataEntityType entityType, List<DynamicProperty> cyRateProps) {
        for (IDataEntityProperty prop : entityType.getProperties()) {
            String caption;
            LocaleString displayName;
            if (prop instanceof EntryProp) {
                VchtemplateGetDataUtil.searchCyRateProps(((EntryProp)prop).getItemType(), cyRateProps);
                continue;
            }
            if (!(prop instanceof DynamicProperty) || (displayName = ((DynamicProperty)prop).getDisplayName()) == null || !StringUtils.isNotEmpty((CharSequence)displayName.toString()) || (caption = displayName.toString()).indexOf(ResManager.loadKDString((String)"\u6c47\u7387", (String)"VchtemplateGetDataUtil_1", (String)"fi-ai-common", (Object[])new Object[0])) < 0 || caption.indexOf(ResManager.loadKDString((String)"\u6c47\u7387\u7c7b\u578b", (String)"VchtemplateGetDataUtil_2", (String)"fi-ai-common", (Object[])new Object[0])) >= 0 || !(prop instanceof DecimalProp) || !StringUtils.isNotEmpty((CharSequence)prop.getAlias())) continue;
            cyRateProps.add((DynamicProperty)prop);
        }
    }

    public static MainEntityType readEntrySrcMainEntityType(Object mainSrcBill, String belongSrc, String belongSrcs, boolean isEvent) {
        if (mainSrcBill == null || StringUtils.isEmpty((CharSequence)mainSrcBill.toString())) {
            return null;
        }
        MainEntityType srcMainET = null;
        if (isEvent) {
            srcMainET = AiEventMetaUtil.getEntityType(mainSrcBill);
        } else {
            String srcBillNumber = (String)mainSrcBill;
            if (StringUtils.isNotEmpty((CharSequence)belongSrc) && !"null".equals(belongSrc)) {
                srcBillNumber = belongSrc;
            } else if (StringUtils.isNotEmpty((CharSequence)belongSrcs) && !"null".equals(belongSrcs)) {
                srcBillNumber = belongSrcs;
            }
            if (srcBillNumber.endsWith("-voucher")) {
                srcBillNumber = "gl_voucher";
            }
            srcMainET = EntityMetadataCache.getDataEntityType((String)srcBillNumber);
        }
        return srcMainET;
    }

    public static String getAcctName(VchTplAccts acct, MainEntityType mainType) {
        String acctName = acct.getAcctName();
        if (acct.getSourcetype() == null) {
            return acctName;
        }
        switch (acct.getSourcetype()) {
            case "fix": {
                DynamicObject accDO = "0".equals(acct.getHandinput()) ? BusinessDataServiceHelper.loadSingleFromCache((Object)acct.getConstid(), (String)"bd_accountview", (String)"number,name") : BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountview", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)acct.getAcctNumber())});
                acctName = Optional.ofNullable(accDO).map(obj -> obj.getString("number") + obj.getString("name")).orElse(acctName);
                break;
            }
            case "mapping": {
                DynamicObject mapDO = BusinessDataServiceHelper.loadSingleFromCache((Object)acct.getMappingid(), (String)"ai_accountmaptype", (String)"name");
                acctName = Optional.ofNullable(mapDO).map(obj -> mapDO.getString("name")).orElse(acctName);
                break;
            }
            case "exp": {
                if (!StringUtils.isEmpty((CharSequence)acctName)) break;
                acctName = Optional.ofNullable(BuildTree.tranExpression(acct.getExp(), mainType)).orElse(acctName);
                break;
            }
            case "conditionexp": {
                VchTplAcccounts vchTplAcccounts = acct.getVchTplAcccounts();
                List accIds = Optional.ofNullable(vchTplAcccounts.getItems()).map(items -> items.stream().map(VchTplAccount::getAccountid).collect(Collectors.toList())).orElseGet(() -> new ArrayList(2));
                Map tplAccs = BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)accIds)});
                acctName = tplAccs.values().stream().map(obj -> obj.getString("number") + obj.getString("name")).collect(Collectors.joining("/"));
                break;
            }
            case "commonmapping": {
                long flexMappingId = acct.getFlexMappingId();
                DynamicObject flexMapDO = BusinessDataServiceHelper.loadSingleFromCache((Object)flexMappingId, (String)"fah_valmap_typenew", (String)"name");
                acctName = Optional.ofNullable(flexMapDO).map(obj -> obj.getString("name")).orElse(acctName);
            }
        }
        return acctName;
    }
}

