/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ai.AccountView;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.mservice.builder.buildresult.GLVoucher;
import kd.fi.ai.mservice.builder.buildresult.GLVoucherEntry;
import kd.fi.ai.mservice.dao.BaseDataLoader;
import kd.fi.bd.util.CashflowLocalSetUtil;
import kd.fi.v2.fah.utils.ParamUtils;

public class VoucherCashFlowUtils {
    private static Log logger = LogFactory.getLog(VoucherCashFlowUtils.class);
    private static final String algoKey = "kd.fi.ai.util.VoucherCashFlowUtils";
    private static final String query_sql_cashflow = "select fentryid,faccountid,fmaincfitemid from t_gl_voucherentry where fid = ? and (fsuppcfitemid!=0 or fsuppcfamount!=0)";

    public static void processCashFlowItem(GLVoucher glVoucher, IBuildVchContext context) {
        VoucherCashFlowUtils.clearMainAndSup(glVoucher);
        List<GLVoucherEntry> allRows = glVoucher.getEntryRows();
        for (GLVoucherEntry row : allRows) {
            if (row.isCashAcct()) {
                glVoucher.setHasCashAcct(true);
                continue;
            }
            if (BaseDataLoader.loadAccount(context, row.getAccountId()).isIssunyi()) {
                glVoucher.setHasSyAcct(true);
                continue;
            }
            glVoucher.setHasNcNpAcct(true);
        }
    }

    public static void clearCashFlowAndSupData(GLVoucher glvoucher, IBuildVchContext context, boolean isWriteLog) {
        if (glvoucher == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        VoucherCashFlowUtils.clearMainAndSup(glvoucher);
        boolean isLocalSet = CashflowLocalSetUtil.isLocalSetThread((long)glvoucher.getOrgId(), (Date)glvoucher.getBookedDate());
        String curr_voucher_type = VoucherCashFlowUtils.calculation_curr_voucher_type(glvoucher, context);
        if (isWriteLog) {
            logger.info("--DAP--clearCashFlowAndSupData:isLocalSet:" + isLocalSet + ";curr_voucher_type:" + curr_voucher_type);
        }
        switch (curr_voucher_type) {
            case "A": {
                VoucherCashFlowUtils.clearAllCashFlowAndSupItemData(glvoucher);
                break;
            }
            case "B": 
            case "C": {
                if (ParamUtils.isGenVoucherNoClear()) break;
                VoucherCashFlowUtils.clearAllCashFlowAndSupItemData(glvoucher);
                break;
            }
            case "D": 
            case "G": 
            case "E": {
                VoucherCashFlowUtils.clearCashFlowAndSupItemData_Model_G(glvoucher, context, isLocalSet);
                break;
            }
            case "F": {
                if (ParamUtils.isGenVoucherNoClear()) break;
                VoucherCashFlowUtils.clearCashFlowAndSupItemData_Model_F(glvoucher, context, isLocalSet);
            }
        }
        if (isWriteLog) {
            logger.info("--DAP--clearCashFlowAndSupData:--end:voucherId" + glvoucher.getId() + ";time:" + (System.currentTimeMillis() - startTime));
        }
    }

    private static void clearMainAndSup(GLVoucher glvoucher) {
        List<GLVoucherEntry> allrows = glvoucher.getEntryRows();
        for (GLVoucherEntry row : allrows) {
            if (row.getAccountId() != 0L) continue;
            row.setMaincfitemID(0L);
            row.setMaincfamount(BigDecimal.ZERO);
            row.setMaincfassgrp(0L);
            row.setSupcfitemID(0L);
            row.setSupcfamount(BigDecimal.ZERO);
        }
    }

    private static void clearCashFlowAndSupItemData_Model_F(GLVoucher glvoucher, IBuildVchContext context, boolean isLocalSet) {
        List<GLVoucherEntry> allrows = glvoucher.getEntryRows();
        for (GLVoucherEntry row : allrows) {
            row.setMaincfitemID(0L);
            row.setMaincfamount(BigDecimal.ZERO);
            row.setMaincfassgrp(0L);
            if (BaseDataLoader.loadAccount(context, row.getAccountId()).isIssunyi()) {
                if (isLocalSet) continue;
                row.setSupcfitemID(0L);
                row.setSupcfamount(BigDecimal.ZERO);
                continue;
            }
            if (!isLocalSet) continue;
            row.setSupcfitemID(0L);
            row.setSupcfamount(BigDecimal.ZERO);
        }
        if (glvoucher.isPreSaveEntry()) {
            DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)"update t_gl_voucherentry set fmaincfitemid=0,fmaincfamount=0,fmaincfassgrpid=0 where fid=?", (Object[])new Object[]{glvoucher.getId()});
            HashSet<Long> need_del_entryids = new HashSet<Long>();
            try (DataSet queryDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"fi"), (String)query_sql_cashflow, (Object[])new Object[]{glvoucher.getId()});){
                for (Row row : queryDataSet) {
                    Long acctId = row.getLong("faccountid");
                    if (BaseDataLoader.loadAccount(context, acctId).isIssunyi()) {
                        if (isLocalSet) continue;
                        need_del_entryids.add(row.getLong("fentryid"));
                        continue;
                    }
                    if (!isLocalSet) continue;
                    need_del_entryids.add(row.getLong("fentryid"));
                }
            }
            if (!need_del_entryids.isEmpty()) {
                VoucherCashFlowUtils.clearSupItem(need_del_entryids);
            }
        }
    }

    private static void clearCashFlowAndSupItemData_Model_G(GLVoucher glvoucher, IBuildVchContext context, boolean isLocalSet) {
        List<GLVoucherEntry> allrows = glvoucher.getEntryRows();
        for (GLVoucherEntry row : allrows) {
            if (isLocalSet) {
                if (row.isCashAcct()) {
                    if (row.getMaincfitemID() != 0L && (row.getMaincfitemID() == 0L || BaseDataLoader.loadCashflowItem(context, row.getMaincfitemID()).isIsdealactivity())) continue;
                    row.setSupcfitemID(0L);
                    row.setSupcfamount(BigDecimal.ZERO);
                    continue;
                }
                if (BaseDataLoader.loadAccount(context, row.getAccountId()).isIssunyi()) {
                    row.setMaincfitemID(0L);
                    row.setMaincfamount(BigDecimal.ZERO);
                    row.setMaincfassgrp(0L);
                    continue;
                }
                row.setMaincfitemID(0L);
                row.setMaincfamount(BigDecimal.ZERO);
                row.setMaincfassgrp(0L);
                row.setSupcfitemID(0L);
                row.setSupcfamount(BigDecimal.ZERO);
                continue;
            }
            if (row.isCashAcct()) {
                row.setMaincfitemID(0L);
                row.setMaincfamount(BigDecimal.ZERO);
                row.setMaincfassgrp(0L);
                row.setSupcfitemID(0L);
                row.setSupcfamount(BigDecimal.ZERO);
                continue;
            }
            if (BaseDataLoader.loadAccount(context, row.getAccountId()).isIssunyi()) {
                if (row.getMaincfitemID() != 0L && (row.getMaincfitemID() == 0L || !BaseDataLoader.loadCashflowItem(context, row.getMaincfitemID()).isIsdealactivity())) continue;
                row.setSupcfitemID(0L);
                row.setSupcfamount(BigDecimal.ZERO);
                continue;
            }
            if (row.getMaincfitemID() != 0L && (row.getMaincfitemID() == 0L || BaseDataLoader.loadCashflowItem(context, row.getMaincfitemID()).isIsdealactivity())) continue;
            row.setSupcfitemID(0L);
            row.setSupcfamount(BigDecimal.ZERO);
        }
        if (glvoucher.isPreSaveEntry()) {
            HashSet<Long> need_del_entryids_main = new HashSet<Long>();
            HashSet<Long> need_del_entryids_sup = new HashSet<Long>();
            try (DataSet queryDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"fi"), (String)query_sql_cashflow, (Object[])new Object[]{glvoucher.getId()});){
                for (Row row : queryDataSet) {
                    Long entryId = row.getLong("fentryid");
                    Long acctId = row.getLong("faccountid");
                    Long maincfitemId = row.getLong("fmaincfitemid");
                    AccountView loadAccount = BaseDataLoader.loadAccount(context, acctId);
                    if (loadAccount.isIscash() || loadAccount.isIsbank() || loadAccount.isIscashequivalent()) {
                        if (isLocalSet) {
                            if (maincfitemId != 0L && (maincfitemId == 0L || BaseDataLoader.loadCashflowItem(context, maincfitemId).isIsdealactivity())) continue;
                            need_del_entryids_sup.add(entryId);
                            continue;
                        }
                        need_del_entryids_main.add(entryId);
                        need_del_entryids_sup.add(entryId);
                        continue;
                    }
                    if (loadAccount.isIssunyi()) {
                        if (isLocalSet) {
                            need_del_entryids_main.add(entryId);
                            continue;
                        }
                        if (maincfitemId != 0L && (maincfitemId == 0L || !BaseDataLoader.loadCashflowItem(context, maincfitemId).isIsdealactivity())) continue;
                        need_del_entryids_sup.add(entryId);
                        continue;
                    }
                    if (isLocalSet) {
                        need_del_entryids_main.add(entryId);
                        need_del_entryids_sup.add(entryId);
                        continue;
                    }
                    if (maincfitemId != 0L && (maincfitemId == 0L || BaseDataLoader.loadCashflowItem(context, maincfitemId).isIsdealactivity())) continue;
                    need_del_entryids_sup.add(entryId);
                }
            }
            if (!need_del_entryids_main.isEmpty()) {
                VoucherCashFlowUtils.clearMainItem(need_del_entryids_main);
            }
            if (!need_del_entryids_sup.isEmpty()) {
                VoucherCashFlowUtils.clearSupItem(need_del_entryids_sup);
            }
        }
    }

    private static void clearAllCashFlowAndSupItemData(GLVoucher glvoucher) {
        List<GLVoucherEntry> allrows = glvoucher.getEntryRows();
        for (GLVoucherEntry row : allrows) {
            row.setMaincfitemID(0L);
            row.setMaincfamount(BigDecimal.ZERO);
            row.setMaincfassgrp(0L);
            row.setSupcfitemID(0L);
            row.setSupcfamount(BigDecimal.ZERO);
        }
        if (glvoucher.isPreSaveEntry()) {
            DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)"update t_gl_voucherentry set fmaincfitemid=0,fmaincfamount=0,fmaincfassgrpid=0,fsuppcfitemid=0,fsuppcfamount=0 where fid=?", (Object[])new Object[]{glvoucher.getId()});
        }
    }

    private static void clearSupItem(Set<Long> entryIds) {
        if (entryIds != null && entryIds.size() > 0) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(32);
            for (Long me : entryIds) {
                Object[] param = new Object[]{me};
                params.add(param);
                if (params.size() < 10000) continue;
                VoucherCashFlowUtils.batchExecuteSql(DBRoute.of((String)"gl"), "update t_gl_voucherentry set fsuppcfitemid=0,fsuppcfamount=0  where fentryid = ?", params);
                params.clear();
            }
            if (params.size() > 0) {
                VoucherCashFlowUtils.batchExecuteSql(DBRoute.of((String)"gl"), "update t_gl_voucherentry set fsuppcfitemid=0,fsuppcfamount=0  where fentryid = ?", params);
            }
        }
    }

    private static void clearMainItem(Set<Long> entryIds) {
        if (entryIds != null && entryIds.size() > 0) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(32);
            for (Long me : entryIds) {
                Object[] param = new Object[]{me};
                params.add(param);
                if (params.size() < 10000) continue;
                VoucherCashFlowUtils.batchExecuteSql(DBRoute.of((String)"gl"), "update t_gl_voucherentry set fmaincfitemid=0,fmaincfamount=0,fmaincfassgrpid=0  where fentryid = ?", params);
                params.clear();
            }
            if (params.size() > 0) {
                VoucherCashFlowUtils.batchExecuteSql(DBRoute.of((String)"gl"), "update t_gl_voucherentry set fmaincfitemid=0,fmaincfamount=0,fmaincfassgrpid=0  where fentryid = ?", params);
            }
        }
    }

    private static void batchExecuteSql(DBRoute db, String sql, List<Object[]> params) {
        DB.executeBatch((DBRoute)db, (String)sql, params);
    }

    private static String calculation_curr_voucher_type(GLVoucher glvoucher, IBuildVchContext context) {
        boolean hasNcNpAcct;
        if (glvoucher == null) {
            return "I";
        }
        List<GLVoucherEntry> allRows = glvoucher.getEntryRows();
        Long cash_entry_size = allRows.stream().filter(f -> f.isCashAcct()).count();
        Long sy_entry_size = allRows.stream().filter(f -> BaseDataLoader.loadAccount(context, f.getAccountId()).isIssunyi()).count();
        boolean hasCashAcct = glvoucher.isHasCashAcct() || cash_entry_size > 0L;
        boolean hasSyAcct = glvoucher.isHasSyAcct() || sy_entry_size > 0L;
        boolean bl = hasNcNpAcct = glvoucher.isHasNcNpAcct() || cash_entry_size + sy_entry_size < (long)allRows.size();
        if (hasCashAcct) {
            if (hasSyAcct) {
                if (hasNcNpAcct) {
                    return "G";
                }
                return "D";
            }
            if (hasNcNpAcct) {
                return "E";
            }
            return "A";
        }
        if (hasSyAcct) {
            if (hasNcNpAcct) {
                return "F";
            }
            return "B";
        }
        return "C";
    }
}

