/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.cache.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.fi.v2.fah.cache.common.ITaskResultCacheManager;
import kd.fi.v2.fah.utils.FahSerializeHelper;

public class SimpleDataDistributeCacheService
implements ITaskResultCacheManager {
    private static final DistributeSessionlessCache cacheInstance = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("fah");
    private static final SimpleDataDistributeCacheService instance = new SimpleDataDistributeCacheService();

    public static SimpleDataDistributeCacheService getInstance() {
        return instance;
    }

    public <T> List<T> getValueList(Object cacheKey, Function<String, ? extends T> mapper) {
        String[] idStringArray = cacheInstance.getList(String.valueOf(cacheKey));
        if (idStringArray == null || idStringArray.length == 0) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.stream(idStringArray).map(mapper).collect(Collectors.toList());
    }

    public <T> int putValueList(Object cacheKey, Collection<? extends T> values, Function<T, String> mapper, int timeout, TimeUnit timeUnit) {
        if (cacheKey == null || values == null || values.isEmpty()) {
            return 0;
        }
        String[] idStr = new String[values.size()];
        int i = 0;
        for (T v : values) {
            if (v == null) continue;
            idStr[i++] = mapper.apply(v);
        }
        return timeout <= 0 ? cacheInstance.addList(String.valueOf(cacheKey), idStr) : cacheInstance.addList(String.valueOf(cacheKey), idStr, timeout, timeUnit == null ? TimeUnit.SECONDS : timeUnit);
    }

    public List<Long> getIDList(Object cacheKey) {
        return this.getValueList(cacheKey, Long::parseLong);
    }

    public int putIDList(Object cacheKey, Collection<Long> ids, int timeout, TimeUnit timeUnit) {
        return this.putValueList(cacheKey, ids, String::valueOf, timeout, timeUnit);
    }

    public int putIDList(Object cacheKey, Collection<Long> ids, int timeout) {
        return this.putValueList(cacheKey, ids, String::valueOf, timeout, TimeUnit.SECONDS);
    }

    public int putIDList(Object cacheKey, Collection<Long> ids) {
        return this.putValueList(cacheKey, ids, String::valueOf, -1, TimeUnit.SECONDS);
    }

    public boolean put(Object cacheTypeKey, Object cacheKey, Object srcObject, int timeout, TimeUnit timeUnit) {
        String outputValue;
        if (cacheKey == null || srcObject == null) {
            return false;
        }
        String string = outputValue = srcObject instanceof String ? (String)srcObject : FahSerializeHelper.getInstance().toJSONString(srcObject);
        if (timeout <= 0) {
            if (cacheTypeKey == null) {
                cacheInstance.put(String.valueOf(cacheKey), (Object)outputValue);
            } else {
                cacheInstance.put(String.valueOf(cacheTypeKey), String.valueOf(cacheKey), (Object)outputValue);
            }
        } else if (cacheTypeKey == null) {
            cacheInstance.put(String.valueOf(cacheKey), (Object)outputValue, timeout, timeUnit == null ? TimeUnit.SECONDS : timeUnit);
        } else {
            cacheInstance.put(String.valueOf(cacheTypeKey), String.valueOf(cacheKey), outputValue, timeout, timeUnit == null ? TimeUnit.SECONDS : timeUnit);
        }
        return true;
    }

    @Override
    public boolean put(Object cacheTypeKey, Object cacheKey, Object srcObject, int timeout) {
        return this.put(cacheTypeKey, cacheKey, srcObject, timeout, TimeUnit.SECONDS);
    }

    @Override
    public boolean put(Object cacheTypeKey, Object cacheKey, Object srcObject) {
        return this.put(cacheTypeKey, cacheKey, srcObject, -1, TimeUnit.SECONDS);
    }

    public boolean putEx(Object cacheKey, Object srcObject, int timeout) {
        return this.put(null, cacheKey, srcObject, timeout, TimeUnit.SECONDS);
    }

    public boolean putEx(Object cacheKey, Object srcObject) {
        return this.put(null, cacheKey, srcObject, -1, TimeUnit.SECONDS);
    }

    @Override
    public void put(String cacheKey, Object srcObject) {
        this.putEx(cacheKey, srcObject);
    }

    @Override
    public void put(String cacheKey, Object srcObject, int timeout) {
        this.putEx(cacheKey, srcObject, timeout);
    }

    public int getListLength(Object key) {
        return cacheInstance.getListLength(String.valueOf(key));
    }

    @Override
    public <T> T get(Object cacheTypeKey, Object cacheKey, Class<T> srcObjectClassType) {
        String cacheValue;
        if (cacheKey == null || srcObjectClassType == null) {
            return null;
        }
        String string = cacheValue = cacheTypeKey == null ? (String)cacheInstance.get(String.valueOf(cacheKey)) : (String)cacheInstance.get(String.valueOf(cacheTypeKey), String.valueOf(cacheKey));
        if (String.class.isAssignableFrom(srcObjectClassType) || Object.class.equals(srcObjectClassType)) {
            return (T)cacheValue;
        }
        return cacheValue == null ? null : (T)FahSerializeHelper.getInstance().parse(cacheValue, srcObjectClassType);
    }

    public <T> T getEx(Object cacheKey, Class<T> srcObjectClassType) {
        return this.get(null, cacheKey, srcObjectClassType);
    }

    @Override
    public <T> T get(String cacheKey, Class<T> srcObjectClassType) {
        return this.getEx(cacheKey, srcObjectClassType);
    }

    @Override
    public String getString(String cacheKey) {
        return this.getEx(cacheKey, String.class);
    }

    @Override
    public Object get(String cacheKey) {
        return this.getEx(cacheKey, String.class);
    }

    @Override
    public <T> T getAndRemove(Object cacheTypeKey, Object cacheKey, Class<T> srcObjectClassType) {
        T result = this.get(cacheTypeKey, cacheKey, srcObjectClassType);
        if (result != null) {
            this.remove(cacheTypeKey, cacheKey);
        }
        return result;
    }

    public void removeEx(Object key) {
        cacheInstance.remove(String.valueOf(key));
    }

    public void remove(String[] keys) {
        cacheInstance.remove(keys);
    }

    @Override
    public void remove(Object type, Object key) {
        cacheInstance.remove(String.valueOf(type), String.valueOf(key));
    }

    public void remove(String type, String[] keys) {
        cacheInstance.remove(String.valueOf(type), keys);
    }

    @Override
    public void remove(String cacheKey) {
        cacheInstance.remove(cacheKey);
    }

    public void removeType(Object type) {
        cacheInstance.remove(String.valueOf(type));
    }

    @Override
    @Deprecated
    public void clear() {
    }

    public boolean contains(Object key) {
        return cacheInstance.contains(String.valueOf(key));
    }

    public boolean contains(Object type, String key) {
        return cacheInstance.contains(String.valueOf(type), String.valueOf(key));
    }

    public List<String> getKeys(Object type) {
        return cacheInstance.getKeys(String.valueOf(type));
    }

    public List<String> getKeysWithPrefix(Object type, String prefix) {
        return cacheInstance.getKeysWithPrefix(String.valueOf(type), prefix);
    }

    public List<String> getKeysWithPrefix(String prefix) {
        return cacheInstance.getKeysWithPrefix(prefix);
    }

    public long inc(Object key, int timeoutSeconds) {
        return this.inc(String.valueOf(key), timeoutSeconds, TimeUnit.SECONDS);
    }

    public long decr(Object key, int timeout, TimeUnit timeUnit) {
        return cacheInstance.decr(String.valueOf(key), timeout, timeUnit == null ? TimeUnit.SECONDS : timeUnit);
    }

    public long decr(Object key, int timeoutSeconds) {
        return this.decr(String.valueOf(key), timeoutSeconds, TimeUnit.SECONDS);
    }

    public long inc(Object key, int timeout, TimeUnit timeUnit) {
        return cacheInstance.inc(String.valueOf(key), timeout, timeUnit == null ? TimeUnit.SECONDS : timeUnit);
    }

    public long inc(Object key) {
        return cacheInstance.inc(String.valueOf(key));
    }

    public long incrBy(Object key, int amount) {
        return cacheInstance.incrBy(String.valueOf(key), amount);
    }

    public long decr(Object key) {
        return cacheInstance.decr(String.valueOf(key));
    }

    @Override
    public String buildCacheTypeKey(Object cacheType, Object ... prefixParams) {
        return ITaskResultCacheManager.super.buildCacheTypeKey(cacheType, prefixParams);
    }
}

