/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.cache.common.impl;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kd.fi.v2.fah.cache.common.FahCacheUtilHelper;
import kd.fi.v2.fah.cache.common.IFahTaskProcessDataCacheContext;
import kd.fi.v2.fah.cache.common.ITaskResultCacheManager;
import kd.fi.v2.fah.cache.common.config.CacheDataConfigFactory;
import kd.fi.v2.fah.cache.common.impl.FahTaskProcessDataCacheStorage;
import kd.fi.v2.fah.task.enums.FahTaskGrpTypeEnum;

public class FahTaskProcessDataCacheContext
implements IFahTaskProcessDataCacheContext {
    private static final CacheDataConfigFactory _CacheCfgFactory = CacheDataConfigFactory.instance;
    protected long requestId;
    protected ITaskResultCacheManager distributedCacheEntry;
    protected Map<String, FahTaskProcessDataCacheStorage> cacheStorage;
    protected Map<FahTaskGrpTypeEnum, Set<String>> taskGrpTypeCacheIndexMap;

    public FahTaskProcessDataCacheContext(long requestId, ITaskResultCacheManager distributedCacheEntry) {
        this.requestId = requestId;
        this.distributedCacheEntry = distributedCacheEntry;
        this.cacheStorage = new ConcurrentHashMap<String, FahTaskProcessDataCacheStorage>(4);
        this.taskGrpTypeCacheIndexMap = new ConcurrentHashMap<FahTaskGrpTypeEnum, Set<String>>(4);
    }

    @Override
    public <T extends Serializable> FahTaskProcessDataCacheStorage registerCacheType(FahTaskGrpTypeEnum taskGrpType, Class<T> cacheDataClass) {
        String cacheTypeKey = FahCacheUtilHelper.buildCacheTypeKey(cacheDataClass.getSimpleName(), this.requestId);
        FahTaskProcessDataCacheStorage storage = new FahTaskProcessDataCacheStorage(this.requestId, cacheTypeKey, cacheDataClass, _CacheCfgFactory.getOrDefault(cacheTypeKey), this.distributedCacheEntry);
        storage.setTaskGrpType(taskGrpType);
        this.taskGrpTypeCacheIndexMap.computeIfAbsent(taskGrpType, v -> new HashSet(1)).add(cacheTypeKey);
        return this.cacheStorage.computeIfAbsent(cacheTypeKey, v -> storage);
    }

    @Override
    public FahTaskProcessDataCacheStorage getByClassType(Class cacheDataClass) {
        String cacheTypeKey = FahCacheUtilHelper.buildCacheTypeKey(cacheDataClass.getSimpleName(), this.requestId);
        return this.cacheStorage.get(cacheTypeKey);
    }

    @Override
    public void accessTaskGrpCacheStorage(FahTaskGrpTypeEnum taskGrpType, Function<FahTaskProcessDataCacheStorage, Boolean> consumerFunc) {
        String key;
        FahTaskProcessDataCacheStorage storage;
        Set<String> storageKeyList = this.taskGrpTypeCacheIndexMap.get((Object)taskGrpType);
        Iterator<String> iterator = storageKeyList.iterator();
        while (iterator.hasNext() && ((storage = this.cacheStorage.get(key = iterator.next())) == null || consumerFunc.apply(storage).booleanValue())) {
        }
    }

    @Override
    public FahTaskProcessDataCacheStorage removeByClassType(Class cacheDataClass) {
        String cacheTypeKey = FahCacheUtilHelper.buildCacheTypeKey(cacheDataClass.getSimpleName(), this.requestId);
        return this.cacheStorage.remove(cacheTypeKey);
    }

    @Override
    public void removeByTaskGrpType(FahTaskGrpTypeEnum taskGrpType) {
        Set<String> storageKeyList = this.taskGrpTypeCacheIndexMap.get((Object)taskGrpType);
        for (String cacheTypeKey : storageKeyList) {
            this.cacheStorage.remove(cacheTypeKey);
        }
    }

    public FahTaskProcessDataCacheStorage getWaitingDataCacheStorage(FahTaskGrpTypeEnum taskGrpType) {
        return null;
    }

    @Override
    public void clear() {
        this.cacheStorage.clear();
    }

    @Override
    public int size() {
        return this.cacheStorage.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cacheStorage.isEmpty();
    }

    @Override
    public ITaskResultCacheManager getDistributedCacheEntry() {
        return this.distributedCacheEntry;
    }

    @Override
    public void setDistributedCacheEntry(ITaskResultCacheManager distributedCacheEntry) {
        this.distributedCacheEntry = distributedCacheEntry;
    }
}

