/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.constant;

import java.util.Locale;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;

public enum MasterDataGroupTypeEnum {
    Base_Prop(0, null),
    Assist_Prop(1, "bos_assistantdata_detail"),
    GL_Account(2, "bd_accountview");

    final int code;
    final String defaultEntityName;

    private MasterDataGroupTypeEnum(int code, String defaultEntityName) {
        this.code = code;
        this.defaultEntityName = defaultEntityName;
    }

    public int getCode() {
        return this.code;
    }

    public String getDefaultEntityName() {
        return this.defaultEntityName;
    }

    public static MasterDataGroupTypeEnum parse(String entityName) {
        if (entityName == null) {
            return null;
        }
        switch (entityName.toLowerCase(Locale.ROOT)) {
            case "bos_assistantdata_detail": {
                return Assist_Prop;
            }
            case "bd_accountview": {
                return GL_Account;
            }
        }
        return Base_Prop;
    }

    public static MasterDataGroupTypeEnum convert(DataValueTypeEnum dataValueType) {
        if (dataValueType != null) {
            switch (dataValueType) {
                case AssistProp: {
                    return Assist_Prop;
                }
                case Kingdee_AccountTable: {
                    return GL_Account;
                }
                case Kingdee_CashFlow: 
                case Kingdee_AcctAssistDim: 
                case BaseProp: {
                    return Base_Prop;
                }
            }
        }
        return null;
    }

    public static boolean isMasterDataType(DataValueTypeEnum dataValueType) {
        return MasterDataGroupTypeEnum.convert(dataValueType) != null;
    }
}

