/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.constant.enums;

import java.util.Locale;
import kd.fi.bd.consts.IByteCodeEnum;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.utils.StringUtils;

public enum DataValueTypeEnum implements IByteCodeEnum<DataValueTypeEnum>
{
    Date(0, "DateAttr", 2),
    BaseProp(1, "IDAttr", 0),
    AssistProp(2, "IDAttr", 0),
    Decimal(3, "NumAttr", 3),
    Int(4, "IDAttr", 0),
    Bool(5, "CharAttr", 4),
    String(6, "TxtAttr", 1),
    Amount(7, "NumAttr", 3),
    Combo(8, "TxtAttr", 1),
    FahValueSet(20, "TxtAttr", 1),
    Kingdee_AccountTable(21, "TxtAttr", 1),
    Kingdee_AcctAssistDim(22, "IDAttr", 0),
    Kingdee_BillDropDownList(23, "TxtAttr", 1),
    Kingdee_BillField(24, "TxtAttr", 1),
    Kingdee_CashFlow(25, "TxtAttr", 1),
    BillNo(97, "TxtAttr", 1),
    Entry(98, "TxtAttr", 1),
    UploadFile(99, "TxtAttr", 1);

    private final byte code;
    private final String flexColumnPrefix;
    private final int flexValueColumnSeqNo;

    private DataValueTypeEnum(byte code, String flexColumnPrefix, int flexValueColumnSeqNo) {
        this.code = code;
        this.flexColumnPrefix = flexColumnPrefix;
        this.flexValueColumnSeqNo = flexValueColumnSeqNo;
    }

    public byte getCode() {
        return this.code;
    }

    public String getFlexColumnPrefix() {
        return this.flexColumnPrefix;
    }

    public int getFlexValueColumnSeqNo() {
        return this.flexValueColumnSeqNo;
    }

    public String getFlexColumnPrefix(boolean asDBField) {
        return asDBField ? "f" + this.flexColumnPrefix : this.flexColumnPrefix;
    }

    public static DataValueTypeEnum getEnum(Byte code) {
        if (code == null) {
            return null;
        }
        switch (code) {
            case 0: {
                return Date;
            }
            case 1: {
                return BaseProp;
            }
            case 2: {
                return AssistProp;
            }
            case 3: {
                return Decimal;
            }
            case 4: {
                return Int;
            }
            case 5: {
                return Bool;
            }
            case 6: {
                return String;
            }
            case 7: {
                return Amount;
            }
            case 8: {
                return Combo;
            }
            case 20: {
                return FahValueSet;
            }
            case 21: {
                return Kingdee_AccountTable;
            }
            case 22: {
                return Kingdee_AcctAssistDim;
            }
            case 23: {
                return Kingdee_BillDropDownList;
            }
            case 24: {
                return Kingdee_BillField;
            }
            case 25: {
                return Kingdee_CashFlow;
            }
            case 97: {
                return BillNo;
            }
            case 98: {
                return Entry;
            }
            case 99: {
                return UploadFile;
            }
        }
        return null;
    }

    public static DataValueTypeEnum getEnumByAsstActType(String number) {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        switch (number.toLowerCase(Locale.ROOT)) {
            case "1": {
                return BaseProp;
            }
            case "2": {
                return AssistProp;
            }
            case "3": {
                return String;
            }
            case "4": {
                return Bool;
            }
            case "5": {
                return Decimal;
            }
            case "6": {
                return Date;
            }
        }
        return null;
    }

    public static DataValueTypeEnum getEnum(String code) {
        if (code == null) {
            return null;
        }
        return DataValueTypeEnum.getEnum(Byte.valueOf(code));
    }

    public DataValueTypeEnum parse(Byte code) {
        return DataValueTypeEnum.getEnum(code);
    }

    public static DataValueTypeEnum getEnumByNumber(String number) {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        switch (number.toLowerCase(Locale.ROOT)) {
            case "txt": {
                return String;
            }
            case "amount": 
            case "number": {
                return Decimal;
            }
            case "date": {
                return Date;
            }
            case "basedata": {
                return BaseProp;
            }
            case "boolean": {
                return Bool;
            }
            case "entry": {
                return Entry;
            }
            case "assistant": {
                return AssistProp;
            }
        }
        return null;
    }

    public static ObjectConverterFactory.CommonDataTypeEnums convertToCommonDataType(DataValueTypeEnum srcDataType) {
        if (srcDataType != null) {
            switch (srcDataType) {
                case Date: {
                    return ObjectConverterFactory.CommonDataTypeEnums.Date;
                }
                case Bool: {
                    return ObjectConverterFactory.CommonDataTypeEnums.Boolean;
                }
                case Decimal: 
                case Amount: {
                    return ObjectConverterFactory.CommonDataTypeEnums.BigDecimal;
                }
                case Int: {
                    return ObjectConverterFactory.CommonDataTypeEnums.Integer;
                }
                case String: {
                    return ObjectConverterFactory.CommonDataTypeEnums.String;
                }
            }
            switch (srcDataType.getFlexColumnPrefix()) {
                case "DateAttr": {
                    return ObjectConverterFactory.CommonDataTypeEnums.Date;
                }
                case "IDAttr": {
                    return ObjectConverterFactory.CommonDataTypeEnums.Long;
                }
                case "NumAttr": {
                    return ObjectConverterFactory.CommonDataTypeEnums.BigDecimal;
                }
                case "CharAttr": {
                    return ObjectConverterFactory.CommonDataTypeEnums.Character;
                }
                case "TxtAttr": {
                    return ObjectConverterFactory.CommonDataTypeEnums.String;
                }
            }
        }
        return ObjectConverterFactory.CommonDataTypeEnums.ObjectType;
    }

    public ObjectConverterFactory.CommonDataTypeEnums getCommonDataType() {
        return DataValueTypeEnum.convertToCommonDataType(this);
    }
}

