/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.converters.basedata;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.v2.fah.converters.basedata.AbstractIDConverter;
import kd.fi.v2.fah.converters.basedata.AccountViewIDConverter;
import kd.fi.v2.fah.converters.basedata.AssistantIDConverter;
import kd.fi.v2.fah.converters.basedata.BaseDataNumberConverter;
import kd.fi.v2.fah.converters.basedata.BasedataIDConverter;
import kd.fi.v2.fah.dao.sys.SysBasePropDataDaoImpl;
import kd.fi.v2.fah.utils.StringUtils;

public class IDConverterHelper {
    private static final Log logger = LogFactory.getLog(IDConverterHelper.class);
    public static final int DEFAULT_CAPACITY = 8;
    private static final String ASSISTANT_ENTITY_NAME = "bos_assistantdata_detail";
    public static final String ASSISTANT_GROUP_ENTITY_NAME = "bos_assistantdatagroup";
    private static final String BD_ACCOUNTVIEW = "bd_accountview";
    private final Long orgId;
    private final Map<String, BasedataIDConverter> basedataIDConverterMap = new HashMap<String, BasedataIDConverter>(8);
    private final Map<String, BaseDataNumberConverter> baseDataNumberConverterMap = new HashMap<String, BaseDataNumberConverter>(8);
    private final Map<Long, AssistantIDConverter> assistantIDConverterMap = new HashMap<Long, AssistantIDConverter>(8);
    private final Map<Long, AccountViewIDConverter> accountViewIDConverterMap = new HashMap<Long, AccountViewIDConverter>(8);

    public IDConverterHelper(Long orgId) {
        this.orgId = orgId;
        logger.info("IDConverterHelper init");
    }

    public void collectBasedataNumber(String basedataEntityName, String number) {
        if (StringUtils.isEmpty((String)basedataEntityName) || StringUtils.isEmpty((String)number)) {
            return;
        }
        BasedataIDConverter basedataIDConverter = this.basedataIDConverterMap.computeIfAbsent(basedataEntityName, BasedataIDConverter::new);
        basedataIDConverter.collectNumber(number);
    }

    public void collectBaseDataPkId(String baseDataEntityName, Object pkId) {
        if (StringUtils.isEmpty((String)baseDataEntityName) || StringUtils.isEmpty(pkId)) {
            return;
        }
        BaseDataNumberConverter baseDataNumberConverter = this.baseDataNumberConverterMap.computeIfAbsent(baseDataEntityName, BaseDataNumberConverter::new);
        baseDataNumberConverter.collectPkId(pkId);
    }

    public List<Object> convertBasedataNumber(String basedataEntityName, String number) {
        if (StringUtils.isEmpty((String)basedataEntityName) || StringUtils.isEmpty((String)number)) {
            return Collections.emptyList();
        }
        BasedataIDConverter basedataIDConverter = this.basedataIDConverterMap.get(basedataEntityName);
        if (null == basedataIDConverter) {
            throw new RuntimeException("no found basedataIDConverter:" + basedataEntityName);
        }
        return basedataIDConverter.convertToList(number);
    }

    public void collectAssistantNumber(Long assistantTypeId, String number) {
        if (null == assistantTypeId || 0L == assistantTypeId || StringUtils.isEmpty((String)number)) {
            return;
        }
        AssistantIDConverter assistantIDConverter = this.assistantIDConverterMap.computeIfAbsent(assistantTypeId, AssistantIDConverter::new);
        assistantIDConverter.collectNumber(number);
        this.collectBaseDataPkId(ASSISTANT_GROUP_ENTITY_NAME, assistantTypeId);
    }

    public List<Object> convertAccountNumber(Long accountTableId, String number) {
        if (null == accountTableId || 0L == accountTableId || StringUtils.isEmpty((String)number)) {
            return Collections.emptyList();
        }
        AccountViewIDConverter accountIDConverter = this.accountViewIDConverterMap.get(accountTableId);
        if (null != accountIDConverter) {
            return accountIDConverter.convertToList(number);
        }
        return Collections.emptyList();
    }

    public void collectAccountNumber(Long accountTableId, String number) {
        if (null == accountTableId || 0L == accountTableId || StringUtils.isEmpty((String)number)) {
            return;
        }
        AccountViewIDConverter accountIDConverter = this.accountViewIDConverterMap.computeIfAbsent(accountTableId, AccountViewIDConverter::new);
        accountIDConverter.collectNumber(number);
    }

    public List<Object> convertAssistantNumber(Long assistantTypeId, String number) {
        if (null == assistantTypeId || 0L == assistantTypeId || StringUtils.isEmpty((String)number)) {
            return Collections.emptyList();
        }
        AssistantIDConverter assistantIDConverter = this.assistantIDConverterMap.get(assistantTypeId);
        if (null != assistantIDConverter) {
            return assistantIDConverter.convertToList(number);
        }
        return Collections.emptyList();
    }

    public void finishCollect() {
        this.queryBasedataIds();
        this.queryBasedataNumbers();
        this.queryAssistantIds();
        this.queryAccountViewIds();
    }

    private void queryBasedataIds() {
        for (BasedataIDConverter basedataIDConverter : this.basedataIDConverterMap.values()) {
            QFilter filter = new QFilter("number", "in", basedataIDConverter.getNumberSet());
            long start = System.currentTimeMillis();
            DynamicObjectCollection dynamicObjects = "bos_org".equalsIgnoreCase(basedataIDConverter.getBasedataEntityName()) || "bos_adminorg".equalsIgnoreCase(basedataIDConverter.getBasedataEntityName()) ? SysBasePropDataDaoImpl.queryOrgUnit(basedataIDConverter.getBasedataEntityName(), this.orgId, "id,number", filter) : SysBasePropDataDaoImpl.queryBaseData(basedataIDConverter.getBasedataEntityName(), this.orgId, "id,number", filter);
            HashMap<String, List<Object>> resMap = new HashMap<String, List<Object>>(basedataIDConverter.getNumberSet().size());
            if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    String number = dynamicObject.getString("number");
                    Object id = dynamicObject.get("id");
                    resMap.computeIfAbsent(number, key -> new LinkedList()).add(id);
                }
            }
            basedataIDConverter.setNumberIDMap(resMap);
            long end = System.currentTimeMillis();
            logger.info("queryBasedataIds, costs: {} ms, basedata: {}, numbersCount: {}, idsCount: {}, resMapSize: {}", new Object[]{end - start, basedataIDConverter.getBasedataEntityName(), basedataIDConverter.getNumberSet().size(), dynamicObjects.size(), resMap.size()});
        }
    }

    private void queryBasedataNumbers() {
        if (this.baseDataNumberConverterMap.size() == 0) {
            return;
        }
        for (BaseDataNumberConverter baseDataNumberConverter : this.baseDataNumberConverterMap.values()) {
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])baseDataNumberConverter.getPkIdSet().toArray(), (String)baseDataNumberConverter.getEntityName());
            HashMap<Object, String> idNumberMap = new HashMap<Object, String>(baseDataNumberConverter.getPkIdSet().size());
            for (Map.Entry entry : dynamicObjectMap.entrySet()) {
                idNumberMap.put(entry.getKey(), ((DynamicObject)entry.getValue()).getString("number"));
            }
            baseDataNumberConverter.setIdNumberMap(idNumberMap);
        }
    }

    private void queryAssistantIds() {
        Object statusFilter;
        List assistantTypeIds = this.assistantIDConverterMap.values().stream().map(AssistantIDConverter::getAssistantTypeId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(assistantTypeIds)) {
            return;
        }
        Set allNumbers = this.assistantIDConverterMap.values().stream().map(AbstractIDConverter::getNumberSet).flatMap(Collection::stream).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(allNumbers)) {
            return;
        }
        LinkedList<QFilter> qFilters = new LinkedList<QFilter>();
        if (Boolean.parseBoolean(SysParamConfig.get("assistantOrgCtrl", "true"))) {
            QFilter statusFilter2 = new QFilter("enable", "=", (Object)"1");
            QFilter assFilter = QFilter.of((String)"1!=1", (Object[])new Object[0]);
            for (Map.Entry<Long, AssistantIDConverter> entry : this.assistantIDConverterMap.entrySet()) {
                AssistantIDConverter assistantIDConverter = entry.getValue();
                QFilter assistantDataFilter = SysBasePropDataDaoImpl.getAssistantDataFilter(assistantIDConverter.getAssistantTypeId(), this.orgId);
                assistantDataFilter.and("number", "in", assistantIDConverter.getNumberSet());
                assistantDataFilter.and("group", "=", (Object)assistantIDConverter.getAssistantTypeId());
                assFilter.or(assistantDataFilter);
            }
            qFilters.add(statusFilter2);
            qFilters.add(assFilter);
        } else {
            QFilter groupFilter = new QFilter("group", "in", assistantTypeIds);
            QFilter numberFilter = new QFilter("number", "in", allNumbers);
            statusFilter = new QFilter("enable", "=", (Object)"1");
            qFilters.add(groupFilter);
            qFilters.add(numberFilter);
            qFilters.add((QFilter)statusFilter);
        }
        DynamicObjectCollection dynamicObjects = SysBasePropDataDaoImpl.queryBaseData(ASSISTANT_ENTITY_NAME, null, "id,group,number", qFilters.toArray(new QFilter[0]));
        HashMap<Long, Map> allResMap = new HashMap<Long, Map>(assistantTypeIds.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long typeId = dynamicObject.getLong("group");
            String number = dynamicObject.getString("number");
            Object id = dynamicObject.get("id");
            Map numberIdListMap = allResMap.computeIfAbsent(typeId, key -> new HashMap(8));
            numberIdListMap.computeIfAbsent(number, key -> new LinkedList()).add(id);
        }
        statusFilter = this.assistantIDConverterMap.values().iterator();
        while (statusFilter.hasNext()) {
            AssistantIDConverter assistantIDConverter;
            Map resMap = (Map)allResMap.get((assistantIDConverter = (AssistantIDConverter)statusFilter.next()).getAssistantTypeId());
            assistantIDConverter.setNumberIDMap(null == resMap ? Collections.emptyMap() : resMap);
        }
        Optional<Integer> sumOpt = allResMap.values().stream().map(Map::keySet).map(Collection::size).reduce(Integer::sum);
        int sum = sumOpt.orElse(0);
        logger.info("queryAssistantIds, assistantTypeIds: {}, numbersCount: {}, idsCount: {}, resMapSize: {}", new Object[]{assistantTypeIds, allNumbers.size(), dynamicObjects.size(), sum});
    }

    private void queryAccountViewIds() {
        List accountViewTypeIds = this.accountViewIDConverterMap.values().stream().map(AccountViewIDConverter::getAccountViewTableId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(accountViewTypeIds)) {
            return;
        }
        Set allNumbers = this.accountViewIDConverterMap.values().stream().map(AbstractIDConverter::getNumberSet).flatMap(Collection::stream).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(allNumbers)) {
            return;
        }
        QFilter groupFilter = new QFilter("accounttable.id", "in", accountViewTypeIds);
        QFilter numberFilter = new QFilter("number", "in", allNumbers);
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection dynamicObjects = SysBasePropDataDaoImpl.queryBaseData(BD_ACCOUNTVIEW, this.orgId, "id,accounttable.id,number", groupFilter, numberFilter, statusFilter);
        HashMap<Long, Map> allResMap = new HashMap<Long, Map>(accountViewTypeIds.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long typeId = dynamicObject.getLong("accounttable.id");
            String number = dynamicObject.getString("number");
            Object id = dynamicObject.get("id");
            Map numberIdListMap = allResMap.computeIfAbsent(typeId, key -> new HashMap(8));
            numberIdListMap.computeIfAbsent(number, key -> new LinkedList()).add(id);
        }
        Iterator<AccountViewIDConverter> iterator = this.accountViewIDConverterMap.values().iterator();
        while (iterator.hasNext()) {
            AccountViewIDConverter accountViewIDConverter;
            Map resMap = (Map)allResMap.get((accountViewIDConverter = iterator.next()).getAccountViewTableId());
            accountViewIDConverter.setNumberIDMap(null == resMap ? Collections.emptyMap() : resMap);
        }
        int sum = 0;
        Optional<Integer> sumOpt = allResMap.values().stream().map(Map::keySet).map(Collection::size).reduce(Integer::sum);
        if (sumOpt.isPresent()) {
            sum = sumOpt.get();
        }
        logger.info("queryAccountViewIds, accountViewTypeIds: {}, numbersCount: {}, idsCount: {}, resMapSize: {}", new Object[]{accountViewTypeIds, allNumbers.size(), dynamicObjects.size(), sum});
    }

    public String convertToBaseDataNumber(String entityName, Object pkId) {
        if (StringUtils.isEmpty((String)entityName) || StringUtils.isEmpty(pkId)) {
            return null;
        }
        BaseDataNumberConverter baseDataNumberConverter = this.baseDataNumberConverterMap.get(entityName);
        if (null == baseDataNumberConverter) {
            throw new RuntimeException("no found BaseDataNumberConverter:" + entityName);
        }
        return baseDataNumberConverter.convertNumber(pkId);
    }
}

