/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.biz;

import java.util.HashMap;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.QFBuilder;
import kd.fi.v2.fah.constant.enums.AppVersionEnum;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;

public class ExtDataModelHelper {
    private static final String CACHE_KEY = "ExtDataModelHelper.checkNewModel";

    public static boolean checkNewModel(Long modelId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("id", "=", (Object)modelId));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"fah_ext_datamodel", (String)"id,appversion", (QFilter[])qfBuilder.toArray());
        return String.valueOf(AppVersionEnum.NEW_APP.getCode()).equals(dynamicObject.get("appversion"));
    }

    public static boolean checkNewModelFromCache(Long modelId) {
        HashMap modelAppVersionMap = (HashMap)ThreadCache.get((Object)CACHE_KEY, HashMap::new);
        return modelAppVersionMap.computeIfAbsent(modelId, ExtDataModelHelper::checkNewModel);
    }

    public static ModelIdAndBillType queryModelIdAndBillType(Object dataId) {
        DynamicObject event = QueryServiceHelper.queryOne((String)"ai_event", (String)"id, eventclass.id modelid,eventclass.number eventclassnum, eventclass.appversion appversion", (QFilter[])new QFilter[]{new QFilter("id", "=", dataId)});
        Long modelId = event.getLong("modelid");
        String appVersion = event.getString("appversion");
        String billType = DataModelDaoImpl.getMetaEntityNumber(event.getString("eventclassnum"));
        if (!String.valueOf(AppVersionEnum.NEW_APP.getCode()).equals(appVersion)) {
            billType = "ai_event";
        }
        return new ModelIdAndBillType(modelId, billType);
    }

    public static class ModelIdAndBillType {
        private Long modelId;
        private String billType;

        public ModelIdAndBillType(Long modelId, String billType) {
            this.modelId = modelId;
            this.billType = billType;
        }

        public Long getModelId() {
            return this.modelId;
        }

        public String getBillType() {
            return this.billType;
        }
    }
}

