/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.datamodel;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.util.QFBuilder;
import kd.fi.v2.fah.cache.cacheservice.DataModelCfgCacheService;
import kd.fi.v2.fah.cache.cacheservice.FAHDataCacheMgr;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.FormBuilderConstant;
import kd.fi.v2.fah.constant.enums.AppVersionEnum;
import kd.fi.v2.fah.constant.enums.CreateTypeEnum;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.DefaultDataFieldGroupEnum;
import kd.fi.v2.fah.constant.enums.ExtDataModelSystemFieldEnum;
import kd.fi.v2.fah.constant.enums.FieldPropEnum;
import kd.fi.v2.fah.constant.enums.StatusEnum;
import kd.fi.v2.fah.context.ConditionContext;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.formbuilder.DynamicFormConfig;
import kd.fi.v2.fah.formbuilder.builder.DynamicFormConfigBuilder;
import kd.fi.v2.fah.formbuilder.builder.DynamicFormModelBuilder;
import kd.fi.v2.fah.models.modeling.impl.DataModelCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelDiff;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCollection;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldPropCfg;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.utils.DataModelUtils;
import kd.fi.v2.fah.utils.ICommonDataValueUtil;
import kd.fi.v2.fah.utils.StringUtils;
import kd.fi.v2.fah.validator.vchTemplate.VchTemplateRefValidator;

public class DataModelDaoImpl {
    private static final Log log = LogFactory.getLog(DataModelDaoImpl.class);
    private static final DataModelCfgCacheService cacheService = FAHDataCacheMgr.instance.getDataModelCfgCacheService();

    public static DataModelCfg loadModelFromCache(String number) {
        return (DataModelCfg)cacheService.loadFromCache(number, new Object[0]);
    }

    public static DynamicObjectCollection queryEnableModels(String selectFields, AppVersionEnum appVersion) {
        QFilter qfilter = new QFilter("status", "=", (Object)"C");
        if (AppVersionEnum.NEW_APP == appVersion) {
            qfilter.and(new QFilter("appversion", "=", (Object)String.valueOf(AppVersionEnum.NEW_APP.getCode())));
        } else {
            qfilter.and(new QFilter("appversion", "<>", (Object)String.valueOf(AppVersionEnum.NEW_APP.getCode())));
        }
        return QueryServiceHelper.query((String)"fah_ext_datamodel", (String)selectFields, (QFilter[])qfilter.toArray());
    }

    public static boolean isNewModel(Object pk) {
        DynamicObject dataModel = QueryServiceHelper.queryOne((String)"fah_ext_datamodel", (String)"appversion", (QFilter[])new QFilter[]{new QFilter("id", "=", pk)});
        return ObjectConverterFactory.getByte(dataModel.getString("appversion")).equals(AppVersionEnum.NEW_APP.getCode());
    }

    public static DynamicObject queryUserInfo(Object id) {
        return QueryServiceHelper.queryOne((String)"bos_user", (String)"name,phone,entryentity.dpt.name", (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
    }

    public static DynamicObject queryUserName(Object id) {
        return QueryServiceHelper.queryOne((String)"bos_user", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
    }

    public static DynamicObject queryDataModelById(Long id) {
        return QueryServiceHelper.queryOne((String)"fah_ext_datamodel", (String)"id,masterid,number,name,creator.id,appversion,versionnum,group.id,group.number,templateno,description", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
    }

    public static Long queryMasterIdById(Long id) {
        DynamicObject model = QueryServiceHelper.queryOne((String)"fah_ext_datamodel", (String)"masterid", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
        if (null != model) {
            return model.getLong("masterid");
        }
        return null;
    }

    public static DynamicObject queryDataModelByNumber(String number) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("number", "=", (Object)number));
        qfBuilder.add(new QFilter("status", "=", (Object)StatusEnum.PUBLISHED.getCode()));
        qfBuilder.add(new QFilter("latestversion", "=", (Object)"1"));
        return QueryServiceHelper.queryOne((String)"fah_ext_datamodel", (String)"id,masterid,number,name,creator.id,appversion,versionnum,group.id,group.number,templateno,description", (QFilter[])qfBuilder.toArray());
    }

    public static DynamicObject queryDataModelByNumberCommon(String number) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("number", "=", (Object)number));
        qfBuilder.add(new QFilter("appversion", "=", (Object)String.valueOf(AppVersionEnum.OLD_APP.getCode())).or(new QFilter("appversion", "=", (Object)String.valueOf(AppVersionEnum.NEW_APP.getCode())).and("latestversion", "=", (Object)"1").and("status", "=", (Object)StatusEnum.PUBLISHED.getCode())));
        String select = "id,masterid,number,appversion,fieldentryentity.fieldname fieldname,fieldentryentity.fieldtype fieldtype,versionnum,enable";
        return QueryServiceHelper.queryOne((String)"ai_eventclass", (String)select, (QFilter[])qfBuilder.toArray());
    }

    public static Collection<Object> queryDataModelNumberCommon(Collection ids) {
        HashSet<Object> numberSet = new HashSet<Object>(8);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DataModelDaoImpl.queryDataModelNumberCommon", (String)"ai_eventclass", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                numberSet.add(row.get("number"));
            }
        }
        return numberSet;
    }

    public static DataSet queryLastDataModelGroupNumberByNumber(String number, int version) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT fgroupnumber FROM t_fah_ext_modfldgrp WHERE fmodelid in ( ", new Object[0]);
        sql.append("SELECT fid FROM t_ai_eventclass ", new Object[0]);
        sql.append("where fnumber = ?", new Object[]{number}).append(" and fVersionNum = ? ", new Object[]{version - 1}).append(")", new Object[0]);
        String algoKey = "kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl.queryLastDataModelGroupNumberByNumber";
        return DB.queryDataSet((String)algoKey, (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
    }

    public static DynamicObjectCollection queryDataGroupsByModelId(Long id) {
        return QueryServiceHelper.query((String)"fah_ext_model_fldgrp", (String)"longnumber,groupname,groupnumber,id,dseq,isleaf,level,tablename,grouptype,parent.id,parent.longnumber", (QFilter[])new QFilter("model", "=", (Object)id).toArray(), (String)"tablename,level,dseq");
    }

    public static DynamicObjectCollection queryDataEntrysByModelId(Long id) {
        return QueryServiceHelper.query((String)"fah_ext_dataentry", (String)"id,number,name,datatype,baseprop,assistprop,property,visible,apifield,isenable,required,requiredcondition,dseq,group.longnumber,group.groupname,group.groupnumber,group.id,group.dseq,group.isleaf,group.level,group.tablename,group.parent,group.grouptype", (QFilter[])new QFilter("model", "=", (Object)id).toArray(), (String)"group.tablename,group.level,group.dseq");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public static long save(DataModelCfg dataModel) {
        lockKey = DataModelDaoImpl.getLockKey(dataModel.getNumber());
        lock = DLock.create((String)lockKey).fastMode();
        var3_4 = null;
        try {
            if (!lock.tryLock()) ** GOTO lbl-1000
            if (dataModel.getId() != null && !DataModelDaoImpl.isModelChanged(dataModel)) {
                var4_5 = dataModel.getId();
                return var4_5;
            }
            handle = TX.requiresNew((String)"DataModelDaoImpl.save");
            var5_12 = null;
            try {
                var6_9 = DataModelDaoImpl.saveNewDataModel(dataModel);
                return var6_9;
            }
            catch (Exception e) {
                try {
                    handle.markRollback();
                    throw e;
                }
                catch (Throwable var6_11) {
                    var5_12 = var6_11;
                    throw var6_11;
                }
            }
            finally {
                if (handle != null) {
                    if (var5_12 != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable var8_13) {
                            var5_12.addSuppressed(var8_13);
                        }
                    } else {
                        handle.close();
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5e03\u5f0f\u4e8b\u52a1\u9501\u52a0\u9501\u5931\u8d25\u3002", (String)"DataModelDaoImpl_3", (String)"fi-ai-common", (Object[])new Object[0]));
            }
            {
                catch (Throwable var4_7) {
                    var3_4 = var4_7;
                    throw var4_7;
                }
            }
        }
        finally {
            if (lock != null) {
                if (var3_4 != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable var6_8) {
                        var3_4.addSuppressed(var6_8);
                    }
                } else {
                    lock.close();
                }
            }
        }
    }

    public static void fieldChangeCheckForUsedModel(Set<String> maxLengthUpdateNumber, DataModelCfg saveCfg, DataModelCfg backUpCfg) {
        PairTuple<Set<String>, Set<String>> result;
        boolean havingExtData = DataModelDaoImpl.isHavingExtData(backUpCfg.getId());
        Set groupNums = new HashSet(8);
        Set fieldNums = new HashSet(8);
        if (!havingExtData && DataModelDaoImpl.isHavingExtData(backUpCfg.getNumber()) && (result = DataModelDaoImpl.getGroupAndFieldNumberSet(backUpCfg.getNumber(), ObjectConverterFactory.getInteger(backUpCfg.getVersion()) - 1)) != null) {
            groupNums = (Set)result.getKey();
            fieldNums = (Set)result.getValue();
        }
        for (DataModelFieldCollection backUpGroup : (BaseMutableArrayMapStorage)backUpCfg.getCollections()) {
            if (DefaultDataFieldGroupEnum.SYSTEM.getKey().equals(backUpGroup.getNumber()) || DefaultDataFieldGroupEnum.HEAD.getKey().equals(backUpGroup.getNumber()) || DefaultDataFieldGroupEnum.ENTRY.getKey().equals(backUpGroup.getNumber())) continue;
            DataModelFieldCollection saveGroup = (DataModelFieldCollection)saveCfg.get(backUpGroup.getNumber());
            if (saveGroup == null) {
                if (!havingExtData && !groupNums.contains(DataModelUtils.getNumber(backUpGroup.getNumber()))) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u5df2\u63a5\u5165\u5916\u90e8\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\u5386\u53f2\u5206\u7ec4\uff1a\u201c%s\u201d\u3002", (String)"DataModelDaoImpl_9", (String)"fi-ai-common", (Object[])new Object[0]), DataModelUtils.getNumber(backUpGroup.getNumber())));
            }
            for (DataModelFieldCfg backUpField : (BaseMutableArrayMapStorage)backUpGroup.getCollections()) {
                String saveFieldPropJson;
                DataModelFieldCfg saveField = (DataModelFieldCfg)saveGroup.get(backUpField.getNumber());
                if (saveField == null) {
                    if (!havingExtData && !fieldNums.contains(backUpField.getNumber())) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u5df2\u63a5\u5165\u5916\u90e8\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\u5386\u53f2\u5b57\u6bb5\uff1a\u201c%s\u201d\u3002", (String)"DataModelDaoImpl_10", (String)"fi-ai-common", (Object[])new Object[0]), backUpField.getNumber()));
                }
                if (!havingExtData && !fieldNums.contains(saveField.getNumber())) continue;
                if (backUpField.getDataType() != saveField.getDataType()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u5df2\u63a5\u5165\u5916\u90e8\u6570\u636e\uff0c\u65e0\u6cd5\u66f4\u6539\u5b57\u6bb5\u201c%s\u201d\u7684\u7c7b\u578b\u3002", (String)"DataModelDaoImpl_11", (String)"fi-ai-common", (Object[])new Object[0]), backUpField.getNumber()));
                }
                if (!Objects.equals(backUpField.getRefBaseProp(), saveField.getRefBaseProp())) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u5df2\u63a5\u5165\u5916\u90e8\u6570\u636e\uff0c\u65e0\u6cd5\u66f4\u6539\u5b57\u6bb5\u201c%s\u201d\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"DataModelDaoImpl_35", (String)"fi-ai-common", (Object[])new Object[0]), backUpField.getNumber()) + "\r\n");
                }
                if (!Objects.equals(backUpField.getRefAssistProp(), saveField.getRefAssistProp())) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u5df2\u63a5\u5165\u5916\u90e8\u6570\u636e\uff0c\u65e0\u6cd5\u66f4\u6539\u5b57\u6bb5\u201c%s\u201d\u7684\u8f85\u52a9\u8d44\u6599\u7c7b\u578b\u3002", (String)"DataModelDaoImpl_36", (String)"fi-ai-common", (Object[])new Object[0]), backUpField.getNumber()) + "\r\n");
                }
                String backUpFieldPropJson = backUpField.getProps() == null ? "" : JSON.toJSONString(backUpField.getProps().getValues());
                if (backUpFieldPropJson.equals(saveFieldPropJson = saveField.getProps() == null ? "" : JSON.toJSONString(saveField.getProps().getValues()))) continue;
                for (DataModelFieldPropCfg fieldCfg : backUpField.getProps()) {
                    String number = fieldCfg.getName();
                    if (!(number.equals(FieldPropEnum.DEFVALUE.getNumber()) || number.equals(FieldPropEnum.DEFVALUEDESIGN.getNumber()) || number.equals(FieldPropEnum.DISPLAY.getNumber()) || number.equals(FieldPropEnum.SCALE.getNumber()) || StringUtils.isEquals(String.valueOf(fieldCfg.getPropValue()), String.valueOf(((DataModelFieldPropCfg)saveField.getProps().get(fieldCfg.getItemKey())).getPropValue())) || number.equals(FieldPropEnum.MAXLENGTH.getNumber()))) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u5df2\u63a5\u5165\u5916\u90e8\u6570\u636e\uff0c\u65e0\u6cd5\u66f4\u6539\u5b57\u6bb5\uff1a\u201c%1$s\u201d\u7684\u5b57\u6bb5\u5c5e\u6027\uff1a\u201c%2$s\u201d\u3002", (String)"DataModelDaoImpl_12", (String)"fi-ai-common", (Object[])new Object[0]), backUpField.getNumber(), FieldPropEnum.getEnumByNumber(fieldCfg.getItemKey()).getName()));
                    }
                    if (!number.equals(FieldPropEnum.MAXLENGTH.getNumber())) continue;
                    int length = Integer.parseInt(String.valueOf(((DataModelFieldPropCfg)saveField.getProps().get(fieldCfg.getItemKey())).getPropValue()));
                    if (length < Integer.parseInt(String.valueOf(fieldCfg.getPropValue()))) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u5df2\u6709\u5916\u90e8\u6570\u636e\uff0c\u201c%1$s\u201d\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u51cf\u5c0f\u3002", (String)"DataModelDaoImpl_50", (String)"fi-ai-common", (Object[])new Object[0]), backUpField.getNumber()));
                    }
                    if (length <= Integer.parseInt(String.valueOf(fieldCfg.getPropValue())) || saveField.getDataType() != DataValueTypeEnum.String) continue;
                    maxLengthUpdateNumber.add(backUpField.getNumber());
                }
            }
        }
    }

    public static PairTuple<Set<String>, Set<String>> getGroupAndFieldNumberSet(String modelNum, int version) {
        if (version < 1) {
            return null;
        }
        DynamicObject model = DataModelDaoImpl.queryPublishedModelByVersion(modelNum, version);
        DynamicObjectCollection groups = DataModelDaoImpl.queryDataGroupsByModelId(model.getLong("id"));
        DynamicObjectCollection fields = DataModelDaoImpl.queryDataEntrysByModelId(model.getLong("id"));
        Set groupNums = groups.stream().map(o -> o.getString("groupnumber")).collect(Collectors.toSet());
        Set fieldNums = fields.stream().map(o -> o.getString("number")).collect(Collectors.toSet());
        return new PairTuple(groupNums, fieldNums);
    }

    public static DynamicObject queryPublishedModelByVersion(String modelNum, int version) {
        return QueryServiceHelper.queryOne((String)"fah_ext_datamodel", (String)"id,number,name,versionnum,status,refdatacnt,enabledtime,disabledtime,enabledby,disabledby,latestversion", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)modelNum), new QFilter("versionnum", "=", (Object)version)});
    }

    public static boolean uniqueNumberCheck(Long masterID, String number) {
        Object[] params;
        String sql = "select count(1) as counts from t_ai_eventclass where lower(fnumber) = ?";
        if (masterID != null) {
            sql = sql + "and fmasterid != ?";
            params = new Object[]{number, masterID};
        } else {
            params = new Object[]{number};
        }
        int counts = 0;
        try (DataSet dataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl.uniqueNumberCheck", (DBRoute)FAHCommonConstant.AI, (String)sql, (Object[])params);){
            if (dataSet.hasNext()) {
                Row next = dataSet.next();
                counts = next.getInteger("counts");
            }
        }
        return counts == 0;
    }

    public static boolean uniqueNameCheck(Long masterID, String name) {
        Object[] params;
        String sql = "select fid from t_ai_eventclass where flatestversion = '1' and fname = ?";
        if (masterID != null) {
            sql = sql + "and fmasterid != ?";
            params = new Object[]{name, masterID};
        } else {
            params = new Object[]{name};
        }
        try (DataSet dataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl.uniqueNumberCheck", (DBRoute)FAHCommonConstant.AI, (String)sql, (Object[])params);){
            boolean bl = dataSet.hasNext();
            return bl;
        }
    }

    private static long saveNewDataModel(DataModelCfg dataModel) {
        DynamicObject head = BusinessDataServiceHelper.newDynamicObject((String)"fah_ext_datamodel");
        if (dataModel.getId() == null) {
            SequenceReader sReader = new SequenceReader(new DBRoute("ai"));
            Long[] sequences = (Long[])sReader.getSequences((Object[])new Long[1], "fah_ext_datamodel", 1);
            head.set("id", (Object)sequences[0]);
            head.set("masterid", (Object)sequences[0]);
            head.set("versionnum", (Object)1);
            head.set("latestversion", (Object)"1");
            head.set("status", (Object)StatusEnum.UNPUBLISHED.getCode());
            head.set("enable", (Object)"0");
        } else {
            head = BusinessDataServiceHelper.loadSingle((Object)dataModel.getId(), (String)"fah_ext_datamodel");
        }
        head.set("name", (Object)dataModel.getName());
        head.set("number", (Object)dataModel.getNumber());
        head.set("group", (Object)dataModel.getGroup());
        head.set("templateno", (Object)dataModel.getTemplateno());
        head.set("description", (Object)dataModel.getDescription());
        Date now = new Date();
        head.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        head.set("createtime", (Object)now);
        head.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
        head.set("modifytime", (Object)now);
        head.set("appversion", (Object)ObjectConverterFactory.getCharacter(AppVersionEnum.NEW_APP.getCode()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{head});
        HashMap<String, Long> groupMap = new HashMap<String, Long>();
        DynamicObjectCollection groupCoolection = QueryServiceHelper.query((String)"fah_ext_model_fldgrp", (String)"id", (QFilter[])new QFilter("model", "=", (Object)head.getLong("id")).toArray());
        HashSet<Long> needDelIdSet = new HashSet<Long>();
        groupCoolection.stream().forEach(o -> needDelIdSet.add(o.getLong("id")));
        LinkedList<DynamicObject> groupSaveList = new LinkedList<DynamicObject>();
        for (DataModelFieldCollection group : (BaseMutableArrayMapStorage)dataModel.getCollections()) {
            Long groupId = group.getId();
            DynamicObject groupDynamicObject = needDelIdSet.contains(groupId) ? BusinessDataServiceHelper.loadSingle((Object)groupId, (String)"fah_ext_model_fldgrp") : BusinessDataServiceHelper.newDynamicObject((String)"fah_ext_model_fldgrp");
            String longNumber = group.getNumber();
            groupMap.put(longNumber, groupId);
            int seq = group.getGroupSeq();
            int level = group.getGroupLevel();
            groupDynamicObject.set("id", (Object)groupId);
            groupDynamicObject.set("Model", (Object)head.getLong("id"));
            groupDynamicObject.set("dseq", (Object)seq);
            groupDynamicObject.set("grouptype", (Object)Character.valueOf(group.getGroupType().getCode()));
            groupDynamicObject.set("groupname", (Object)group.getName());
            groupDynamicObject.set("groupnumber", (Object)DataModelUtils.getNumber(longNumber));
            groupDynamicObject.set("parent", (Object)group.getParentId());
            groupDynamicObject.set("longnumber", (Object)longNumber);
            groupDynamicObject.set("level", (Object)level);
            groupDynamicObject.set("isleaf", (Object)Character.valueOf(dataModel.isEntryGroupEntry(longNumber) ? (char)'0' : '1'));
            String tableName = null;
            if (DefaultDataFieldGroupEnum.ENTRY == group.getGroupType() && level >= 1) {
                tableName = level == 1 ? DataModelDaoImpl.getTableName(dataModel.getNumber() + "_" + seq) : DataModelDaoImpl.getTableName(dataModel.getNumber() + "_" + ((DataModelFieldCollection)dataModel.get(longNumber.substring(0, longNumber.lastIndexOf(124)))).getGroupSeq() + "_" + seq);
            }
            groupDynamicObject.set("tablename", tableName);
            groupSaveList.add(groupDynamicObject);
            needDelIdSet.remove(group.getId());
        }
        SaveServiceHelper.save((DynamicObject[])groupSaveList.toArray(new DynamicObject[0]));
        if (needDelIdSet.size() > 0) {
            DataModelDaoImpl.deleteGroupData(needDelIdSet, head);
        }
        LinkedList<DynamicObject> saveList = new LinkedList<DynamicObject>();
        DynamicObjectCollection dataFields = QueryServiceHelper.query((String)"fah_ext_dataentry", (String)"id,number", (QFilter[])new QFilter("model", "=", (Object)head.getLong("id")).toArray());
        HashMap fieldMap = new HashMap();
        dataFields.stream().forEach(o -> fieldMap.put(o.getString("number"), o.getLong("id")));
        for (DataModelFieldCollection group : (BaseMutableArrayMapStorage)dataModel.getCollections()) {
            Long groupId = (Long)groupMap.get(group.getNumber());
            if (group.getCollections() == null) continue;
            for (DataModelFieldCfg field : (BaseMutableArrayMapStorage)group.getCollections()) {
                DynamicObject fieldDyn = DataModelDaoImpl.generateFieldDyn(field, (Long)fieldMap.get(field.getNumber()), head.getLong("id"), groupId);
                saveList.add(fieldDyn);
                fieldMap.remove(field.getNumber());
            }
        }
        SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        DataModelDaoImpl.deleteDataFields(fieldMap.keySet(), head);
        return head.getLong("id");
    }

    public static long saveNewDataModelForImport(DataModelCfg dataModel) {
        DataModelCfg publishedModel = (DataModelCfg)cacheService.loadFromCache(dataModel.getNumber(), new Object[0]);
        DynamicObject head = BusinessDataServiceHelper.newDynamicObject((String)"fah_ext_datamodel");
        SequenceReader sReader = new SequenceReader(new DBRoute("ai"));
        Long[] sequences = (Long[])sReader.getSequences((Object[])new Long[1], "fah_ext_datamodel", 1);
        head.set("id", (Object)sequences[0]);
        head.set("masterid", (Object)dataModel.getMasterId());
        head.set("versionnum", (Object)(publishedModel == null ? 1 : ObjectConverterFactory.getInteger(publishedModel.getVersion()) + 1));
        head.set("latestversion", (Object)"1");
        head.set("status", (Object)StatusEnum.UNPUBLISHED.getCode());
        head.set("enable", (Object)"0");
        head.set("name", (Object)dataModel.getName());
        head.set("number", (Object)dataModel.getNumber());
        head.set("group", (Object)dataModel.getGroup());
        head.set("templateno", (Object)dataModel.getTemplateno());
        head.set("description", (Object)dataModel.getDescription());
        Date now = new Date();
        head.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        head.set("createtime", (Object)now);
        head.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
        head.set("modifytime", (Object)now);
        head.set("appversion", (Object)ObjectConverterFactory.getCharacter(AppVersionEnum.NEW_APP.getCode()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{head});
        long[] groupIds = DBServiceHelper.genLongIds((String)"fah_ext_model_fldgrp", (int)((BaseMutableArrayMapStorage)dataModel.getCollections()).size());
        HashMap<String, Long> groupMap = new HashMap<String, Long>();
        LinkedList<DynamicObject> groupSaveList = new LinkedList<DynamicObject>();
        int index = 0;
        for (DataModelFieldCollection group : (BaseMutableArrayMapStorage)dataModel.getCollections()) {
            String parentLongNumber;
            DataModelFieldCollection parent;
            DynamicObject groupDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"fah_ext_model_fldgrp");
            long groupId = groupIds[index];
            ++index;
            String longNumber = group.getNumber();
            groupMap.put(longNumber, groupId);
            int seq = group.getGroupSeq();
            int level = group.getGroupLevel();
            groupDynamicObject.set("id", (Object)groupId);
            group.setId(groupId);
            groupDynamicObject.set("Model", (Object)head.getLong("id"));
            groupDynamicObject.set("dseq", (Object)seq);
            groupDynamicObject.set("grouptype", (Object)Character.valueOf(group.getGroupType().getCode()));
            groupDynamicObject.set("groupname", (Object)group.getName());
            groupDynamicObject.set("groupnumber", (Object)DataModelUtils.getNumber(longNumber));
            if (group.getGroupLevel() > 0 && null != (parent = (DataModelFieldCollection)dataModel.get(parentLongNumber = DataModelUtils.getParentLongNumber(group.getNumber())))) {
                group.setParentId(parent.getId());
            }
            groupDynamicObject.set("parent", (Object)group.getParentId());
            groupDynamicObject.set("longnumber", (Object)longNumber);
            groupDynamicObject.set("level", (Object)level);
            groupDynamicObject.set("isleaf", (Object)Character.valueOf(dataModel.isEntryGroupEntry(longNumber) ? (char)'0' : '1'));
            String tableName = null;
            if (DefaultDataFieldGroupEnum.ENTRY == group.getGroupType() && level >= 1) {
                tableName = level == 1 ? DataModelDaoImpl.getTableName(dataModel.getNumber() + "_" + seq) : DataModelDaoImpl.getTableName(dataModel.getNumber() + "_" + ((DataModelFieldCollection)dataModel.get(longNumber.substring(0, longNumber.lastIndexOf(124)))).getGroupSeq() + "_" + seq);
            }
            groupDynamicObject.set("tablename", tableName);
            groupSaveList.add(groupDynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])groupSaveList.toArray(new DynamicObject[0]));
        LinkedList<DynamicObject> saveList = new LinkedList<DynamicObject>();
        for (DataModelFieldCollection group : (BaseMutableArrayMapStorage)dataModel.getCollections()) {
            Long groupId = (Long)groupMap.get(group.getNumber());
            if (group.getCollections() == null) continue;
            for (DataModelFieldCfg field : (BaseMutableArrayMapStorage)group.getCollections()) {
                DynamicObject fieldDyn = DataModelDaoImpl.generateFieldDyn(field, null, head.getLong("id"), groupId);
                saveList.add(fieldDyn);
            }
        }
        SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        return head.getLong("id");
    }

    public static Integer getEventRecordCounts(Long id) {
        String sql = "select count(1) as counts from t_ai_event where feventclass = " + id;
        try (DataSet count = DB.queryDataSet((String)"DataModelDaoImpl.getEventRecordCounts", (DBRoute)FAHCommonConstant.AI, (String)sql);){
            if (count.hasNext()) {
                Row row = count.next();
                Integer n = row.getInteger("counts");
                return n;
            }
        }
        return 0;
    }

    public static DynamicObjectCollection queryDataModelColById(Long[] id) {
        DynamicObjectCollection dataModels = QueryServiceHelper.query((String)"fah_ext_datamodel", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)id)});
        HashSet<String> numberSet = new HashSet<String>(4);
        for (DynamicObject dataModel : dataModels) {
            numberSet.add(dataModel.getString("number"));
        }
        QFilter filter = new QFilter("number", "in", numberSet);
        return QueryServiceHelper.query((String)"fah_ext_datamodel", (String)"id,number,name,versionnum,status,refdatacnt,enabledtime,disabledtime,enabledby,disabledby,latestversion", (QFilter[])new QFilter[]{filter}, (String)"versionnum desc");
    }

    public static boolean numberCheck(DataModelCfg dataModel) {
        if (dataModel.getId() == null) {
            return true;
        }
        DynamicObject model = QueryServiceHelper.queryOne((String)"fah_ext_datamodel", (String)"number", (QFilter[])new QFilter("id", "=", (Object)dataModel.getId()).toArray());
        if (null != model && !dataModel.getNumber().equalsIgnoreCase(model.getString("number"))) {
            QFBuilder qb = new QFBuilder();
            qb.add("number", "=", (Object)model.getString("number"));
            qb.add("status", "=", (Object)StatusEnum.PUBLISHED.getCode());
            return !QueryServiceHelper.exists((String)"fah_ext_datamodel", (QFilter[])qb.toArray());
        }
        return true;
    }

    public static boolean tableExistData(String tableName, DBRoute dbRoute) {
        if (DB.exitsTable((DBRoute)dbRoute, (String)tableName)) {
            String sql = "select 1 from " + tableName;
            try (DataSet data = DB.queryDataSet((String)"DataModelDaoImpl.checkTableIsEmpty", (DBRoute)dbRoute, (String)sql);){
                if (!data.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    public static String getTableName(String number) {
        return "fah_e_" + number;
    }

    public static String getMetaEntityNumber(String number) {
        return "fah_e_" + number;
    }

    public static String getTableNameByIdCached(Long id) {
        Object tableName = ThreadCache.get((Object)("DataModelDaoImpl.getTableNameById:" + id));
        if (null != tableName) {
            return StringUtils.isEmpty(tableName) ? null : (String)tableName;
        }
        String tableNameById = DataModelDaoImpl.getTableNameById(id);
        ThreadCache.put((Object)("DataModelDaoImpl.getTableNameById:" + id), (Object)(null == tableNameById ? "" : tableNameById));
        return tableNameById;
    }

    public static String getTableNameById(Long id) {
        DynamicObject numberObj = QueryServiceHelper.queryOne((String)"fah_ext_datamodel", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id), new QFilter("appversion", "=", (Object)String.valueOf(AppVersionEnum.NEW_APP.getCode()))});
        if (numberObj == null) {
            return null;
        }
        return "fah_e_" + numberObj.getString("number");
    }

    public static boolean isModelChanged(DataModelCfg dataModel) {
        DataModelCfg originModel = (DataModelCfg)DataModelDaoImpl.loadFromDBById(dataModel.getId()).getKey();
        return DataModelDaoImpl.isModelChanged(originModel, dataModel);
    }

    public static boolean isModelChanged(DataModelCfg originModel, DataModelCfg newModel) {
        return DataModelDaoImpl.isHeadMessageChanged(newModel, originModel) || DataModelDaoImpl.isEntryMessageChanged(newModel, originModel);
    }

    private static boolean isHeadMessageChanged(DataModelCfg o1, DataModelCfg o2) {
        return !StringUtils.isEquals(o1.getNumber(), o2.getNumber()) || !StringUtils.isEquals(o1.getName(), o2.getName()) || !ICommonDataValueUtil.isEquals(o1.getGroup(), o2.getGroup()) || !StringUtils.isEquals(o1.getTemplateno(), o2.getTemplateno()) || !StringUtils.isEquals(o1.getDescription(), o2.getDescription());
    }

    private static boolean isEntryMessageChanged(DataModelCfg o1, DataModelCfg o2) {
        Set keySet2;
        Set keySet1 = ((BaseMutableArrayMapStorage)o1.getCollections()).getIndexMap().keySet();
        if (!keySet1.containsAll(keySet2 = ((BaseMutableArrayMapStorage)o2.getCollections()).getIndexMap().keySet()) || !keySet2.containsAll(keySet1)) {
            return true;
        }
        for (DataModelFieldCollection group1 : (BaseMutableArrayMapStorage)o1.getCollections()) {
            DataModelFieldCollection group2 = (DataModelFieldCollection)o2.get(group1.getNumber());
            if (group1.getGroupSeq() != group2.getGroupSeq() || !group1.getName().equals(group2.getName())) {
                return true;
            }
            if (!group1.isEmpty() && !group2.isEmpty()) {
                Set fieldKeySet2;
                Set fieldKeySet1 = ((BaseMutableArrayMapStorage)group1.getCollections()).getIndexMap().keySet();
                if (!fieldKeySet1.containsAll(fieldKeySet2 = ((BaseMutableArrayMapStorage)group2.getCollections()).getIndexMap().keySet()) || !fieldKeySet2.containsAll(fieldKeySet1)) {
                    return true;
                }
                for (DataModelFieldCfg field1 : (BaseMutableArrayMapStorage)group1.getCollections()) {
                    DataModelFieldCfg field2;
                    if (field1.isSameModel(field2 = (DataModelFieldCfg)group2.get(field1.getNumber()))) continue;
                    return true;
                }
                continue;
            }
            if ((!group1.isEmpty() || group2.isEmpty()) && (group1.isEmpty() || !group2.isEmpty())) continue;
            return true;
        }
        return false;
    }

    public static PairTuple<DataModelCfg, Set<String>> loadFromDBById(Long id) {
        DynamicObject model = DataModelDaoImpl.queryDataModelById(id);
        return DataModelDaoImpl.loadFromDB(model);
    }

    public static DataModelCfg loadModelFromDBByNumber(String number) {
        DynamicObject model = DataModelDaoImpl.queryDataModelByNumber(number);
        if (model == null) {
            return null;
        }
        return (DataModelCfg)DataModelDaoImpl.loadFromDB(model).getKey();
    }

    public static PairTuple<DataModelCfg, Set<String>> loadFromDB(DynamicObject model) {
        DataModelCfg extDataModel;
        HashSet<String> groupNumber = new HashSet<String>();
        if (model != null) {
            long id = model.getLong("id");
            extDataModel = new DataModelCfg(id, model.getString("number"), model.getString("name"));
            Long group = model.getLong("group.id");
            extDataModel.setGroup(group == null || group == 0L ? null : group);
            extDataModel.setGroupNumber(model.getString("group.number"));
            String templateno = model.getString("templateno");
            extDataModel.setTemplateno(StringUtils.isEmpty((String)templateno) ? null : templateno);
            String description = model.getString("description");
            extDataModel.setDescription(StringUtils.isEmpty((String)description) ? null : description);
            extDataModel.setMasterId(model.getLong("masterid"));
            extDataModel.setCreatorId(model.getLong("creator.id"));
            extDataModel.setVersion(model.getInt("versionnum"));
            DynamicObjectCollection groupEntrys = DataModelDaoImpl.queryDataGroupsByModelId(id);
            for (Object groupEntry : groupEntrys) {
                String groupLongNum = groupEntry.getString("longnumber");
                DataModelFieldCollection dataModelFieldCollection = (DataModelFieldCollection)extDataModel.get(groupLongNum);
                if (dataModelFieldCollection != null) continue;
                dataModelFieldCollection = new DataModelFieldCollection(groupEntry.getLong("id"), groupLongNum, groupEntry.getString("groupname"));
                dataModelFieldCollection.setGroupLevel(groupEntry.getInt("level"));
                dataModelFieldCollection.setGroupSeq(groupEntry.getInt("dseq"));
                dataModelFieldCollection.setParentId(groupEntry.getLong("parent.id"));
                dataModelFieldCollection.setGroupType(DefaultDataFieldGroupEnum.getEnumByCode(ObjectConverterFactory.getCharacter(groupEntry.get("grouptype")).charValue()));
                if (DefaultDataFieldGroupEnum.HEAD == dataModelFieldCollection.getGroupType()) {
                    dataModelFieldCollection.setTableName(DataModelDaoImpl.getTableName(extDataModel.getNumber()));
                } else {
                    dataModelFieldCollection.setTableName(groupEntry.getString("tablename"));
                }
                groupNumber.add(groupEntry.getString("groupnumber").toLowerCase());
                extDataModel.addEx(dataModelFieldCollection);
            }
            DynamicObjectCollection dataEntrys = DataModelDaoImpl.queryDataEntrysByModelId(id);
            for (DynamicObject dataEntry : dataEntrys) {
                String groupLongNum = dataEntry.getString("group.longnumber");
                String groupName = dataEntry.getString("group.groupname");
                Long groupid = dataEntry.getLong("group.id");
                DataModelFieldCollection dataModelFieldCollection = (DataModelFieldCollection)extDataModel.get(groupLongNum);
                if (dataModelFieldCollection == null) {
                    dataModelFieldCollection = new DataModelFieldCollection(groupid, groupLongNum, groupName);
                    dataModelFieldCollection.setGroupLevel(dataEntry.getInt("group.level"));
                    dataModelFieldCollection.setGroupSeq(dataEntry.getInt("group.dseq"));
                    dataModelFieldCollection.setParentId(dataEntry.getLong("group.parent"));
                    dataModelFieldCollection.setGroupType(DefaultDataFieldGroupEnum.getEnumByCode(ObjectConverterFactory.getCharacter(dataEntry.get("group.grouptype")).charValue()));
                    if (DefaultDataFieldGroupEnum.HEAD == dataModelFieldCollection.getGroupType()) {
                        dataModelFieldCollection.setTableName(DataModelDaoImpl.getTableName(extDataModel.getNumber()));
                    } else {
                        dataModelFieldCollection.setTableName(dataEntry.getString("group.tablename"));
                    }
                    groupNumber.add(dataEntry.getString("group.groupnumber").toLowerCase());
                }
                DataModelFieldCfg dataModelFieldCfg = new DataModelFieldCfg((Long)dataEntry.getLong("id"), dataEntry.getString("number"), dataEntry.getString("name"));
                if (DefaultDataFieldGroupEnum.SYSTEM.getKey().equalsIgnoreCase(groupLongNum)) {
                    dataModelFieldCfg.setCreateType(CreateTypeEnum.SYSTEM.getName());
                } else {
                    dataModelFieldCfg.setCreateType(CreateTypeEnum.CUSTOM.getName());
                }
                DataValueTypeEnum datatype = DataValueTypeEnum.getEnum(dataEntry.getString("datatype"));
                dataModelFieldCfg.setDataType(datatype);
                dataModelFieldCfg.setEnable(dataEntry.getBoolean("isenable"));
                dataModelFieldCfg.setApifield(dataEntry.getString("apifield"));
                if (DataValueTypeEnum.BaseProp == datatype) {
                    dataModelFieldCfg.setRefBaseProp(dataEntry.getString("baseprop"));
                } else if (DataValueTypeEnum.AssistProp == datatype) {
                    dataModelFieldCfg.setRefAssistProp(dataEntry.getLong("assistprop"));
                }
                dataModelFieldCfg.setProps(DataModelUtils.fromJsonToDataModelField(dataEntry.getString("property")));
                dataModelFieldCfg.setSeq(dataEntry.getInt("dseq"));
                dataModelFieldCfg.setVisible(dataEntry.getBoolean("visible"));
                dataModelFieldCfg.setRequired(dataEntry.getBoolean("required"));
                dataModelFieldCfg.setRequiredCondition(dataEntry.getString("requiredcondition"));
                if (DefaultDataFieldGroupEnum.SYSTEM.getKey().equalsIgnoreCase(groupLongNum)) {
                    dataModelFieldCfg.setCreateType(CreateTypeEnum.SYSTEM.getName());
                }
                dataModelFieldCollection.addEx(dataModelFieldCfg);
                extDataModel.addEx(dataModelFieldCollection);
            }
        } else {
            extDataModel = new DataModelCfg();
            SequenceReader sReader = new SequenceReader(new DBRoute("ai"));
            Long[] sequences = (Long[])sReader.getSequences((Object[])new Long[1], "fah_ext_model_fldgrp", 3);
            DataModelFieldCollection systemFields = new DataModelFieldCollection(sequences[0], DefaultDataFieldGroupEnum.SYSTEM.getKey(), new LocaleString(DefaultDataFieldGroupEnum.SYSTEM.getValue()).getLocaleValue());
            systemFields.setGroupType(DefaultDataFieldGroupEnum.SYSTEM);
            systemFields.setGroupSeq(48);
            int seq = 0;
            for (ExtDataModelSystemFieldEnum value : ExtDataModelSystemFieldEnum.values()) {
                DataModelFieldCfg dataModelFieldCfg = new DataModelFieldCfg(null, value.getNumber(), value.getName());
                dataModelFieldCfg.setCreateType(CreateTypeEnum.SYSTEM.getName());
                dataModelFieldCfg.setDataType(value.getType());
                dataModelFieldCfg.setEnable(true);
                dataModelFieldCfg.setApifield(value.getNumber());
                if (value.getType() == DataValueTypeEnum.BaseProp) {
                    dataModelFieldCfg.setRefBaseProp(value.getDynumber());
                }
                dataModelFieldCfg.setVisible(value.isShow());
                dataModelFieldCfg.setRequired(value.isMustinput());
                dataModelFieldCfg.setSeq(seq++);
                BaseMutableArrayMapStorage<String, DataModelFieldPropCfg> props = new BaseMutableArrayMapStorage<String, DataModelFieldPropCfg>();
                if (value == ExtDataModelSystemFieldEnum.SAVE_DEFAULT) {
                    props.addEx(new DataModelFieldPropCfg("defValue", Boolean.class, "false", ResManager.loadKDString((String)"\u9ed8\u8ba4\u503c", (String)"DataModelDaoImpl_13", (String)"fi-ai-common", (Object[])new Object[0])));
                } else {
                    String maxLengthVal = "50";
                    switch (value.getType()) {
                        case String: {
                            if (value != ExtDataModelSystemFieldEnum.DESCRIPTION) break;
                            maxLengthVal = "255";
                            break;
                        }
                        case BillNo: {
                            maxLengthVal = "80";
                            break;
                        }
                        case BaseProp: {
                            props.addEx(new DataModelFieldPropCfg("displayProp", String.class, "name", ResManager.loadKDString((String)"\u663e\u793a\u5c5e\u6027", (String)"DataModelDaoImpl_15", (String)"fi-ai-common", (Object[])new Object[0])));
                            break;
                        }
                        default: {
                            maxLengthVal = null;
                        }
                    }
                    if (!StringUtils.isEmpty((String)maxLengthVal)) {
                        props.addEx(new DataModelFieldPropCfg("maxLength", Integer.class, maxLengthVal, ResManager.loadKDString((String)"\u5b57\u6bb5\u957f\u5ea6", (String)"DataModelDaoImpl_14", (String)"fi-ai-common", (Object[])new Object[0])));
                    }
                }
                dataModelFieldCfg.setProps(props);
                systemFields.cache(dataModelFieldCfg);
            }
            systemFields.flush();
            extDataModel.cache(systemFields);
            DataModelFieldCollection headFields = new DataModelFieldCollection(sequences[1], DefaultDataFieldGroupEnum.HEAD.getKey(), new LocaleString(DefaultDataFieldGroupEnum.HEAD.getValue()).getLocaleValue());
            DataModelFieldCollection entryFields = new DataModelFieldCollection(sequences[2], DefaultDataFieldGroupEnum.ENTRY.getKey(), new LocaleString(DefaultDataFieldGroupEnum.ENTRY.getValue()).getLocaleValue());
            headFields.setGroupType(DefaultDataFieldGroupEnum.HEAD);
            headFields.setGroupSeq(49);
            entryFields.setGroupType(DefaultDataFieldGroupEnum.ENTRY);
            entryFields.setGroupSeq(50);
            extDataModel.cache(headFields);
            extDataModel.cache(entryFields);
            extDataModel.flush();
        }
        for (DataModelFieldCollection collection : (BaseMutableArrayMapStorage)extDataModel.getCollections()) {
            collection.sort(new Comparator<DataModelFieldCfg>(){

                @Override
                public int compare(DataModelFieldCfg o1, DataModelFieldCfg o2) {
                    if (o1 == null && o2 != null) {
                        return -1;
                    }
                    if (o1 != null && o2 == null) {
                        return 1;
                    }
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    return o1.getSeq() - o2.getSeq();
                }
            });
        }
        return new PairTuple((Object)extDataModel, groupNumber);
    }

    private static String getLockKey(String number) {
        return "lockKey$datamodel$" + number;
    }

    private static DynamicObject generateFieldDyn(DataModelFieldCfg field, Long id, Long modelId, Long groupId) {
        DynamicObject fieldDyn = id != null ? BusinessDataServiceHelper.loadSingle((Object)id, (String)"fah_ext_dataentry") : BusinessDataServiceHelper.newDynamicObject((String)"fah_ext_dataentry");
        fieldDyn.set("number", (Object)field.getNumber());
        fieldDyn.set("name", (Object)field.getName());
        fieldDyn.set("datatype", (Object)field.getDataType().getCode());
        fieldDyn.set("apifield", (Object)field.getApifield());
        fieldDyn.set("baseprop", (Object)field.getRefBaseProp());
        fieldDyn.set("assistprop", (Object)field.getRefAssistProp());
        fieldDyn.set("isenable", (Object)field.getEnable());
        if (field.getProps() != null && field.getProps().getValues() != null) {
            fieldDyn.set("property", (Object)JSON.toJSONString(field.getProps().getValues()));
        }
        fieldDyn.set("visible", (Object)field.isVisible());
        fieldDyn.set("required", (Object)field.isRequired());
        fieldDyn.set("requiredcondition", (Object)field.getRequiredCondition());
        fieldDyn.set("model", (Object)modelId);
        fieldDyn.set("group", (Object)groupId);
        fieldDyn.set("dseq", (Object)field.getSeq());
        return fieldDyn;
    }

    private static void deleteDataFields(Set<String> delSet, DynamicObject model) {
        DeleteServiceHelper.delete((String)"fah_ext_dataentry", (QFilter[])new QFilter[]{new QFilter("number", "in", delSet), new QFilter("model", "=", (Object)model.getLong("id"))});
    }

    private static void deleteGroupData(Set<Long> delSet, DynamicObject model) {
        DeleteServiceHelper.delete((String)"fah_ext_model_fldgrp", (QFilter[])new QFilter[]{new QFilter("id", "in", delSet), new QFilter("model", "=", (Object)model.getLong("id"))});
    }

    public static boolean isPublished(Long id) {
        if (id == null) {
            return false;
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("id", "=", (Object)id));
        qfBuilder.add(new QFilter("status", "=", (Object)StatusEnum.PUBLISHED.getCode()));
        return QueryServiceHelper.exists((String)"fah_ext_datamodel", (QFilter[])qfBuilder.toArray());
    }

    public static DynamicObject loadSingleDataModelById(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"fah_ext_datamodel");
    }

    public static DynamicObject getLatestPublishedVersion(String number) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("number", "=", (Object)number));
        qfBuilder.add(new QFilter("latestversion", "=", (Object)"1"));
        qfBuilder.add(new QFilter("status", "=", (Object)StatusEnum.PUBLISHED.getCode()));
        return QueryServiceHelper.queryOne((String)"fah_ext_datamodel", (String)"id,masterid", (QFilter[])qfBuilder.toArray());
    }

    public static void delDynamicForm(String number) {
        DynamicFormConfig config;
        DynamicObject object = DataModelDaoImpl.getLatestPublishedVersion(number);
        if (null != object && null != (config = DynamicFormConfigBuilder.createDynamicFormConfig(object.getLong("id"), FormBuilderConstant.BIZ_APP_ID, true, false))) {
            DynamicFormModelBuilder.deleteBillFormModel(config, true);
        }
    }

    public static DynamicObjectCollection queryPastPublishedRecords(String number) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("number", "=", (Object)number));
        qfBuilder.add(new QFilter("status", "=", (Object)StatusEnum.PUBLISHED.getCode()));
        return QueryServiceHelper.query((String)"fah_ext_datamodel", (String)"id", (QFilter[])qfBuilder.toArray());
    }

    public static void deleteModelAndGroupEntryInfo(Long id) {
        QFilter modelQF = new QFilter("id", "=", (Object)id);
        DeleteServiceHelper.delete((String)"fah_ext_datamodel", (QFilter[])new QFilter[]{modelQF});
        QFilter qFilter = new QFilter("model", "=", (Object)id);
        DeleteServiceHelper.delete((String)"fah_ext_model_fldgrp", (QFilter[])new QFilter[]{qFilter});
        DeleteServiceHelper.delete((String)"fah_ext_dataentry", (QFilter[])new QFilter[]{qFilter});
    }

    public static Set<String> getDeletedGroupFields(Long modelId, String groupLongnum) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)modelId));
        qfBuilder.add(new QFilter("group.longnumber", "=", (Object)groupLongnum));
        DynamicObjectCollection fields = QueryServiceHelper.query((String)"fah_ext_dataentry", (String)"number", (QFilter[])qfBuilder.toArray());
        return fields.stream().map(o -> o.getString("number")).collect(Collectors.toSet());
    }

    public static void dropTable(DBRoute dbRoute, Set<String> tableNames) {
        ArrayList<String> needDropTables = new ArrayList<String>(tableNames.size());
        String queSql = "select 1 from %s";
        for (String tableName : tableNames) {
            DataModelDaoImpl.checkTableBeforeDrop(dbRoute, needDropTables, queSql, tableName);
        }
        DataModelDaoImpl.excuteDropTable(dbRoute, needDropTables);
    }

    private static void checkTableBeforeDrop(DBRoute dbRoute, List<String> needDropTables, String queSql, String tableName) {
        if (DB.exitsTable((DBRoute)dbRoute, (String)tableName)) {
            try (DataSet ds = DB.queryDataSet((String)DataModelDaoImpl.class.getName(), (DBRoute)dbRoute, (String)String.format(queSql, tableName));){
                if (ds.isEmpty()) {
                    needDropTables.add(tableName);
                } else {
                    log.warn("\u8868\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff1aneedDropTable = " + tableName);
                }
            }
        }
    }

    public static boolean existTable(DBRoute dbRoute, String tableName) {
        return DB.exitsTable((DBRoute)dbRoute, (String)tableName);
    }

    public static boolean existsBizData(Set<String> tables, DBRoute dbRoute) {
        String algoKey = DataModelDaoImpl.class.getName() + ".existBillBizData()";
        String queSql = "select 1 from %s";
        ArrayList<String> needDropTables = new ArrayList<String>(tables.size());
        for (String tableName : tables) {
            if (!DB.exitsTable((DBRoute)dbRoute, (String)tableName)) continue;
            try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)dbRoute, (String)String.format(queSql, tableName));){
                if (!ds.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
            }
            needDropTables.add(tableName);
        }
        DataModelDaoImpl.excuteDropTable(dbRoute, needDropTables);
        return false;
    }

    private static void excuteDropTable(DBRoute dbRoute, List<String> needDropTables) {
        for (String delTableName : needDropTables) {
            DB.execute((DBRoute)dbRoute, (String)String.format("drop table %s;", delTableName));
            log.info(String.format("\u5220\u9664\u8868\u6210\u529f\uff1atable\u3010%s\u3011", delTableName));
        }
    }

    public static List<String> getColumn(DBRoute dbRoute, String table) {
        return DB.getColumnNames((DBRoute)dbRoute, (String)table);
    }

    public static void updateFieldLength(DBRoute dbRoute, String tableName, String field, Integer length) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                DB.execute((DBRoute)dbRoute, (String)String.format("EXEC p_AlterColumn '%s', '%s', 'NVARCHAR(%s)', 'NOT NULL', '0100', ''' ''';", tableName, field, length));
                log.info(String.format("\u66f4\u65b0\u5b57\u6bb5\u957f\u5ea6\u6210\u529f\uff1atable\u3010%s\u3011,field\u3010%s\u3011", tableName, field));
            }
            catch (Exception e) {
                log.error(String.format("\u66f4\u65b0\u5b57\u6bb5\u957f\u5ea6\u51fa\u9519\uff1atable\u3010%s\u3011,field\u3010%s\u3011", tableName, field), (Throwable)e);
                tx.markRollback();
                throw e;
            }
        }
    }

    public static void dropFields(DBRoute dbRoute, String tableName, String field) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                DB.execute((DBRoute)dbRoute, (String)String.format("alter table %s drop column %s", tableName, field));
                log.info(String.format("\u5220\u9664\u5b57\u6bb5\u6210\u529f\uff1atable\u3010%s\u3011,field\u3010%s\u3011", tableName, field));
            }
            catch (Exception e) {
                log.error(String.format("\u5220\u9664\u5b57\u6bb5\u51fa\u9519\uff1atable\u3010%s\u3011,field\u3010%s\u3011", tableName, field), (Throwable)e);
                tx.markRollback();
                throw e;
            }
        }
    }

    public static boolean isPublishedStatus(Long modelId) {
        if (modelId == null || modelId == 0L) {
            return false;
        }
        DynamicObject model = QueryServiceHelper.queryOne((String)"fah_ext_datamodel", (String)"status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)});
        return StatusEnum.PUBLISHED.getCode().equalsIgnoreCase(model.getString("status"));
    }

    public static DataModelCfg generateDeleteDataModel(DynamicObject savedModel, DynamicObject deletedModel, List<String> checkFields) {
        DataModelCfg dataModelCfg = new DataModelCfg(null, savedModel.getString("number"), null);
        DynamicObjectCollection rollBackGroups = QueryServiceHelper.query((String)"fah_ext_model_fldgrp", (String)"groupname,longnumber,grouptype,tablename,level,dseq", (QFilter[])new QFilter("model", "=", (Object)deletedModel.getLong("id")).toArray());
        DynamicObjectCollection saveGroups = QueryServiceHelper.query((String)"fah_ext_model_fldgrp", (String)"longnumber", (QFilter[])new QFilter("model", "=", (Object)savedModel.getLong("id")).toArray());
        Set rollBackGroupNums = rollBackGroups.stream().map(o -> o.getString("longnumber")).collect(Collectors.toSet());
        Set saveGroupNums = saveGroups.stream().map(o -> o.getString("longnumber")).collect(Collectors.toSet());
        HashMap groupMap = new HashMap(rollBackGroups.size());
        rollBackGroups.stream().forEach(o -> groupMap.put(o.getString("longnumber"), o));
        HashSet set = new HashSet(rollBackGroupNums);
        rollBackGroupNums.removeAll(saveGroupNums);
        if (!rollBackGroupNums.isEmpty()) {
            DynamicObjectCollection fields = QueryServiceHelper.query((String)"fah_ext_dataentry", (String)"number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)deletedModel.getLong("id")), new QFilter("group.longnumber", "in", rollBackGroupNums)});
            fields.stream().forEach(o -> checkFields.add(o.getString("number")));
            for (String rollBackGroupNum : rollBackGroupNums) {
                DynamicObject group = (DynamicObject)groupMap.get(rollBackGroupNum);
                DataModelFieldCollection dataModelFieldCollection = new DataModelFieldCollection(null, rollBackGroupNum, null);
                dataModelFieldCollection.setGroupType(DefaultDataFieldGroupEnum.getEnumByCode(ObjectConverterFactory.getCharacter(group.getString("grouptype")).charValue()));
                dataModelFieldCollection.setTableName(group.getString("tablename"));
                dataModelFieldCollection.setGroupLevel(group.getInt("level"));
                dataModelFieldCollection.setGroupSeq(group.getInt("dseq"));
                dataModelFieldCollection.setName(group.getString("groupname"));
                dataModelCfg.cache(dataModelFieldCollection);
            }
            dataModelCfg.flush();
        }
        for (String groupnum : set) {
            DataModelFieldCollection dataModelFieldCollection = (DataModelFieldCollection)dataModelCfg.get(groupnum);
            if (dataModelFieldCollection != null) continue;
            DynamicObjectCollection rollBackFields = QueryServiceHelper.query((String)"fah_ext_dataentry", (String)"number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)deletedModel.getLong("id")), new QFilter("group.longnumber", "=", (Object)groupnum)});
            DynamicObjectCollection saveFields = QueryServiceHelper.query((String)"fah_ext_dataentry", (String)"number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)savedModel.getLong("id")), new QFilter("group.longnumber", "=", (Object)groupnum)});
            Set rollBackFieldNums = rollBackFields.stream().map(o -> o.getString("number")).collect(Collectors.toSet());
            Set saveFieldNums = saveFields.stream().map(o -> o.getString("number")).collect(Collectors.toSet());
            rollBackFieldNums.removeAll(saveFieldNums);
            if (rollBackFieldNums.isEmpty()) continue;
            DynamicObject group = (DynamicObject)groupMap.get(groupnum);
            DataModelFieldCollection dataModelFieldCollection2 = new DataModelFieldCollection(null, groupnum, null);
            dataModelFieldCollection2.setGroupType(DefaultDataFieldGroupEnum.getEnumByCode(ObjectConverterFactory.getCharacter(group.getString("grouptype")).charValue()));
            dataModelFieldCollection2.setTableName(group.getString("tablename"));
            dataModelFieldCollection2.setGroupLevel(group.getInt("level"));
            dataModelFieldCollection2.setGroupSeq(group.getInt("dseq"));
            dataModelFieldCollection2.setName(group.getString("groupname"));
            for (String rollBackFieldNum : rollBackFieldNums) {
                DataModelFieldCfg dataModelFieldCfg = new DataModelFieldCfg(null, rollBackFieldNum, null);
                dataModelFieldCollection2.cache(dataModelFieldCfg);
                checkFields.add(rollBackFieldNum);
            }
            dataModelFieldCollection2.flush();
            dataModelCfg.addEx(dataModelFieldCollection2);
        }
        return dataModelCfg;
    }

    public static DataModelCfg generateModifiedDataModel(DynamicObject saveModel, DynamicObject backupModel, List<String> checkFields) {
        DataModelCfg saveModelCfg = (DataModelCfg)DataModelDaoImpl.loadFromDBById(saveModel.getLong("id")).getKey();
        DataModelCfg backupModelCfg = (DataModelCfg)DataModelDaoImpl.loadFromDBById(backupModel.getLong("id")).getKey();
        DataModelCfg result = new DataModelCfg(null, saveModelCfg.getNumber(), null);
        for (DataModelFieldCollection group : saveModelCfg) {
            DataModelFieldCollection backUpGroup = (DataModelFieldCollection)backupModelCfg.get(group.getNumber());
            if (group.getCollections() == null || backUpGroup == null) continue;
            DataModelFieldCollection resultGroup = new DataModelFieldCollection(null, group.getNumber(), null);
            for (DataModelFieldCfg fieldCfg : (BaseMutableArrayMapStorage)group.getCollections()) {
                DataModelFieldCfg backUpFieldCfg = (DataModelFieldCfg)backUpGroup.get(fieldCfg.getNumber());
                if (backUpFieldCfg == null || JSON.toJSONString((Object)fieldCfg).equals(JSON.toJSONString((Object)backUpFieldCfg))) continue;
                fieldCfg.setId(null);
                backUpFieldCfg.setId(null);
                DataModelFieldCfg resultField = new DataModelFieldCfg(null, fieldCfg.getNumber(), null);
                resultField.setProps(new DataModelFieldCfg.FieldPropCollectionImpl());
                DataModelDaoImpl.setChangedInfo(fieldCfg, backUpFieldCfg, resultField, checkFields);
                resultField.setDataType(fieldCfg.getDataType());
                resultGroup.cache(resultField);
            }
            resultGroup.setGroupType(group.getGroupType());
            resultGroup.setTableName(group.getTableName());
            resultGroup.flush();
            if (resultGroup.isEmpty()) continue;
            result.cache(resultGroup);
        }
        result.flush();
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    private static void setChangedInfo(DataModelFieldCfg model, DataModelFieldCfg backupModel, DataModelFieldCfg result, List<String> checkFields) {
        if (!StringUtils.isEquals(model.getName(), backupModel.getName())) {
            result.setName(model.getName());
        }
        if (model.getDataType() != backupModel.getDataType()) {
            result.setDataType(model.getDataType());
            checkFields.add(model.getNumber());
        }
        if (!StringUtils.isEquals(model.getRefBaseProp(), backupModel.getRefBaseProp())) {
            result.setRefBaseProp(model.getRefBaseProp());
        }
        if (!ICommonDataValueUtil.isEquals(model.getRefAssistProp(), backupModel.getRefAssistProp())) {
            result.setRefAssistProp(model.getRefAssistProp());
        }
        if (model.isVisible() != backupModel.isVisible()) {
            result.setVisible(model.isVisible());
        }
        if (model.isRequired() != backupModel.isRequired()) {
            result.setRequired(model.isRequired());
        }
        if (!StringUtils.isEquals(model.getRequiredCondition(), backupModel.getRequiredCondition())) {
            result.setRequiredCondition(model.getRequiredCondition());
        }
        if (!Objects.equals(model.getSeq(), backupModel.getSeq())) {
            result.setSeq(model.getSeq());
        }
        if (!JSON.toJSONString(model.getProps()).equals(JSON.toJSONString(backupModel.getProps())) && backupModel.getProps() != null && model.getProps() != null) {
            for (DataModelFieldPropCfg prop : model.getProps()) {
                DataModelFieldPropCfg backUpProp = (DataModelFieldPropCfg)backupModel.getProps().get(prop.getName());
                if (backUpProp == null) continue;
                DataModelFieldPropCfg resultProp = new DataModelFieldPropCfg(prop.getName(), null, null);
                if (prop.getPropDataType() != backUpProp.getPropDataType()) {
                    resultProp.setPropDataType(prop.getPropDataType());
                }
                if (prop.getPropValue() != backUpProp.getPropValue()) {
                    resultProp.setPropValue(prop.getPropValue());
                }
                if (!StringUtils.isEquals(prop.getDescription(), backUpProp.getDescription())) {
                    resultProp.setDescription(prop.getDescription());
                }
                result.getProps().cache(resultProp);
                if (!FieldPropEnum.MAXLENGTH.getNumber().equals(prop.getName()) || JSON.toJSONString((Object)prop).equals(JSON.toJSONString((Object)backUpProp))) continue;
                checkFields.add(model.getNumber());
            }
            result.getProps().flush();
        }
    }

    public static boolean isHavingExtData(Long modelId) {
        if (modelId == null) {
            return false;
        }
        QFilter qFilter = new QFilter("eventclass", "=", (Object)modelId);
        return QueryServiceHelper.exists((String)"ai_event", (QFilter[])qFilter.toArray());
    }

    public static boolean isHavingExtData(String number) {
        QFilter qFilter = new QFilter("eventclass.number", "=", (Object)number);
        return QueryServiceHelper.exists((String)"ai_event", (QFilter[])qFilter.toArray());
    }

    public static boolean isModelReferred(long masterId) {
        String sql = "select count(1) as counts from t_ai_preevent where fid = ? or fpreeventclass = ?";
        int counts = 0;
        try (DataSet dataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl.isModelReferred", (DBRoute)FAHCommonConstant.AI, (String)sql, (Object[])new Object[]{masterId, masterId});){
            if (dataSet.hasNext()) {
                Row next = dataSet.next();
                counts = next.getInteger("counts");
            }
        }
        return counts > 0;
    }

    public static DynamicObject queryUnpublishedRecord(Long masterId) {
        QFilter qf1 = new QFilter("masterid", "=", (Object)masterId);
        QFilter qf2 = new QFilter("status", "=", (Object)StatusEnum.UNPUBLISHED.getCode());
        DynamicObject model = QueryServiceHelper.queryOne((String)"fah_ext_datamodel", (String)"id", (QFilter[])new QFilter[]{qf1, qf2});
        return model == null ? null : DataModelDaoImpl.loadSingleDataModelById(model.getLong("id"));
    }

    public static DynamicObject queryUnpublishedRecordByNumber(String number) {
        QFilter qf1 = new QFilter("number", "=", (Object)number);
        QFilter qf2 = new QFilter("status", "=", (Object)StatusEnum.UNPUBLISHED.getCode());
        DynamicObject model = QueryServiceHelper.queryOne((String)"fah_ext_datamodel", (String)"id", (QFilter[])new QFilter[]{qf1, qf2});
        return model == null ? null : DataModelDaoImpl.loadSingleDataModelById(model.getLong("id"));
    }

    public static Long copyModelDyn(DynamicObject model, boolean isUpdateVersionNum) {
        SequenceReader sReader = new SequenceReader(new DBRoute("ai"));
        Long[] modelId = (Long[])sReader.getSequences((Object[])new Long[1], "fah_ext_datamodel", 1);
        DynamicObject tempModel = BusinessDataServiceHelper.newDynamicObject((String)"fah_ext_datamodel");
        tempModel.set("id", (Object)modelId[0]);
        tempModel.set("masterid", (Object)model.getLong("masterid"));
        if (isUpdateVersionNum) {
            tempModel.set("versionnum", (Object)(model.getInt("versionnum") + 1));
        } else {
            tempModel.set("versionnum", (Object)model.getInt("versionnum"));
        }
        tempModel.set("latestversion", (Object)"1");
        tempModel.set("enable", (Object)"0");
        tempModel.set("status", (Object)StatusEnum.UNPUBLISHED.getCode());
        tempModel.set("number", (Object)model.getString("number"));
        tempModel.set("name", (Object)model.getString("name"));
        tempModel.set("group", (Object)model.getLong("group.id"));
        tempModel.set("templateno", (Object)model.getString("templateno.number"));
        tempModel.set("description", (Object)model.getString("description"));
        tempModel.set("creator", (Object)model.getLong("creator.id"));
        tempModel.set("createtime", (Object)model.getDate("createtime"));
        tempModel.set("modifier", (Object)model.getLong("modifier.id"));
        tempModel.set("modifytime", (Object)model.getDate("modifytime"));
        tempModel.set("appversion", (Object)model.getString("appversion"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tempModel});
        DynamicObjectCollection groupEntrys = DataModelDaoImpl.queryDataGroupsByModelId(model.getLong("id"));
        LinkedList<DynamicObject> groupSaveList = new LinkedList<DynamicObject>();
        Long[] groupIds = (Long[])sReader.getSequences((Object[])new Long[1], "fah_ext_model_fldgrp", groupEntrys.size());
        HashMap<String, Long> groupIdMap = new HashMap<String, Long>(groupEntrys.size());
        int index = 0;
        for (DynamicObject group : groupEntrys) {
            DynamicObject tempGroup = BusinessDataServiceHelper.newDynamicObject((String)"fah_ext_model_fldgrp");
            tempGroup.set("id", (Object)groupIds[index]);
            tempGroup.set("model", (Object)modelId[0]);
            tempGroup.set("dseq", (Object)group.getInt("dseq"));
            tempGroup.set("grouptype", (Object)group.getString("grouptype"));
            tempGroup.set("groupname", (Object)group.getString("groupname"));
            tempGroup.set("groupnumber", (Object)group.getString("groupnumber"));
            tempGroup.set("tablename", (Object)group.getString("tablename"));
            tempGroup.set("longnumber", (Object)group.getString("longnumber"));
            tempGroup.set("level", (Object)group.getInt("level"));
            tempGroup.set("isleaf", group.get("isleaf"));
            if (!StringUtils.isEmpty((String)group.getString("parent.longnumber"))) {
                tempGroup.set("parent", groupIdMap.get(group.getString("parent.longnumber")));
            }
            groupSaveList.add(tempGroup);
            groupIdMap.put(group.getString("longnumber"), groupIds[index]);
            ++index;
        }
        SaveServiceHelper.save((DynamicObject[])groupSaveList.toArray(new DynamicObject[0]));
        DynamicObjectCollection dataEntrys = DataModelDaoImpl.queryDataEntrysByModelId(model.getLong("id"));
        LinkedList<DynamicObject> fieldSaveList = new LinkedList<DynamicObject>();
        Long[] fieldIds = (Long[])sReader.getSequences((Object[])new Long[1], "fah_ext_dataentry", dataEntrys.size());
        index = 0;
        for (DynamicObject field : dataEntrys) {
            DynamicObject tempField = BusinessDataServiceHelper.newDynamicObject((String)"fah_ext_dataentry");
            tempField.set("id", (Object)fieldIds[index++]);
            tempField.set("model", (Object)modelId[0]);
            tempField.set("number", (Object)field.getString("number"));
            tempField.set("name", (Object)field.getString("name"));
            tempField.set("datatype", (Object)field.getString("datatype"));
            tempField.set("isenable", (Object)field.getBoolean("isenable"));
            tempField.set("apifield", (Object)field.getString("apifield"));
            tempField.set("baseprop", (Object)field.getString("baseprop"));
            tempField.set("assistprop", (Object)field.getLong("assistprop"));
            tempField.set("property", (Object)field.getString("property"));
            tempField.set("visible", field.get("visible"));
            tempField.set("required", field.get("required"));
            tempField.set("requiredcondition", (Object)field.getString("requiredcondition"));
            tempField.set("group", groupIdMap.get(field.getString("group.longnumber")));
            tempField.set("dseq", (Object)field.getInt("dseq"));
            fieldSaveList.add(tempField);
        }
        SaveServiceHelper.save((DynamicObject[])fieldSaveList.toArray(new DynamicObject[0]));
        return modelId[0];
    }

    public static void switchEnable(String enable, Long modelId) {
        DynamicObject model = DataModelDaoImpl.loadSingleDataModelById(modelId);
        model.set("enable", (Object)enable);
        if ("0".equals(enable)) {
            model.set("disabledtime", (Object)new Date());
            model.set("disabledby", (Object)UserServiceHelper.getCurrentUserId());
            model.set("enabledtime", null);
            model.set("enabledby", null);
        } else if ("1".equals(enable)) {
            model.set("enabledtime", (Object)new Date());
            model.set("enabledby", (Object)UserServiceHelper.getCurrentUserId());
            model.set("disabledtime", null);
            model.set("disabledby", null);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{model});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object publish(DynamicObject model) {
        if (model == null) {
            return ResManager.loadKDString((String)"\u672a\u4fee\u6539\u5df2\u53d1\u5e03\u6a21\u578b\uff0c\u65e0\u9700\u91cd\u590d\u53d1\u5e03\u3002", (String)"DataModelDaoImpl_46", (String)"fi-ai-common", (Object[])new Object[0]);
        }
        String lockKey = DataModelDaoImpl.getLockKey(model.getString("number"));
        try (DLock lock = DLock.create((String)lockKey).fastMode();){
            Long latestModelId;
            if (!lock.tryLock()) throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5e03\u5f0f\u4e8b\u52a1\u9501\u52a0\u9501\u5931\u8d25\u3002", (String)"DataModelDaoImpl_3", (String)"fi-ai-common", (Object[])new Object[0]));
            if (!DataModelDaoImpl.uniqueNumberCheck(model.getLong("masterid"), model.getString("number"))) {
                String string = ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d", (String)"DataModelDaoImpl_47", (String)"fi-ai-common", (Object[])new Object[0]);
                return string;
            }
            long modelID = model.getLong("id");
            if (!DataModelDaoImpl.fieldPropertyCheck(modelID)) {
                String string = ResManager.loadKDString((String)"\u5b57\u6bb5\u5c5e\u6027\u6821\u9a8c\u672a\u901a\u8fc7", (String)"DataModelDaoImpl_48", (String)"fi-ai-common", (Object[])new Object[0]);
                return string;
            }
            DataModelDiff dataModelDiff = null;
            String tableName = DataModelDaoImpl.getTableName(model.getString("number"));
            boolean isModelHasMetaData = MetadataDao.checkNumber((String)tableName) && DataModelDaoImpl.existTable(DBRoute.of((String)"fi"), tableName);
            boolean isModelChanged = false;
            int eventCounts = 0;
            boolean isModelReferred = false;
            DynamicObject latestModel = DataModelDaoImpl.getLatestPublishedVersion(model.getString("number"));
            Long l = latestModelId = latestModel == null ? null : Long.valueOf(latestModel.getLong("id"));
            if (isModelHasMetaData && null != latestModel) {
                Map<Long, Set<String>> map;
                DataModelCfg newModelCfg = (DataModelCfg)DataModelDaoImpl.loadFromDBById(modelID).getKey();
                DataModelCfg latestModelCfg = (DataModelCfg)DataModelDaoImpl.loadFromDBById(latestModelId).getKey();
                LinkedHashSet<String> maxLengthUpdateNumber = new LinkedHashSet<String>(5);
                DataModelDaoImpl.fieldChangeCheckForUsedModel(maxLengthUpdateNumber, newModelCfg, latestModelCfg);
                isModelChanged = DataModelDaoImpl.isModelChanged(latestModelCfg, newModelCfg);
                if (!isModelChanged) {
                    String checkFields = ResManager.loadKDString((String)"\u672a\u4fee\u6539\u5df2\u53d1\u5e03\u6a21\u578b\uff0c\u65e0\u9700\u91cd\u590d\u53d1\u5e03\u3002", (String)"DataModelDaoImpl_46", (String)"fi-ai-common", (Object[])new Object[0]);
                    return checkFields;
                }
                LinkedList<String> checkFields = new LinkedList<String>();
                DataModelCfg deleteDataModel = DataModelDaoImpl.generateDeleteDataModel(model, latestModel, checkFields);
                DataModelCfg modifiedDataModel = DataModelDaoImpl.generateModifiedDataModel(model, latestModel, checkFields);
                dataModelDiff = new DataModelDiff();
                dataModelDiff.setModelId(latestModelId);
                dataModelDiff.setDeletedCfgs(deleteDataModel);
                dataModelDiff.setModifiedCfgs(modifiedDataModel);
                dataModelDiff.setMaxLengthUpdateNumber(maxLengthUpdateNumber);
                if (!checkFields.isEmpty() && !(map = VchTemplateRefValidator.checkVchTemplateRefessrence(newModelCfg.getMainTableName(), checkFields)).isEmpty()) {
                    Map<Long, Set<String>> map2 = map;
                    return map2;
                }
                eventCounts = DataModelDaoImpl.getEventRecordCounts(latestModelCfg.getId());
                isModelReferred = DataModelDaoImpl.isModelReferred(latestModelCfg.getMasterId());
            }
            ConditionContext context = new ConditionContext(isModelHasMetaData, isModelChanged, eventCounts, isModelReferred);
            DynamicFormConfig latestConfig = null;
            if (null != latestModel) {
                latestConfig = DynamicFormConfigBuilder.createDynamicFormConfig(latestModelId, FormBuilderConstant.BIZ_APP_ID, true, false);
            }
            LinkedList<DynamicObject> saveList = new LinkedList<DynamicObject>();
            model.set("status", (Object)StatusEnum.PUBLISHED.getCode());
            model.set("latestversion", (Object)"1");
            model.set("enable", (Object)"1");
            model.set("modifier", (Object)RequestContext.get().getCurrUserId());
            model.set("modifytime", (Object)new Date());
            model.set("enabledtime", (Object)new Date());
            model.set("enabledby", (Object)RequestContext.get().getCurrUserId());
            DynamicObjectCollection records = DataModelDaoImpl.queryPastPublishedRecords(model.getString("number"));
            for (DynamicObject record : records) {
                DynamicObject model2 = DataModelDaoImpl.loadSingleDataModelById(record.getLong("id"));
                if (model2.getString("latestversion").equals("1")) {
                    model2.set("refdatacnt", (Object)eventCounts);
                }
                model2.set("latestversion", (Object)"0");
                model2.set("enable", (Object)"0");
                if (null == model2.get("disabledtime")) {
                    model2.set("disabledtime", (Object)new Date());
                    model2.set("disabledby", (Object)RequestContext.get().getCurrUserId());
                }
                saveList.add(model2);
            }
            try (TXHandle handle = TX.requiresNew((String)"FahExtDataModelTreeList.enable");){
                try {
                    if (context.isDeleteLatestPublishedRecord()) {
                        DataModelDaoImpl.deleteModelAndGroupEntryInfo(latestModelId);
                        model.set("versionnum", (Object)(model.getInt("versionnum") - 1));
                    }
                    saveList.add(model);
                    SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
                    DataModelDaoImpl.createBillFormModel(modelID, dataModelDiff, latestConfig);
                    if (context.isDeleteLatestPublishedRecord()) {
                        DataModelDaoImpl.updateDataModelId(modelID, latestModelId);
                    }
                }
                catch (Exception e) {
                    handle.markRollback();
                    throw e;
                }
            }
            cacheService.removeFromCache(cacheService.buildCacheTypeKey(model.getString("number"), new Object[0]));
            return null;
        }
    }

    private static void updateDataModelId(long modelID, long latestModelId) {
        String sql1 = "update t_ai_eventclass set fid = ? where fid = ?";
        String sql2 = "update t_ai_eventclass_l set fid = ? where fid = ?";
        String sql3 = "update t_fah_ext_modfldgrp set fmodelid = ? where fmodelid = ?";
        String sql4 = "update t_fah_ext_modflds set fmodelid = ? where fmodelid = ?";
        Object[] params = new Object[]{latestModelId, modelID};
        DB.execute((DBRoute)FAHCommonConstant.AI, (String)sql1, (Object[])params);
        DB.execute((DBRoute)FAHCommonConstant.AI, (String)sql2, (Object[])params);
        DB.execute((DBRoute)FAHCommonConstant.AI, (String)sql3, (Object[])params);
        DB.execute((DBRoute)FAHCommonConstant.AI, (String)sql4, (Object[])params);
    }

    private static boolean fieldPropertyCheck(long id) {
        return true;
    }

    public static void clearErrorMeta(String formNumber) {
        if (null != formNumber && (formNumber.startsWith("fah_e_") || formNumber.startsWith("fah_et_"))) {
            try (TXHandle h = TX.notSupported();){
                Object[] param = new Object[]{formNumber};
                DBRoute dbRoute = DBRoute.meta;
                DB.execute((DBRoute)dbRoute, (String)"DELETE FROM T_META_BIZUNITRELFORM WHERE FBIZUNITID=? AND FFORMID IN (SELECT FID FROM T_META_FORMDESIGN WHERE FNUMBER = ?);", (Object[])new Object[]{FormBuilderConstant.BIZ_UNIT_ID, formNumber});
                DB.execute((DBRoute)dbRoute, (String)"DELETE FROM T_META_BIZUNITRELFORM WHERE FBIZUNITID=? AND FFORMID IN (SELECT FID FROM T_META_ENTITYDESIGN WHERE FNUMBER = ?);", (Object[])new Object[]{FormBuilderConstant.BIZ_UNIT_ID, formNumber});
                DB.execute((DBRoute)dbRoute, (String)"DELETE FROM T_META_FORMDESIGN WHERE FNUMBER = ?;", (Object[])param);
                DB.execute((DBRoute)dbRoute, (String)"DELETE FROM T_META_FORMDESIGN_L WHERE FNUMBER = ?;", (Object[])param);
                DB.execute((DBRoute)dbRoute, (String)"DELETE FROM T_META_ENTITYDESIGN WHERE FNUMBER = ?;", (Object[])param);
                DB.execute((DBRoute)dbRoute, (String)"DELETE FROM T_META_ENTITYDESIGN_L WHERE FNUMBER = ?;", (Object[])param);
                DB.execute((DBRoute)dbRoute, (String)"DELETE FROM T_META_FORM WHERE FNUMBER = ?;", (Object[])param);
                DB.execute((DBRoute)dbRoute, (String)"DELETE FROM T_META_ENTITY WHERE FNUMBER = ?;", (Object[])param);
                DB.execute((DBRoute)dbRoute, (String)"DELETE FROM T_META_ENTITYINFO WHERE FID = ?;", (Object[])param);
                DB.execute((DBRoute)dbRoute, (String)"DELETE FROM T_META_MAINENTITYINFO WHERE FID = ?;", (Object[])param);
                DB.execute((DBRoute)dbRoute, (String)"DELETE FROM T_META_MAINENTITYINFO_L WHERE FID = ?;", (Object[])param);
            }
        }
    }

    private static void createBillFormModel(Long modelId, DataModelDiff dataModelDiff, DynamicFormConfig latestConfig) {
        DynamicFormConfig config = DynamicFormConfigBuilder.createDynamicFormConfig(modelId, FormBuilderConstant.BIZ_APP_ID, true, true);
        if (null != config) {
            String formId;
            Map<String, Object> result;
            block37: {
                result = null;
                try {
                    if (!DataModelDaoImpl.existTable(DBRoute.of((String)"fi"), config.getFormNumber())) {
                        DataModelDaoImpl.clearErrorMeta(config.getFormNumber());
                    }
                    if (MetadataDao.checkNumber((String)config.getFormNumber())) {
                        boolean existData;
                        try (TXHandle h = TX.notSupported();){
                            existData = DataModelDaoImpl.tableExistData(config.getFormNumber(), DBRoute.of((String)"fi"));
                        }
                        if (existData) {
                            config.setFormId(MetadataDao.getIdByNumber((String)config.getFormNumber(), (MetaCategory)MetaCategory.Form));
                            result = DynamicFormModelBuilder.updateDynamicForm(config, dataModelDiff);
                            break block37;
                        }
                        if (null != latestConfig) {
                            h = TX.notSupported();
                            var7_6 = null;
                            try {
                                DynamicFormModelBuilder.deleteBillFormModel(latestConfig, true);
                            }
                            catch (Throwable throwable) {
                                var7_6 = throwable;
                                throw throwable;
                            }
                            finally {
                                if (h != null) {
                                    if (var7_6 != null) {
                                        try {
                                            h.close();
                                        }
                                        catch (Throwable throwable) {
                                            var7_6.addSuppressed(throwable);
                                        }
                                    } else {
                                        h.close();
                                    }
                                }
                            }
                        }
                        if (!MetadataDao.checkNumber((String)config.getFormNumber())) {
                            result = DynamicFormModelBuilder.createDynamicForm(config);
                        }
                        break block37;
                    }
                    result = DynamicFormModelBuilder.createDynamicForm(config);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    log.error((Throwable)e);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u52a8\u6001\u5355\u636e\u5931\u8d25\uff1a%s\u3002", (String)"DataModelDaoImpl_34", (String)"fi-ai-common", (Object[])new Object[0]), e.getMessage()));
                }
            }
            boolean success = null != result && (Boolean)result.get("success") != false;
            String string = formId = null != result ? (String)result.get("formid") : null;
            if (Boolean.FALSE.equals(success)) {
                String errorMsg = null != result ? (String)result.get("message") : "";
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u52a8\u6001\u5355\u636e\u5931\u8d25\uff1a%s\u3002", (String)"DataModelDaoImpl_34", (String)"fi-ai-common", (Object[])new Object[0]), errorMsg));
            }
            DynamicFormConfig createConfig = DynamicFormConfigBuilder.createDynamicFormConfig(modelId, FormBuilderConstant.BIZ_APP_ID, true, false);
            if (null != createConfig && MetadataDao.checkNumber((String)createConfig.getFormNumber()) && null != formId) {
                createConfig.setFormId(formId);
                try {
                    DynamicFormModelBuilder.updateDynamicForm(createConfig, null);
                }
                catch (Exception e) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u52a8\u6001\u5355\u636e\u5931\u8d25\uff1a%s\u3002", (String)"DataModelDaoImpl_34", (String)"fi-ai-common", (Object[])new Object[0]), e.getMessage()));
                }
            }
        }
    }

    public static List<Map<String, String>> generateDisplayData(Map<String, Map<Long, Set<String>>> map) {
        String TEMPLATE_NUMBER = "templatenumber";
        String TEMPLATE_NAME = "templatename";
        String TEMPLATE_ID = "templateid";
        String MESSAGE = "message";
        LinkedList<Map<String, String>> result = new LinkedList<Map<String, String>>();
        for (Map.Entry<String, Map<Long, Set<String>>> entry1 : map.entrySet()) {
            String modelNum = entry1.getKey();
            String tablename = "fah_e_" + modelNum;
            QFilter qf1 = new QFilter("fsourcebill", "=", (Object)tablename);
            QFilter qf2 = new QFilter("id", "in", entry1.getValue().keySet());
            DynamicObjectCollection vchtemplate = QueryServiceHelper.query((String)"ai_vchtemplate", (String)"id,number,name", (QFilter[])new QFilter[]{qf1, qf2});
            HashMap vchmap = new HashMap(vchtemplate.size());
            vchtemplate.stream().forEach(o -> vchmap.put(o.getLong("id"), new PairTuple((Object)o.getString("number"), (Object)o.getString("name"))));
            HashSet fieldNums = new HashSet(16);
            entry1.getValue().values().stream().forEach(o -> fieldNums.addAll(o));
            QFBuilder qb1 = new QFBuilder("model.number", "=", (Object)modelNum);
            qb1.add("model.status", "=", (Object)StatusEnum.PUBLISHED.getCode());
            qb1.add("model.latestversion", "=", (Object)"1");
            qb1.add("number", "in", fieldNums);
            DynamicObjectCollection fields = QueryServiceHelper.query((String)"fah_ext_dataentry", (String)"number,name", (QFilter[])qb1.toArray());
            HashMap fieldmap = new HashMap(vchtemplate.size());
            fields.stream().forEach(o -> fieldmap.put(o.getString("number"), o.getString("name")));
            for (Map.Entry<Long, Set<String>> entry2 : entry1.getValue().entrySet()) {
                StringBuilder message = new StringBuilder(ResManager.loadKDString((String)"\u5f15\u7528\u6a21\u578b\u5b57\u6bb5", (String)"DataModelDaoImpl_33", (String)"fi-ai-common", (Object[])new Object[0]));
                entry2.getValue().forEach(o -> message.append("\u3010").append((String)o).append("\u3011").append("<").append((String)fieldmap.get(o)).append(">").append(","));
                message.deleteCharAt(message.lastIndexOf(","));
                HashMap<String, Object> entry = new HashMap<String, Object>(5);
                entry.put(TEMPLATE_ID, ObjectConverterFactory.getString(entry2.getKey()));
                entry.put(TEMPLATE_NUMBER, ((PairTuple)vchmap.get(entry2.getKey())).getKey());
                entry.put(TEMPLATE_NAME, ((PairTuple)vchmap.get(entry2.getKey())).getValue());
                entry.put(MESSAGE, message.toString());
                result.add(entry);
            }
        }
        return result;
    }

    public static void deleteEventBlock(Long preEventClassMasterId, Long eventClassMasterId, String status) {
        if (preEventClassMasterId == null || eventClassMasterId == null || StringUtils.isEmpty((String)status)) {
            return;
        }
        SqlBuilder querySql = new SqlBuilder();
        querySql.append("SELECT DISTINCT eventblock.fid  FROM t_ai_eventblock eventblock", new Object[0]);
        querySql.append("INNER JOIN t_ai_eventclass pre ON pre.fmasterid  =eventblock.feventclass ", new Object[0]);
        querySql.append("INNER JOIN t_ai_event aievent ON aievent.fid =eventblock.feventid ", new Object[0]);
        querySql.append("INNER JOIN t_ai_eventclass eventclass ON eventclass.fid = aievent.feventclass ", new Object[0]);
        querySql.append("WHERE eventblock.ftextfield =? ", new Object[]{status});
        querySql.append("AND pre.fmasterid=?", new Object[]{preEventClassMasterId}).append("AND eventclass.fmasterid =?", new Object[]{eventClassMasterId});
        SqlBuilder deleteSql = new SqlBuilder();
        deleteSql.append("delete from t_ai_eventblock where fid in (", new Object[0]).appendSqlBuilder(querySql).append(")", new Object[0]);
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteSql);
    }

    public static Set<Long> checkDataModelQuote(Object[] ids) {
        HashSet<Long> entryIds = new HashSet<Long>(4);
        for (Object id : ids) {
            DynamicObject dataModel = BusinessDataServiceHelper.loadSingle((String)"fah_ext_datamodel", (String)"id,number,versionnum,status,refdatacnt,enable", (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
            if (dataModel.getInt("versionnum") > 1) {
                QFilter filter = new QFilter("number", "=", (Object)dataModel.getString("number"));
                filter.and(new QFilter("versionnum", "=", (Object)(dataModel.getInt("versionnum") - 1)));
                DynamicObject lastDataModel = BusinessDataServiceHelper.loadSingle((String)"fah_ext_datamodel", (String)"id", (QFilter[])new QFilter[]{filter});
                HashSet<String> lastFieldNumber = new HashSet<String>(10);
                SqlBuilder lastDataSql = new SqlBuilder();
                lastDataSql.append("select fnumber from t_fah_ext_modflds where fmodelid = ?", new Object[]{lastDataModel.getLong("id")});
                try (DataSet lastData = DataModelDaoImpl.executeBatch("checklastDataModelQuote", FAHCommonConstant.AI, lastDataSql);){
                    while (lastData.hasNext()) {
                        lastFieldNumber.add(lastData.next().getString("fnumber"));
                    }
                }
                HashSet<String> selectFieldNumber = new HashSet<String>(10);
                SqlBuilder selectDataSql = new SqlBuilder();
                selectDataSql.append("select fnumber from t_fah_ext_modflds where fmodelid = ?", new Object[]{dataModel.getLong("id")});
                try (DataSet selectData = DataModelDaoImpl.executeBatch("checkSelectDataModelQuote", FAHCommonConstant.AI, selectDataSql);){
                    while (selectData.hasNext()) {
                        Row row = selectData.next();
                        if (lastFieldNumber.contains(row.getString("fnumber"))) continue;
                        selectFieldNumber.add(row.getString("fnumber"));
                    }
                }
                if (selectFieldNumber.size() <= 0) continue;
                SqlBuilder sqlBuilder = new SqlBuilder();
                Long pk = dataModel.getLong("id");
                sqlBuilder.append("select fentryid from t_ai_preevent where fid = ?", new Object[]{pk}).appendIn(" and fevtfield ", selectFieldNumber.toArray());
                sqlBuilder.append(" or fpreeventclass = ?", new Object[]{pk}).appendIn(" and fpreevtfield ", selectFieldNumber.toArray());
                try (DataSet data = DataModelDaoImpl.executeBatch("checkDataModelQuote", FAHCommonConstant.AI, sqlBuilder);){
                    while (data.hasNext()) {
                        Row row = data.next();
                        entryIds.add(row.getLong("fentryid"));
                    }
                    continue;
                }
            }
            SqlBuilder sqlBuilder = new SqlBuilder();
            Long pk = dataModel.getLong("id");
            sqlBuilder.append("select fentryid from t_ai_preevent where fid = ?", new Object[]{pk}).append(" or fpreeventclass = ?", new Object[]{pk});
            try (DataSet data = DataModelDaoImpl.executeBatch("checkDataModelQuote", FAHCommonConstant.AI, sqlBuilder);){
                while (data.hasNext()) {
                    Row row = data.next();
                    entryIds.add(row.getLong("fentryid"));
                }
            }
        }
        return entryIds;
    }

    private static DataSet executeBatch(String algoKey, DBRoute dbRoute, SqlBuilder sb) {
        return DB.queryDataSet((String)algoKey, (DBRoute)dbRoute, (SqlBuilder)sb);
    }

    public static Object[] deleteModel(Object[] ids) {
        HashMap<String, String> errorMap = new HashMap<String, String>();
        HashSet<String> successSet = new HashSet<String>();
        for (Object id : ids) {
            DynamicObject dataModel = BusinessDataServiceHelper.loadSingle((String)"fah_ext_datamodel", (String)"id,number,versionnum,status,refdatacnt,enable", (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
            if (dataModel == null) continue;
            String lockKey = DataModelDaoImpl.getLockKey(dataModel.getString("number"));
            try (DLock lock = DLock.create((String)lockKey).fastMode();){
                if (lock.tryLock()) {
                    try (TXHandle handle = TX.requiresNew((String)"DataModelDaoImpl.delete");){
                        try {
                            if (dataModel.getString("enable").equals("1")) {
                                errorMap.put(dataModel.getString("number"), ResManager.loadKDString((String)"\u6a21\u578b\u542f\u7528\u4e2d\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DataModelDaoImpl_4", (String)"fi-ai-common", (Object[])new Object[0]));
                                continue;
                            }
                            if (DataModelDaoImpl.getEventRecordCounts(Long.parseLong(id.toString())) != 0) {
                                errorMap.put(dataModel.getString("number"), ResManager.loadKDString((String)"\u8be5\u5916\u90e8\u6570\u636e\u6a21\u578b\u5b58\u5728\u5f15\u7528\u7684\u5916\u90e8\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"DataModelDaoImpl_5", (String)"fi-ai-common", (Object[])new Object[0]));
                                continue;
                            }
                            String number = dataModel.getString("number");
                            if (dataModel.getInt("versionnum") > 1) {
                                DynamicObject updateModel = DataModelDaoImpl.getLastPublishModel(number, dataModel.getInt("versionnum"));
                                if (null != updateModel) {
                                    LinkedList<String> checkFields = new LinkedList<String>();
                                    DataModelCfg needDeleteDataModel = DataModelDaoImpl.generateDeleteDataModel(updateModel, dataModel, checkFields);
                                    DataModelDiff dataModelDiff = new DataModelDiff();
                                    dataModelDiff.setModelId(dataModel.getLong("id"));
                                    dataModelDiff.setDeletedCfgs(needDeleteDataModel);
                                    DynamicFormConfig latestConfig = DynamicFormConfigBuilder.createDynamicFormConfig(dataModel.getLong("id"), FormBuilderConstant.BIZ_APP_ID, true, false);
                                    DataModelDaoImpl.createBillFormModel(updateModel.getLong("id"), dataModelDiff, latestConfig);
                                }
                                QFilter filter = new QFilter("number", "=", (Object)number);
                                filter.and(new QFilter("latestversion", "=", (Object)"1"));
                                DynamicObjectCollection deleteDataModel = QueryServiceHelper.query((String)"fah_ext_datamodel", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"versionnum desc");
                                if (deleteDataModel != null && !deleteDataModel.isEmpty()) {
                                    for (int i = 0; i < deleteDataModel.size(); ++i) {
                                        DeleteServiceHelper.delete((String)"fah_ext_model_fldgrp", (QFilter[])new QFilter("model.id", "=", ((DynamicObject)deleteDataModel.get(i)).get("id")).toArray());
                                        DeleteServiceHelper.delete((String)"fah_ext_dataentry", (QFilter[])new QFilter("model.id", "=", ((DynamicObject)deleteDataModel.get(i)).get("id")).toArray());
                                        DeleteServiceHelper.delete((String)"fah_ext_datamodel", (QFilter[])new QFilter("id", "=", ((DynamicObject)deleteDataModel.get(i)).get("id")).toArray());
                                    }
                                }
                                if (updateModel != null) {
                                    updateModel.set("latestversion", (Object)"1");
                                    updateModel.set("enable", (Object)"1");
                                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{updateModel});
                                }
                                cacheService.reloadCache(number, new Object[0]);
                            } else {
                                cacheService.removeFromCache(cacheService.buildCacheTypeKey(number, new Object[0]));
                                DataModelDaoImpl.delDynamicForm(number);
                                DeleteServiceHelper.delete((String)"fah_ext_model_fldgrp", (QFilter[])new QFilter("model.number", "=", (Object)number).toArray());
                                DeleteServiceHelper.delete((String)"fah_ext_dataentry", (QFilter[])new QFilter("model.number", "=", (Object)number).toArray());
                                DeleteServiceHelper.delete((String)"fah_ext_datamodel", (QFilter[])new QFilter("number", "=", (Object)number).toArray());
                            }
                            successSet.add(dataModel.getString("number"));
                            continue;
                        }
                        catch (Exception e) {
                            handle.markRollback();
                            throw e;
                        }
                    }
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5e03\u5f0f\u4e8b\u52a1\u9501\u52a0\u9501\u5931\u8d25\u3002", (String)"DataModelDaoImpl_3", (String)"fi-ai-common", (Object[])new Object[0]));
            }
        }
        Object[] messge = new Object[]{successSet, errorMap};
        return messge;
    }

    public static DynamicObject getLastPublishModel(String number, int versionnum) {
        if (versionnum == 1) {
            return null;
        }
        QFilter qfilter = new QFilter("number", "=", (Object)number);
        qfilter.and("versionnum", "=", (Object)(versionnum - 1));
        qfilter.and("status", "=", (Object)"C");
        return BusinessDataServiceHelper.loadSingle((String)"fah_ext_datamodel", (QFilter[])new QFilter[]{qfilter});
    }

    public static Map<Long, Set<String>> getCheckVchTemplateRefessrence(Object id) {
        Map<Long, Set<String>> map;
        LinkedList<String> checkFields = new LinkedList<String>();
        DynamicObject needDeleteModel = DataModelDaoImpl.loadSingleDataModelById((Long)id);
        String modelNumber = needDeleteModel.getString("number");
        DynamicObject latestModel = DataModelDaoImpl.getLastPublishModel(modelNumber, needDeleteModel.getInt("versionnum"));
        if (latestModel == null) {
            DynamicObjectCollection fields = QueryServiceHelper.query((String)"fah_ext_dataentry", (String)"model.number modelumber,number", (QFilter[])new QFilter[]{new QFilter("model.id", "=", id)});
            if (fields == null || fields.isEmpty()) {
                return null;
            }
            for (DynamicObject field : fields) {
                checkFields.add(field.getString("number"));
            }
        } else {
            DataModelDaoImpl.generateDeleteDataModel(needDeleteModel, latestModel, checkFields);
            DataModelDaoImpl.generateModifiedDataModel(needDeleteModel, latestModel, checkFields);
        }
        if (!checkFields.isEmpty() && !(map = VchTemplateRefValidator.checkVchTemplateRefessrence(DataModelDaoImpl.getMetaEntityNumber(modelNumber), checkFields)).isEmpty()) {
            return map;
        }
        return null;
    }

    public static DynamicObject[] getModelRelations(Long modelMasterId) {
        return BusinessDataServiceHelper.load((String)"fah_ext_datamodel_rat", (String)"predatamodel,predatafield,prestatus,datafield", (QFilter[])new QFilter[]{new QFilter("datamodel", "=", (Object)modelMasterId)});
    }

    public static DynamicObject[] getModelRelationsAsPreModel(Long modelMasterId) {
        return BusinessDataServiceHelper.load((String)"fah_ext_datamodel_rat", (String)"predatamodel,predatafield,prestatus,datafield", (QFilter[])new QFilter[]{new QFilter("predatamodel", "=", (Object)modelMasterId)});
    }

    public static DataSet checkRelation(String algoKey, SqlBuilder checkSql) {
        return DB.queryDataSet((String)algoKey, (DBRoute)FAHCommonConstant.AI, (SqlBuilder)checkSql);
    }
}

