/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.event;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.models.MappingValueTypeOrg;
import kd.fi.v2.fah.utils.StringUtils;

public class FahBizDimComDao {
    public DynamicObjectCollection queryGroupData(Long pkId) {
        return QueryServiceHelper.query((String)"fah_biz_dimgroup", (String)"id,dimgrpid,fSeq,name,number", (QFilter[])new QFilter[]{new QFilter("dimgrpid", "=", (Object)pkId)}, (String)"fSeq");
    }

    public void deleteHistoryGroupData(Long dimGrpId) {
        DeleteServiceHelper.delete((String)"fah_biz_dimgroup", (QFilter[])new QFilter[]{new QFilter("dimgrpid", "=", (Object)dimGrpId)});
    }

    public boolean deleteGroupDataByDimGrpId(Set<Long> set) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("delete from t_fah_valmap_type_org where fmaptypeid in (select fid from t_fah_dimgrp_type_cust where ", new Object[0]);
        sb.appendIn("fdimgrptypeid", new ArrayList<Long>(set));
        sb.append(" and ftargetbaseprop = ? )", new Object[]{"fah_biz_dim_combine"});
        return DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)sb);
    }

    public List<Long> getEventLineList() {
        LinkedList<Long> eventLineList = new LinkedList<Long>();
        SqlBuilder sb = new SqlBuilder();
        sb.append("select distinct fbasedataid from t_fah_dimgrp_type_evtlnk", new Object[0]);
        try (DataSet dataset = DB.queryDataSet((String)FahBizDimComDao.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sb);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                eventLineList.add(row.getLong("fbasedataid"));
            }
        }
        return eventLineList;
    }

    public DynamicObjectCollection queryEntryData(Long pkId) {
        return QueryServiceHelper.query((String)"fah_biz_dimgrp_en", (String)"fid,fSeq,fBizDimTypeId,fbizdimtypenum,fIsEnabled,fIsRequired,fCustGrpID,fDimInnerId,fissysreserved", (QFilter[])new QFilter[]{new QFilter("fid", "=", (Object)pkId), new QFilter("fcustgrpid", "=", (Object)0L)}, (String)"fSeq");
    }

    public DynamicObjectCollection queryEntryGroupData(Long pkId, List<Long> custGrpIds) {
        return QueryServiceHelper.query((String)"fah_biz_dimgrp_en", (String)"fid,fSeq,fBizDimTypeId,fbizdimtypenum,fIsEnabled,fIsRequired,fCustGrpID,fDimInnerId,fissysreserved", (QFilter[])new QFilter[]{new QFilter("fid", "=", (Object)pkId), new QFilter("fcustgrpid", "in", custGrpIds)}, (String)"fSeq");
    }

    public boolean queryExistsAstType(Long bizDimTypeId) {
        return QueryServiceHelper.exists((String)"fah_biz_dimgrp_en", (QFilter[])new QFilter[]{new QFilter("fBizDimTypeId", "=", (Object)bizDimTypeId)});
    }

    public void deleteHistoryEntryData(Long pkId) {
        DeleteServiceHelper.delete((String)"fah_biz_dimgrp_en", (QFilter[])new QFilter[]{new QFilter("fid", "=", (Object)pkId)});
    }

    public String[] getGroupName(Long orgId, Long dimGrpId) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("select fid, fname from t_fah_dimgrp_type_cust where fid in (select fmaptypeid from t_fah_valmap_type_org where fownorgid = ?", new Object[]{orgId});
        sb.append(" and ftargetbaseprop = ?)", new Object[]{"fah_biz_dim_combine"});
        sb.append(" and fdimgrptypeid = ?", new Object[]{dimGrpId});
        String[] groupNames = new String[2];
        try (DataSet dataset = DB.queryDataSet((String)FahBizDimComDao.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sb);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                groupNames[0] = String.valueOf(row.getLong("fid"));
                groupNames[1] = row.getString("fname");
            }
        }
        return groupNames;
    }

    public void saveEntry(List<DynamicObject> data) {
        SaveServiceHelper.save((DynamicObject[])data.toArray(new DynamicObject[0]));
    }

    public void saveValMapOrg(List<MappingValueTypeOrg> orgList, Long typeId, String baseProp) {
        DeleteServiceHelper.delete((String)"fah_valmap_type_org", (QFilter[])new QFilter[]{new QFilter("maptype", "=", (Object)typeId)});
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(orgList.size());
        for (MappingValueTypeOrg org : orgList) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"fah_valmap_type_org");
            obj.set("maptype", (Object)typeId);
            obj.set("ownorg", org.getId());
            obj.set("orgtype", (Object)org.getOrgtype());
            obj.set("description", (Object)org.getDescription());
            obj.set("iscustom", (Object)org.isCustom());
            if (StringUtils.isNotEmpty((String)baseProp)) {
                obj.set("targetbaseprop", (Object)baseProp);
            }
            saveList.add(obj);
        }
        SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
    }

    public List<String[]> getQuoteEventRuleValueByMasterId(Long dimInnerId) {
        LinkedList<String[]> list = new LinkedList<String[]>();
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"fah_evt_gen_rule", (String)"name,number", (QFilter[])new QFilter[]{new QFilter("evtrule_line.dimextract.diminnerid", "=", (Object)dimInnerId)});
        for (DynamicObject data : datas) {
            String[] value = new String[]{data.getString("number"), data.getString("name")};
            list.add(value);
        }
        return list;
    }

    public List<String[]> getQuoteEventRuleValueByLineTypeId(Long bizDimId, List<Long> lineTypeIds) {
        LinkedList<String[]> list = new LinkedList<String[]>();
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"fah_evt_gen_rule", (String)"name,number,evtrule_line.entry_linetype.number,evtrule_line.entry_linetype.name", (QFilter[])new QFilter[]{new QFilter("evtrule_line.bizdim", "=", (Object)bizDimId), new QFilter("evtrule_line.entry_linetype", "in", lineTypeIds)});
        for (DynamicObject data : datas) {
            String[] value = new String[]{data.getString("number"), data.getString("name"), data.getString("evtrule_line.entry_linetype.number"), data.getString("evtrule_line.entry_linetype.name")};
            list.add(value);
        }
        return list;
    }

    public List<String[]> getQuoteEventRuleValueById(Long bizDimId) {
        LinkedList<String[]> list = new LinkedList<String[]>();
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"fah_evt_gen_rule", (String)"name,number", (QFilter[])new QFilter[]{new QFilter("evtrule_line.bizdim", "=", (Object)bizDimId)});
        for (DynamicObject data : datas) {
            String[] value = new String[]{data.getString("number"), data.getString("name")};
            list.add(value);
        }
        return list;
    }

    public List<String[]> getQuoteEventRuleByEvtLineId(List<Object> evtLineIds) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("select distinct t.fnumber,t.fname from t_fah_evt_gen_rule t join t_fah_evtline_gen_rule a on t.fid = a.fid ", new Object[0]);
        sb.appendIn("and a.fevtlinetypeid ", evtLineIds);
        sb.append(" and a.fdimgrptypeid = 0", new Object[0]);
        LinkedList<String[]> list = new LinkedList<String[]>();
        try (DataSet dataset = DB.queryDataSet((String)FahBizDimComDao.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sb);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                String[] value = new String[]{row.getString("fnumber"), row.getString("fname")};
                list.add(value);
            }
        }
        return list;
    }
}

