/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.sys;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.AssistantDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.v2.fah.constant.MasterDataGroupTypeEnum;
import kd.fi.v2.fah.constant.SysParamConfigKey;

public class SysBasePropDataDaoImpl {
    private static final String AssistantData_SelectField = "group, id, number, group.number";
    private static final String AccountView_SelectField = "accounttable.id, id, number";

    public static DynamicObjectCollection queryBaseData(String entityName, Long orgId, String selectFields, QFilter ... filter) {
        return BaseDataServiceHelper.queryBaseData((String)entityName, (Long)orgId, (QFilter)(filter == null ? null : QFilterBuilder.create((QFilter[])filter).buildSingleFilter()), (String)selectFields);
    }

    public static int queryBaseData(String entityName, Long orgId, String selectFields, Consumer<Map<String, Object>> dataConsumer, QFilter ... filter) {
        DynamicObjectCollection res = SysBasePropDataDaoImpl.queryBaseData(entityName, orgId, selectFields, filter);
        int cnt = 0;
        if (res != null && !res.isEmpty()) {
            for (DynamicObject dyn : res) {
                if (dyn == null) continue;
                dataConsumer.accept(SysBasePropDataDaoImpl.dumpDynamicObject(dyn));
                ++cnt;
            }
        }
        return cnt;
    }

    public static int queryBaseDataPkAndNumber(String entityName, Long orgId, Consumer<Map<String, Object>> dataConsumer, QFilter ... filter) {
        String pkName = EntityMetadataCache.getDataEntityType((String)entityName).getPrimaryKey().getName();
        String selectFields = pkName + " id, number";
        return SysBasePropDataDaoImpl.queryBaseData(entityName, orgId, selectFields, dataConsumer, filter);
    }

    public static int queryAssistantPkAndNumber(Consumer<Map<String, Object>> dataConsumer, QFilter ... filter) {
        return SysBasePropDataDaoImpl.queryBaseData(MasterDataGroupTypeEnum.Assist_Prop.getDefaultEntityName(), null, AssistantData_SelectField, dataConsumer, filter);
    }

    public static int queryAccountPkAndNumber(Long orgId, Consumer<Map<String, Object>> dataConsumer, QFilter ... filter) {
        return SysBasePropDataDaoImpl.queryBaseData(MasterDataGroupTypeEnum.GL_Account.getDefaultEntityName(), orgId, AccountView_SelectField, dataConsumer, filter);
    }

    public static Map<Object, DynamicObject> queryBaseDataMap(String entityName, Long orgId, String selectFields, QFilter ... filter) {
        DynamicObject[] res = SysBasePropDataDaoImpl.queryBaseDataObjects(entityName, orgId, selectFields, filter);
        if (res == null || res.length == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Object, DynamicObject> resultMap = new HashMap<Object, DynamicObject>(res.length);
        for (DynamicObject dyn : res) {
            if (dyn == null) continue;
            resultMap.put(dyn.getPkValue(), dyn);
        }
        return resultMap;
    }

    public static DynamicObject[] queryBaseDataObjects(String entityName, Long orgId, String selectFields, QFilter ... filter) {
        String pkName = EntityMetadataCache.getDataEntityType((String)entityName).getPrimaryKey().getName();
        LinkedList ids = new LinkedList();
        SysBasePropDataDaoImpl.queryBaseData(entityName, orgId, pkName, (Consumer<Map<String, Object>>)((Consumer)valMap -> ids.add(valMap.get(pkName))), filter == null ? null : QFilterBuilder.create((QFilter[])filter).buildSingleFilter());
        if (!ids.isEmpty()) {
            return BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{new QFilter(pkName, "in", ids)});
        }
        return new DynamicObject[0];
    }

    public static Map<String, Object> dumpDynamicObject(DynamicObject srcDyn) {
        if (srcDyn == null || srcDyn.getDataEntityType() == null || srcDyn.getDataEntityType().getProperties().isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> rowData = new LinkedHashMap<String, Object>(srcDyn.getDataEntityType().getProperties().size());
        for (IDataEntityProperty prop : srcDyn.getDataEntityType().getProperties()) {
            Object valBuf = prop.getValueFast((Object)srcDyn);
            if (valBuf == null) continue;
            String key = prop.getName();
            if (DynamicObject.class.isAssignableFrom(prop.getPropertyType())) {
                rowData.put(key, SysBasePropDataDaoImpl.dumpDynamicObject((DynamicObject)valBuf));
                continue;
            }
            rowData.put(key, valBuf);
        }
        return rowData;
    }

    public static QFilter getBaseDataFilter(String entityID, Long orgID) {
        return BaseDataServiceHelper.getBaseDataFilter((String)entityID, (Long)orgID);
    }

    public static QFilter getAssistantDataFilter(Long typeId, Long orgId) {
        DynamicObject group = QueryServiceHelper.queryOne((String)"bos_assistantdatagroup", (String)"createorg.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)typeId)});
        if (null == group) {
            return new QFilter("1", "=", (Object)0);
        }
        Long groupCreateOrgId = group.getLong("createorg.id");
        String ctrlStrategy = AssistantDataServiceHelper.getAssistantDataCtrlstrategy((Long)typeId);
        String viewNumber = AssistantDataServiceHelper.getAssistantDataCtrlView((Long)typeId);
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        List superiorIds = orgService.getAllSuperiorOrgs(viewNumber, orgId.longValue());
        if (!Objects.equals(orgId, groupCreateOrgId) && !superiorIds.contains(groupCreateOrgId)) {
            return new QFilter("1", "=", (Object)0);
        }
        switch (ctrlStrategy) {
            case "5": {
                return new QFilter("ctrlstrategy", "=", (Object)"5");
            }
            case "7": {
                return new QFilter("createorg.id", "=", (Object)orgId);
            }
        }
        superiorIds.add(orgId);
        return new QFilter("createorg.id", "in", (Object)superiorIds);
    }

    public static QFilter getBaseDataFilter(String entityID, List<Long> orgIdList) {
        return BaseDataServiceHelper.getBaseDataFilter((String)entityID, orgIdList, (boolean)true);
    }

    public static DynamicObjectCollection queryOrgUnit(String entityName, Long orgId, String select, QFilter filter) {
        long orgDutyType;
        if (!"bos_org".equalsIgnoreCase(entityName) && !"bos_adminorg".equalsIgnoreCase(entityName)) {
            return new DynamicObjectCollection();
        }
        long l = orgDutyType = "bos_org".equalsIgnoreCase(entityName) ? 15L : 1L;
        if (Boolean.parseBoolean(SysParamConfig.get(SysParamConfigKey.ORG_UNIT_QUERY_BY_BOS, "true"))) {
            DynamicObjectCollection orgIdNumbers = SysBasePropDataDaoImpl.queryBaseData(entityName, orgId, select, filter);
            if (CollectionUtils.isEmpty((Collection)orgIdNumbers)) {
                return orgIdNumbers;
            }
            DynamicObjectCollection filterOrgDutyRes = new DynamicObjectCollection();
            List orgIds = orgIdNumbers.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            List<String> orgViewNumberList = SysBasePropDataDaoImpl.getOrgViewNumberList(orgDutyType);
            for (String orgViewNumber : orgViewNumberList) {
                List filteredOrgIds = OrgUnitServiceHelper.filterOrgDuty(orgIds, (String)orgViewNumber);
                if (!CollectionUtils.isNotEmpty((Collection)filteredOrgIds)) continue;
                HashSet orgIdSet = new HashSet(filteredOrgIds);
                for (DynamicObject orgIdNumDyn : orgIdNumbers) {
                    if (!orgIdSet.contains(orgIdNumDyn.getLong("id"))) continue;
                    filterOrgDutyRes.add((Object)orgIdNumDyn);
                }
            }
            return filterOrgDutyRes;
        }
        filter.and("structure.view.treetypeid", "=", (Object)orgDutyType);
        return SysBasePropDataDaoImpl.queryBaseData(entityName, orgId, select, filter);
    }

    private static List<String> getOrgViewNumberList(long orgDutyType) {
        return (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)"select fnumber from t_org_viewschema where ftreetypeid = ? ", (Object[])new Object[]{orgDutyType}, resultSet -> {
            LinkedList<String> orgViewNumberList = new LinkedList<String>();
            while (resultSet.next()) {
                orgViewNumberList.add(resultSet.getString("fnumber"));
            }
            return orgViewNumberList;
        });
    }
}

