/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.engine.compiler.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kd.fi.v2.fah.engine.compiler.IUnitCfgModelConvertor;
import kd.fi.v2.fah.engine.compiler.impl.HierarchyModelConvertResult;
import kd.fi.v2.fah.engine.config.IProcessorConfigContext;
import kd.fi.v2.fah.engine.config.common.ProcessorCfgModelKey;
import kd.fi.v2.fah.engine.config.impl.ConstantValueUnitCfgModel;
import kd.fi.v2.fah.engine.config.impl.DataQueryUnitCfgModel;
import kd.fi.v2.fah.engine.config.impl.FunctionCalcUnitCfgModel;
import kd.fi.v2.fah.engine.config.impl.MappingConvertUnitCfgModel;
import kd.fi.v2.fah.engine.config.impl.MappingGrpCfgModel;
import kd.fi.v2.fah.engine.config.impl.MathCalcUnitCfgModel;
import kd.fi.v2.fah.models.dynvalfields.AbstractDynValFieldGetValueCfg;
import kd.fi.v2.fah.models.dynvalfields.DynValFieldGetBillFieldValueCfg;
import kd.fi.v2.fah.models.dynvalfields.DynValFieldGetExpressionValueCfg;
import kd.fi.v2.fah.models.dynvalfields.DynValFieldGetFixValueCfg;
import kd.fi.v2.fah.models.dynvalfields.DynValFieldGetFuncValueCfg;
import kd.fi.v2.fah.models.dynvalfields.DynValFieldGetMappingValueCfg;
import kd.fi.v2.fah.models.dynvalfields.DynValFieldGetValueCfgBranchGrp;
import kd.fi.v2.fah.models.dynvalfields.DynValFieldMappingCfgGrp;
import kd.fi.v2.fah.models.dynvalfields.DynValFieldPageFunctionCfg;
import kd.fi.v2.fah.models.modeling.base.AbstractBasePropModelCfg;
import kd.fi.v2.fah.models.table.meta.impl.SimpleTableFieldMeta;

public class DynValFieldToUnitCfgModelConvertor
implements IUnitCfgModelConvertor<DynValFieldGetValueCfgBranchGrp> {
    @Override
    public HierarchyModelConvertResult doCompileConvertor(DynValFieldGetValueCfgBranchGrp srcModel, Object ... params) {
        if (srcModel == null || srcModel.isEmpty()) {
            return null;
        }
        return null;
    }

    public static <T extends IProcessorConfigContext> List<T> convert(AbstractDynValFieldGetValueCfg srcModel, List<String> msgOutput) {
        List<IProcessorConfigContext> result;
        switch (srcModel.getExtractValueType()) {
            case CONSTANT_VALUE: {
                result = Collections.singletonList((IProcessorConfigContext)((Object)DynValFieldToUnitCfgModelConvertor.convertConstantValue((DynValFieldGetFixValueCfg)srcModel, msgOutput)));
                break;
            }
            case SOURCE_FIELD: {
                throw new UnsupportedOperationException("Use convertGetBillFieldValue method instead!");
            }
            case MAPPING: {
                if (srcModel instanceof DynValFieldMappingCfgGrp) {
                    result = Collections.singletonList(DynValFieldToUnitCfgModelConvertor.convertMappingCfgGrp((DynValFieldMappingCfgGrp)srcModel, msgOutput));
                    break;
                }
                result = Collections.singletonList(DynValFieldToUnitCfgModelConvertor.convertGetMappingValue((DynValFieldGetMappingValueCfg)srcModel, msgOutput));
                break;
            }
            case FUNCTION: {
                result = Collections.singletonList(DynValFieldToUnitCfgModelConvertor.convertFunctionValue((DynValFieldGetFuncValueCfg)srcModel, msgOutput));
                break;
            }
            case EXPRESSION: {
                result = Collections.singletonList(DynValFieldToUnitCfgModelConvertor.convertExpressionValue((DynValFieldGetExpressionValueCfg)srcModel, msgOutput));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown ExtractValueType=%s, from Model=%s", new Object[]{srcModel.getExtractValueType(), srcModel}));
            }
        }
        if (result != null) {
            int level = srcModel.getCompiler_temp_Level();
            int seqNo = srcModel.getCompiler_temp_SeqNo();
            result.forEach(v -> v.setCfgModelKey(new ProcessorCfgModelKey(level, seqNo)));
        }
        return result;
    }

    public static Collection<SimpleTableFieldMeta> parseCfgModelDependedParams(AbstractDynValFieldGetValueCfg<?> srcCfgModel) {
        if (srcCfgModel == null || !srcCfgModel.hasDependedFields()) {
            return null;
        }
        ArrayList<SimpleTableFieldMeta> dependedParams = new ArrayList<SimpleTableFieldMeta>(srcCfgModel.getDependedFields().size());
        for (AbstractDynValFieldGetValueCfg dependedCfg : srcCfgModel.getDependedFields()) {
            SimpleTableFieldMeta fieldMeta = new SimpleTableFieldMeta(String.valueOf(dependedCfg.getItemKey()), dependedCfg.getOutputDataType());
            int fieldSeq = dependedCfg.getCompiler_temp_SeqNo();
            fieldMeta.setSeq(fieldSeq);
            fieldMeta.setReadPos(fieldSeq);
            fieldMeta.setWritePos(fieldSeq);
            dependedParams.add(fieldMeta);
        }
        return dependedParams;
    }

    public static ConstantValueUnitCfgModel convertConstantValue(DynValFieldGetFixValueCfg srcModel, List<String> msgOutput) {
        if (srcModel == null) {
            return null;
        }
        DynValFieldPageFunctionCfg fieldPageFunctionCfg = srcModel.getDynFieldPageCfg();
        String fieldNum = fieldPageFunctionCfg != null ? fieldPageFunctionCfg.getSourceField() : srcModel.getNumber();
        SimpleTableFieldMeta fieldMeta = new SimpleTableFieldMeta(fieldNum, srcModel.getOutputDataType());
        ConstantValueUnitCfgModel result = new ConstantValueUnitCfgModel(srcModel.getOutputDataType(), srcModel.getFixValue(), fieldMeta);
        return result;
    }

    public static DataQueryUnitCfgModel convertGetBillFieldValue(Collection<DynValFieldGetBillFieldValueCfg> srcModels, List<String> msgOutput) {
        if (srcModels == null) {
            return null;
        }
        DataQueryUnitCfgModel result = new DataQueryUnitCfgModel();
        if (!srcModels.isEmpty()) {
            String queryBillType = null;
            ArrayList<SimpleTableFieldMeta> fields = new ArrayList<SimpleTableFieldMeta>(srcModels.size());
            int i = 0;
            for (DynValFieldGetBillFieldValueCfg cfg : srcModels) {
                if (cfg.getSrcBillType() == null) {
                    msgOutput.add("SrcBillType Cannot be null on cfg=" + cfg);
                    continue;
                }
                String srcBillType = cfg.getSrcBillType().trim();
                if (queryBillType == null) {
                    queryBillType = srcBillType;
                } else if (!queryBillType.equalsIgnoreCase(srcBillType)) {
                    msgOutput.add(String.format("Found multiple source bill type:[%s] vs [%s]", queryBillType, srcBillType));
                    continue;
                }
                SimpleTableFieldMeta fieldMetaBuf = new SimpleTableFieldMeta(cfg.getSrcField(), cfg.getOutputDataType());
                fieldMetaBuf.setDbFieldNum(cfg.getSrcField());
                fieldMetaBuf.setAccessPosIdx(new int[]{i, i});
                fieldMetaBuf.setSeq(i++);
                fields.add(fieldMetaBuf);
            }
            result.addAll(fields);
            result.setQueryTarget(queryBillType);
        }
        return result;
    }

    protected static SimpleTableFieldMeta parseSingleOutputField(AbstractDynValFieldGetValueCfg<?> srcCfgModel) {
        SimpleTableFieldMeta outputField = new SimpleTableFieldMeta(srcCfgModel.getNumber(), srcCfgModel.getOutputDataType());
        outputField.setDbFieldNum(srcCfgModel.getNumber());
        outputField.setAccessPosIdx(new int[]{srcCfgModel.getCompiler_temp_SeqNo(), srcCfgModel.getCompiler_temp_SeqNo()});
        outputField.setSeq(srcCfgModel.getCompiler_temp_SeqNo());
        DynValFieldToUnitCfgModelConvertor.copyCommonProps(srcCfgModel, outputField);
        return outputField;
    }

    private static void copyCommonProps(AbstractBasePropModelCfg src, AbstractBasePropModelCfg target) {
        target.setId(src.getId());
        target.setNumber(src.getNumber());
        target.setName(src.getName());
    }

    public static MappingConvertUnitCfgModel convertGetMappingValue(DynValFieldGetMappingValueCfg srcModel, List<String> msgOutput) {
        if (srcModel == null) {
            return null;
        }
        MappingConvertUnitCfgModel result = new MappingConvertUnitCfgModel();
        DynValFieldToUnitCfgModelConvertor.copyCommonProps(srcModel, result);
        result.setMappingType(srcModel.getMappingType());
        result.setMappingRuleId(srcModel.getMappingRuleId());
        result.setInputFields(DynValFieldToUnitCfgModelConvertor.parseCfgModelDependedParams(srcModel));
        result.setOutputField(DynValFieldToUnitCfgModelConvertor.parseSingleOutputField(srcModel));
        return result;
    }

    public static MappingGrpCfgModel convertMappingCfgGrp(DynValFieldMappingCfgGrp srcModel, List<String> msgOutput) {
        if (srcModel == null) {
            return null;
        }
        MappingGrpCfgModel result = new MappingGrpCfgModel();
        DynValFieldToUnitCfgModelConvertor.copyCommonProps(srcModel, result);
        result.setMappingType(srcModel.getMappingType());
        result.setMappingGrpId((Long)srcModel.getCfgValue());
        for (AbstractDynValFieldGetValueCfg srcMapCfg : srcModel.getDependedFields()) {
            DynValFieldGetMappingValueCfg mapCfg = (DynValFieldGetMappingValueCfg)srcMapCfg;
            if (mapCfg == null) continue;
            int cfgIndex = result.addEx(DynValFieldToUnitCfgModelConvertor.convertGetMappingValue(mapCfg, msgOutput));
            if (cfgIndex < 0) {
                throw new IllegalArgumentException("Error on Add Convert DynValFieldGetMappingValueCfg: " + srcMapCfg);
            }
            result.addMappingEnableOrgIndex(mapCfg.getEnabledOrgIds(), cfgIndex);
        }
        return result;
    }

    public static FunctionCalcUnitCfgModel convertFunctionValue(DynValFieldGetFuncValueCfg srcModel, List<String> msgOutput) {
        if (srcModel == null) {
            return null;
        }
        FunctionCalcUnitCfgModel result = new FunctionCalcUnitCfgModel();
        result.setFunctionName((String)srcModel.getCfgValue());
        result.setResultDataType(srcModel.getOutputDataType());
        result.setOutputFields(DynValFieldToUnitCfgModelConvertor.parseSingleOutputField(srcModel));
        result.batchAdd(DynValFieldToUnitCfgModelConvertor.parseCfgModelDependedParams(srcModel));
        return result;
    }

    public static MathCalcUnitCfgModel convertExpressionValue(DynValFieldGetExpressionValueCfg srcModel, List<String> msgOutput) {
        MathCalcUnitCfgModel result = new MathCalcUnitCfgModel();
        result.setResultDataType(srcModel.getOutputDataType());
        result.setOutputFields(DynValFieldToUnitCfgModelConvertor.parseSingleOutputField(srcModel));
        return result;
    }
}

