/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.engine.config.impl;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import kd.fi.v2.fah.engine.config.common.AbstractFieldDependedCfgModel;
import kd.fi.v2.fah.engine.config.impl.ConstantValueUnitCfgModel;
import kd.fi.v2.fah.engine.enums.DataProcessorClassTypeEnum;
import kd.fi.v2.fah.engine.processor.ISQLQueryConfigContext;
import kd.fi.v2.fah.models.table.meta.impl.SimpleTableFieldMeta;
import kd.fi.v2.fah.sqlbuilder.filter.SimpleQFilter;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.utils.StringUtils;

public class DataQueryUnitCfgModel
extends AbstractFieldDependedCfgModel
implements ISQLQueryConfigContext {
    protected boolean sqlQueryType;
    protected transient String algoQueryName;
    protected String queryTarget;
    protected ConstantValueUnitCfgModel[] constantValues;
    protected transient List<String> queryTargetEntryNames;
    protected transient String queryString;
    protected String orderBy;
    protected SimpleQFilter[] baseFilters;
    protected int pageSize;
    protected int rowOffSet;
    protected int fetchBatchSize = 5000;

    public DataQueryUnitCfgModel() {
        this.sqlQueryType = true;
        this.pageSize = -1;
        this.rowOffSet = 0;
    }

    public DataQueryUnitCfgModel(String queryTarget, String orderBy, SimpleQFilter[] baseFilters, int pageSize, int rowOffSet) {
        this.queryTarget = queryTarget;
        this.orderBy = orderBy;
        this.baseFilters = baseFilters;
        this.pageSize = pageSize;
        this.rowOffSet = rowOffSet;
    }

    public DataQueryUnitCfgModel(int runLevel, Integer cfgModelSeqKey) {
        super(runLevel, cfgModelSeqKey);
    }

    @Override
    public DataProcessorClassTypeEnum getProcessorClassType() {
        return DataProcessorClassTypeEnum.SQL_Query;
    }

    @Override
    public Collection<String> doValidate() {
        LinkedList<String> error = new LinkedList<String>();
        if (StringUtils.isEmpty((String)this.queryTarget)) {
            error.add("Query Target is null");
        }
        if (StringUtils.isEmpty((String)this.queryString)) {
            error.add("Query Select Fields is null");
        }
        return error;
    }

    @Override
    public Object[] getTemplateRow() {
        if (this.constantValues == null || this.constantValues.length == 0) {
            return new Object[this.getQueryColumnCnt()];
        }
        Object[] resultRow = new Object[this.getTemplateRowColumnCnt()];
        for (ConstantValueUnitCfgModel fixValue : this.constantValues) {
            SimpleTableFieldMeta field = fixValue.getOutputFields();
            if (field == null || field.getWritePos() < 0) continue;
            resultRow[field.getWritePos()] = fixValue.getConstantValue();
        }
        return resultRow;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String rebuildQueryString() {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        LinkedList<String> entryNames = new LinkedList<String>();
        for (SimpleTableFieldMeta fieldMeta : (BaseMutableArrayMapStorage)this.collections) {
            if (fieldMeta == null || fieldMeta.getDbFieldNum() == null) continue;
            if (first) {
                first = false;
            } else {
                buf.append(",");
            }
            String fieldNumBuf = fieldMeta.getDbFieldNum();
            buf.append(fieldNumBuf);
            if (fieldNumBuf.contains(".")) {
                entryNames.add(fieldNumBuf.substring(0, fieldNumBuf.lastIndexOf(".")));
            }
            this.queryTargetEntryNames = new ArrayList<String>(new LinkedHashSet(entryNames));
        }
        this.queryString = buf.toString();
        return this.queryString;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public String getAlgoQueryName() {
        if (this.algoQueryName == null) {
            this.algoQueryName = "fi/fah/SQLQueryProcessorUnit/" + this.queryTarget;
        }
        return this.algoQueryName;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public List<String> getQueryTargetEntryNames() {
        return this.queryTargetEntryNames;
    }

    @Override
    public boolean includeHeaderTableFields() {
        return false;
    }

    @Override
    public int getQueryColumnCnt() {
        return this.collections != null ? ((BaseMutableArrayMapStorage)this.collections).size() : 0;
    }

    @Override
    public int getConstantValueCnt() {
        return this.constantValues == null ? 0 : this.constantValues.length;
    }

    @Override
    public String getQueryTarget() {
        return this.queryTarget;
    }

    public void setQueryTarget(String queryTarget) {
        this.queryTarget = queryTarget;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public String getSelectFieldString() {
        if (this.collections == null) {
            return null;
        }
        return this.queryString == null ? this.rebuildQueryString() : this.queryString;
    }

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    @Override
    public SimpleQFilter[] getBaseFilters() {
        return this.baseFilters;
    }

    public void setBaseFilters(SimpleQFilter[] baseFilters) {
        this.baseFilters = baseFilters;
    }

    @Override
    public boolean isSqlQueryType() {
        return this.sqlQueryType;
    }

    public void setSqlQueryType(boolean sqlQueryType) {
        this.sqlQueryType = sqlQueryType;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public SimpleTableFieldMeta[] getSrcSelectFields() {
        return this.collections != null ? (SimpleTableFieldMeta[])((BaseMutableArrayMapStorage)this.collections).getValues() : new SimpleTableFieldMeta[]{};
    }

    public void addSrcSelectFields(Collection<SimpleTableFieldMeta> srcSelectFields) {
        if (srcSelectFields == null || srcSelectFields.isEmpty()) {
            if (this.collections != null) {
                ((BaseMutableArrayMapStorage)this.collections).clear();
            }
        } else {
            this.batchAdd(srcSelectFields);
        }
    }

    public void setAlgoQueryName(String algoQueryName) {
        this.algoQueryName = algoQueryName;
    }

    @Override
    public int getFetchBatchSize() {
        return this.fetchBatchSize;
    }

    @Override
    public void setFetchBatchSize(int fetchBatchSize) {
        this.fetchBatchSize = fetchBatchSize;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public int getRowOffSet() {
        return this.rowOffSet;
    }

    public void setRowOffSet(int rowOffSet) {
        this.rowOffSet = rowOffSet;
    }
}

