/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.engine.config.impl;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.LinkedList;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.engine.config.common.AbstractFieldDependedCfgModel;
import kd.fi.v2.fah.engine.enums.DataProcessorClassTypeEnum;
import kd.fi.v2.fah.models.table.meta.impl.SimpleTableFieldMeta;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.utils.StringUtils;

public class FunctionCalcUnitCfgModel
extends AbstractFieldDependedCfgModel {
    protected String functionName;
    protected DataValueTypeEnum resultDataType;
    protected SimpleTableFieldMeta outputFields;

    public FunctionCalcUnitCfgModel() {
    }

    public FunctionCalcUnitCfgModel(int runLevel, Integer cfgModelSeqKey, String functionName, DataValueTypeEnum resultDataType, SimpleTableFieldMeta outputFields) {
        super(runLevel, cfgModelSeqKey);
        this.functionName = functionName;
        this.resultDataType = resultDataType;
        this.outputFields = outputFields;
    }

    public FunctionCalcUnitCfgModel(int runLevel, Integer cfgModelSeqKey, String functionName, DataValueTypeEnum resultDataType) {
        super(runLevel, cfgModelSeqKey);
        this.functionName = functionName;
        this.resultDataType = resultDataType;
    }

    @Override
    public DataProcessorClassTypeEnum getProcessorClassType() {
        return DataProcessorClassTypeEnum.Function_Calculation;
    }

    @Override
    public Collection<String> doValidate() {
        LinkedList<String> error = new LinkedList<String>();
        if (StringUtils.isEmpty((String)this.functionName)) {
            error.add("Function Name is null");
        }
        if (this.resultDataType == null) {
            error.add("Function Result Data Type is null");
        }
        if (this.outputFields == null || this.outputFields.getWritePos() < 0) {
            error.add("Function Output Field is null or invalid");
        }
        return error;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public DataValueTypeEnum getResultDataType() {
        return this.resultDataType;
    }

    public void setResultDataType(DataValueTypeEnum resultDataType) {
        this.resultDataType = resultDataType;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public BaseMutableArrayMapStorage<String, SimpleTableFieldMeta> getInputFields() {
        return (BaseMutableArrayMapStorage)this.getCollections();
    }

    public void setInputFields(BaseMutableArrayMapStorage<String, SimpleTableFieldMeta> inputFields) {
        this.setCollections(inputFields);
    }

    public SimpleTableFieldMeta getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(SimpleTableFieldMeta outputFields) {
        this.outputFields = outputFields;
    }
}

