/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.engine.config.impl;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.engine.calc.IMathExpressionCalcFactor;
import kd.fi.v2.fah.engine.config.common.AbstractBaseProcessorCfgModel;
import kd.fi.v2.fah.engine.enums.DataProcessorClassTypeEnum;
import kd.fi.v2.fah.models.modeling.base.BaseModelFieldCfg;
import kd.fi.v2.fah.models.table.meta.impl.SimpleTableFieldMeta;
import kd.fi.v2.fah.models.valueset.IBaseFieldMeta;
import kd.fi.v2.fah.serializer.CustomJsonSerializer;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.storage.impl.CacheableMutableArrayStorage;

public class MathCalcUnitCfgModel
extends AbstractBaseProcessorCfgModel<Integer, IMathExpressionCalcFactor> {
    @JSONField(name="datas", serializeUsing=CustomJsonSerializer.class, deserializeUsing=CustomJsonSerializer.class)
    protected CacheableMutableArrayStorage<IMathExpressionCalcFactor> calcFactors;
    protected DataValueTypeEnum resultDataType;
    protected SimpleTableFieldMeta outputFields;

    public MathCalcUnitCfgModel() {
    }

    public MathCalcUnitCfgModel(int runLevel, Integer cfgModelSeqKey, DataValueTypeEnum resultDataType, SimpleTableFieldMeta outputFields) {
        super(runLevel, cfgModelSeqKey);
        this.resultDataType = resultDataType;
        this.outputFields = outputFields;
    }

    @Override
    public DataProcessorClassTypeEnum getProcessorClassType() {
        return DataProcessorClassTypeEnum.Math_Calculation;
    }

    @Override
    public Collection<String> doValidate() {
        LinkedList<String> error = new LinkedList<String>();
        if (this.calcFactors == null || this.calcFactors.isEmpty()) {
            error.add("Math Calculate Factor is null");
        }
        if (this.resultDataType == null) {
            error.add("Math Calculate Result Data Type is null");
        }
        if (this.outputFields == null || this.outputFields.getWritePos() < 0) {
            error.add("Math Calculate Output Field is invalid");
        }
        return error;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public Collection<IBaseFieldMeta> getDependedFields(boolean nest) {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<IBaseFieldMeta> result = new LinkedList<IBaseFieldMeta>();
        for (IMathExpressionCalcFactor factor : (IMathExpressionCalcFactor[])((BaseMutableArrayMapStorage)this.collections).getValues()) {
            if (factor == null || !factor.isVariable()) continue;
            result.add(new BaseModelFieldCfg((Long)((Object)factor.getSeqNo()), String.valueOf(factor.getFactorValue()), factor.getDataType()));
        }
        return result;
    }

    public CacheableMutableArrayStorage<IMathExpressionCalcFactor> getCalcFactors() {
        return this.calcFactors;
    }

    public void setCalcFactors(CacheableMutableArrayStorage<IMathExpressionCalcFactor> calcFactors) {
        this.calcFactors = calcFactors;
    }

    public DataValueTypeEnum getResultDataType() {
        return this.resultDataType;
    }

    public void setResultDataType(DataValueTypeEnum resultDataType) {
        this.resultDataType = resultDataType;
    }

    public SimpleTableFieldMeta getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(SimpleTableFieldMeta outputFields) {
        this.outputFields = outputFields;
    }
}

