/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.engine.processor;

import java.util.HashMap;
import java.util.Map;
import kd.fi.v2.fah.engine.config.IProcessorConfigContext;
import kd.fi.v2.fah.engine.processor.IProcessorUnit;

public class ProcessorLookupFactory {
    private static final ProcessorLookupFactory instance = new ProcessorLookupFactory();
    protected Map<String, IProcessorUnit> registeredProcessors = new HashMap<String, IProcessorUnit>(8);

    public static ProcessorLookupFactory getInstance() {
        return instance;
    }

    public boolean registeredProcessor(IProcessorUnit processorUnit) {
        if (processorUnit == null || processorUnit.getProcessorKey() == null) {
            return false;
        }
        this.registeredProcessors.put(processorUnit.getProcessorKey(), processorUnit);
        return true;
    }

    public IProcessorUnit getProcessorUnit(IProcessorConfigContext configContext) {
        return this.registeredProcessors.get(configContext.getProcessorKey());
    }

    public IProcessorUnit getProcessorUnit(String key) {
        return this.registeredProcessors.get(key);
    }

    public void returnProcessorInstance(IProcessorUnit processorUnit) {
        processorUnit.clear();
    }
}

