/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formbuilder.builder;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.fielddefvalue.DefValueDesign;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.ExtDataModelSystemFieldEnum;
import kd.fi.v2.fah.constant.enums.FieldPropEnum;
import kd.fi.v2.fah.constant.enums.formbuilder.FeatureFormFieldsEnum;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;
import kd.fi.v2.fah.formbuilder.DynamicFormConfig;
import kd.fi.v2.fah.formbuilder.containercfg.AdvConApCfg;
import kd.fi.v2.fah.formbuilder.containercfg.ContainerApCfg;
import kd.fi.v2.fah.formbuilder.containercfg.FieldsetPanelApCfg;
import kd.fi.v2.fah.formbuilder.fieldcfg.BaseFieldApCfg;
import kd.fi.v2.fah.formbuilder.fieldcfg.prop.CustomFormFieldPropCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldPropCfg;
import kd.fi.v2.fah.storage.impl.FormFieldFeatureCollection;

public class DynamicFormConfigBuilder {
    public static DynamicFormConfig createDynamicFormConfig(Long modelId, String bizAppId, boolean formal, boolean isFirstCreate) {
        DynamicObject eventClass = QueryServiceHelper.queryOne((String)"ai_eventclass", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)});
        if (null == eventClass) {
            return null;
        }
        DynamicFormConfig formConfig = new DynamicFormConfig(bizAppId);
        String number = eventClass.getString("number");
        if (Boolean.TRUE.equals(formal)) {
            String tableName = DataModelDaoImpl.getTableName(number);
            formConfig.setFormNumber(tableName);
            formConfig.setTableName(tableName);
            formConfig.setFormName(new LocaleString(eventClass.getString("name")));
        } else {
            formConfig.setFormNumber("fah_et_" + number);
            formConfig.setFormName(new LocaleString(String.format(ResManager.loadKDString((String)"%s\uff08\u9884\u89c8\uff09", (String)"DynamicFormConfigBuilder_0", (String)"fi-ai-common", (Object[])new Object[0]), eventClass.getString("name"))));
        }
        formConfig.setFormNumber(formConfig.getFormNumber().toLowerCase());
        formConfig.setDBRoute(FAHCommonConstant.FI.getRouteKey());
        LinkedHashMap<String, ContainerApCfg> containerCfgMap = new LinkedHashMap<String, ContainerApCfg>();
        HashMap<String, Set> entryAndSubEntryMap = new HashMap<String, Set>();
        String querySql = "select a.fmodelid,a.fgroupid,a.fseq,a.fname,a.fnumber,a.fbaseprop,a.fdatatype,a.fassistprop,a.fproperties_tag,a.fvisable,b.fid gfid,b.fgrouptype gfgrouptype,b.fgroupname gfgroupname,b.fgroupnumber gfgroupnumber,b.ftablename gftablename,b.fparentid gfparentid,b.flevel gflevel from t_fah_ext_modflds a left join t_fah_ext_modfldgrp b on a.fgroupid=b.fid where a.fmodelid=? order by b.fgrouptype,b.flevel,b.fseq,a.fseq";
        DataSet queryDataSet = DB.queryDataSet((String)DynamicFormConfigBuilder.class.getName(), (DBRoute)FAHCommonConstant.FI, (String)querySql, (Object[])new Object[]{modelId});
        Object object = null;
        try {
            for (Row row : queryDataSet) {
                String gfid = row.getString("gfid");
                String gfGroupType = row.getString("gfgrouptype");
                String gfGroupNumber = row.getString("gfgroupnumber");
                LocaleString gfGroupName = new LocaleString(row.getString("gfgroupname"));
                FeatureFormFieldsEnum fieldTypeEnum = FeatureFormFieldsEnum.getFeatureFormFieldsEnum(row.getString("fdatatype"));
                ContainerApCfg containerApCfg = (ContainerApCfg)containerCfgMap.get(gfid);
                if (("0".equals(gfGroupType) || "1".equals(gfGroupType)) && null == containerApCfg) {
                    containerApCfg = new FieldsetPanelApCfg();
                    DynamicFormConfigBuilder.setContainerApCfgBaseInfo(containerApCfg, gfGroupNumber, gfGroupName);
                    containerCfgMap.put(gfid, containerApCfg);
                } else if ("2".equals(gfGroupType)) {
                    AdvConApCfg advConApCfg;
                    if (null == containerApCfg) {
                        advConApCfg = new AdvConApCfg();
                        if (Boolean.TRUE.equals(formal)) {
                            advConApCfg.setEntryTableName(row.getString("gftablename"));
                        }
                        DynamicFormConfigBuilder.setContainerApCfgBaseInfo(advConApCfg, gfGroupNumber, gfGroupName);
                        containerCfgMap.put(gfid, advConApCfg);
                    } else {
                        advConApCfg = (AdvConApCfg)containerApCfg;
                    }
                    int gfLevel = row.getInteger("gflevel");
                    if (gfLevel == 2) {
                        String gfParentId = row.getString("gfparentid");
                        entryAndSubEntryMap.computeIfAbsent(gfParentId, t -> new LinkedHashSet()).add(row.getString("fgroupid"));
                        AdvConApCfg parentApCfg = (AdvConApCfg)containerCfgMap.get(gfParentId);
                        if (null == parentApCfg) continue;
                        advConApCfg.setParentEntryKey(parentApCfg.getEntryKey());
                        advConApCfg.setParentEntryId(parentApCfg.getEntryId());
                        advConApCfg.setParentPanelId(parentApCfg.getChildPanelId());
                    }
                }
                if (null == fieldTypeEnum) continue;
                BaseFieldApCfg field = new BaseFieldApCfg(fieldTypeEnum, new CustomFormFieldPropCfg[0]);
                field.setName(new LocaleString(row.getString("fname")));
                field.setKey(row.getString("fnumber").toLowerCase());
                field.setHidden(row.getBoolean("fvisable") == false);
                field.setIndex(row.getInteger("fseq"));
                field.setFeatures(DynamicFormConfigBuilder.createFormFieldFeature(row, fieldTypeEnum, isFirstCreate));
                containerApCfg = (ContainerApCfg)containerCfgMap.get(gfid);
                if (null == containerApCfg) continue;
                containerApCfg.getFieldCfgLi().add(field);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (queryDataSet != null) {
                if (object != null) {
                    try {
                        queryDataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    queryDataSet.close();
                }
            }
        }
        if (entryAndSubEntryMap.isEmpty()) {
            formConfig.setContainerCfgs(containerCfgMap);
        } else {
            LinkedHashMap<String, ContainerApCfg> newContainerCfgMap = new LinkedHashMap<String, ContainerApCfg>();
            for (Map.Entry entry : containerCfgMap.entrySet()) {
                String key = (String)entry.getKey();
                if (newContainerCfgMap.containsKey(key)) continue;
                newContainerCfgMap.put(key, (ContainerApCfg)entry.getValue());
                Set subEntrySet = (Set)entryAndSubEntryMap.get(key);
                if (null == subEntrySet || subEntrySet.isEmpty()) continue;
                for (String subEntry : subEntrySet) {
                    ContainerApCfg apCfg = (ContainerApCfg)containerCfgMap.get(subEntry);
                    if (null == apCfg) continue;
                    newContainerCfgMap.put(subEntry, apCfg);
                }
            }
            formConfig.setContainerCfgs(newContainerCfgMap);
        }
        return formConfig;
    }

    private static void setContainerApCfgBaseInfo(ContainerApCfg containerApCfg, String gfGroupNumber, LocaleString gfGroupName) {
        containerApCfg.setName(gfGroupName);
        containerApCfg.setKey(gfGroupNumber.toLowerCase());
        containerApCfg.setFieldCfgLi(new ArrayList<BaseFieldApCfg>());
    }

    public static FormFieldFeatureCollection createFormFieldFeature(Row row, FeatureFormFieldsEnum formFieldsEnum, boolean isFirstCreate) {
        ArrayList<CustomFormFieldPropCfg> cfgList = new ArrayList<CustomFormFieldPropCfg>();
        String number = row.getString("fnumber");
        String properties = row.getString("fproperties_tag");
        if (StringUtils.isNotEmpty((CharSequence)properties)) {
            DataModelFieldPropCfg[] fields;
            for (DataModelFieldPropCfg field : fields = (DataModelFieldPropCfg[])JSON.parseObject((String)properties, DataModelFieldPropCfg[].class)) {
                if (FieldPropEnum.DEFVALUEDESIGN.getNumber().equals(field.getName()) && (formFieldsEnum == FeatureFormFieldsEnum.BasedataFieldApCfg || formFieldsEnum == FeatureFormFieldsEnum.AssistantFieldApCfg)) {
                    DefValueDesign design = (DefValueDesign)JSON.parseObject((String)((String)field.getPropValue()), DefValueDesign.class);
                    cfgList.add(DynamicFormConfigBuilder.createFieldPropCfg(FieldPropEnum.DEFVALUEDESIGN.getNumber(), design, formFieldsEnum));
                    continue;
                }
                if (FieldPropEnum.SCALE.getNumber().equals(field.getName()) && formFieldsEnum == FeatureFormFieldsEnum.DecimalFieldApCfg) {
                    cfgList.add(DynamicFormConfigBuilder.createFieldPropCfg(FieldPropEnum.SCALE.getNumber(), isFirstCreate ? 10 : Integer.parseInt((String)field.getPropValue()), formFieldsEnum));
                    continue;
                }
                if (formFieldsEnum == FeatureFormFieldsEnum.DateTimeFieldApCfg && FieldPropEnum.DEFVALUE.getNumber().equals(field.getName())) continue;
                if (ExtDataModelSystemFieldEnum.DESCRIPTION.getNumber().equals(number) && FieldPropEnum.MAXLENGTH.getNumber().equals(field.getName())) {
                    field.setPropValue(FAHCommonConstant.DESCRIPTION_LENGTH_DATA.toString());
                }
                cfgList.add(DynamicFormConfigBuilder.createFieldPropCfg(field.getName(), field.getPropValue(), formFieldsEnum));
            }
        }
        if (formFieldsEnum == FeatureFormFieldsEnum.BasedataFieldApCfg) {
            String baseProp = MetadataDao.getIdByNumber((String)row.getString("fbaseprop"), (MetaCategory)MetaCategory.Entity);
            cfgList.add(DynamicFormConfigBuilder.createFieldPropCfg("baseEntityId", baseProp, formFieldsEnum));
        } else if (formFieldsEnum == FeatureFormFieldsEnum.AssistantFieldApCfg) {
            cfgList.add(DynamicFormConfigBuilder.createFieldPropCfg("asstTypeId", row.getString("fassistprop"), formFieldsEnum));
        }
        return new FormFieldFeatureCollection(cfgList.toArray(new CustomFormFieldPropCfg[0]));
    }

    private static CustomFormFieldPropCfg createFieldPropCfg(String featureName, Object featureValue, FeatureFormFieldsEnum formFieldsEnum) {
        return new CustomFormFieldPropCfg(featureName, featureValue, formFieldsEnum.getFieldClass());
    }
}

