/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.iterator;

import java.util.BitSet;
import java.util.Iterator;
import java.util.function.Function;

public class BitSetIterator<V>
implements Iterator<V> {
    protected BitSet srcBitSet;
    protected int currentPos;
    protected boolean eof;
    protected boolean foundSetBit;
    protected int posMultiplier;
    protected transient boolean needMultiplierPosition;
    protected Function<Integer, V> getValueFromPosFunc;

    public BitSetIterator(BitSet srcBitSet, boolean foundSetBit, int posMultiplier, Function<Integer, V> getValueFromPosFunc) {
        this.reset(srcBitSet, foundSetBit);
        this.getValueFromPosFunc = getValueFromPosFunc;
        this.posMultiplier = posMultiplier;
        this.needMultiplierPosition = this.posMultiplier > 1;
    }

    public BitSetIterator(BitSet srcBitSet, int posMultiplier, Function<Integer, V> getValueFromPosFunc) {
        this(srcBitSet, true, posMultiplier, getValueFromPosFunc);
    }

    public BitSetIterator(BitSet srcBitSet, boolean foundSetBit, Function<Integer, V> getValueFromPosFunc) {
        this(srcBitSet, foundSetBit, 1, getValueFromPosFunc);
    }

    public BitSetIterator(BitSet srcBitSet, Function<Integer, V> getValueFromPosFunc) {
        this(srcBitSet, true, 1, getValueFromPosFunc);
    }

    public static BitSetIterator<Integer> createIntPosBitSetIterator(BitSet srcBitSet, boolean foundSetBit, int posMultiplier) {
        return new BitSetIterator<Integer>(srcBitSet, foundSetBit, posMultiplier, pos -> pos);
    }

    public static BitSetIterator<Integer> createIntPosBitSetIterator(BitSet srcBitSet, boolean foundSetBit) {
        return new BitSetIterator<Integer>(srcBitSet, foundSetBit, pos -> pos);
    }

    public void reset(BitSet srcBitSet, boolean foundSetBit, int posMultiplier) {
        this.srcBitSet = srcBitSet;
        if (this.srcBitSet == null) {
            throw new IllegalArgumentException("Source BitSet Cannot be null!");
        }
        this.eof = false;
        this.currentPos = -1;
        this.foundSetBit = foundSetBit;
        this.posMultiplier = posMultiplier;
    }

    public void reset(BitSet srcBitSet, boolean foundSetBit) {
        this.reset(srcBitSet, foundSetBit, 1);
    }

    public void reset(BitSet srcBitSet, int posMultiplier) {
        this.reset(srcBitSet, true, posMultiplier);
    }

    @Override
    public boolean hasNext() {
        return (!this.eof && this.foundSetBit ? this.srcBitSet.nextSetBit(this.currentPos + 1) : this.srcBitSet.nextClearBit(this.currentPos + 1)) >= 0;
    }

    @Override
    public V next() {
        if (this.hasNext()) {
            this.currentPos = this.foundSetBit ? this.srcBitSet.nextSetBit(this.currentPos + 1) : this.srcBitSet.nextClearBit(this.currentPos + 1);
            return this.getValueFromPosFunc.apply(this.needMultiplierPosition ? this.currentPos / this.posMultiplier : this.currentPos);
        }
        this.eof = true;
        throw new IndexOutOfBoundsException("BitSet Iterator EOF");
    }

    public int getCurrentPos() {
        return this.needMultiplierPosition ? this.currentPos / this.posMultiplier : this.currentPos;
    }

    public boolean isEof() {
        return this.eof;
    }

    public boolean isFoundSetBit() {
        return this.foundSetBit;
    }

    public int getPosMultiplier() {
        return this.posMultiplier;
    }

    public boolean isNeedMultiplierPosition() {
        return this.needMultiplierPosition;
    }

    public Function<Integer, V> getGetValueFromPosFunc() {
        return this.getValueFromPosFunc;
    }

    public void setEof(boolean eof) {
        this.eof = eof;
    }
}

