/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.junit.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.fi.v2.fah.junit.common.FahTestModule;

public class FahTestResult {
    private static final Map<String, Map<String, List<String>>> authorStatistic = new HashMap<String, Map<String, List<String>>>(16);

    public static void putUnitTest(String author, FahTestModule module, String description) {
        Map moduleMap = authorStatistic.computeIfAbsent(author, k -> new HashMap(32));
        List descriptions = moduleMap.computeIfAbsent(module.getName(), k -> new ArrayList(32));
        descriptions.add(description);
    }

    public static void printStatistic() {
        HashMap<String, Map> authorModuleData = new HashMap<String, Map>(authorStatistic.size());
        HashMap authorData = new HashMap(authorStatistic.size());
        HashMap<String, Integer> moduleData = new HashMap<String, Integer>(authorStatistic.size());
        authorStatistic.forEach((author, moduleMap) -> moduleMap.forEach((module, descriptions) -> {
            int size = descriptions.size();
            Integer mNum = moduleData.computeIfAbsent((String)module, m -> 0);
            Integer aNum = authorData.computeIfAbsent(author, a -> 0);
            moduleData.put((String)module, mNum + size);
            authorData.put(author, aNum + size);
            Integer amNum = authorModuleData.computeIfAbsent((String)author, a -> new HashMap(16)).computeIfAbsent(module, m -> 0);
            ((Map)authorModuleData.get(author)).put(module, amNum + size);
        }));
        authorModuleData.forEach((author, mData) -> FahTestResult.printAuthorData(author, mData, (Integer)authorData.get(author)));
        System.out.println();
        moduleData.forEach(FahTestResult::printModuleData);
        System.out.println();
    }

    private static void printAuthorData(String author, Map<String, Integer> amData, int total) {
        System.out.printf("author: %1$s, finished unit test count: %2$s. detail: \n", author, total);
        amData.forEach((module, num) -> System.out.printf("%1$s unit test count: %2$s\n", module, num));
    }

    private static void printModuleData(String module, int total) {
        System.out.printf("module: %1$s, unit test count: %2$s.\n", module, total);
    }
}

