/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.junit.env;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.sharding.ShardingManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.lang.Lang;
import kd.bos.license.service.cache.LicenseCacheMrg;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.xdb.XDBConfig;
import kd.fi.v2.fah.junit.env.FahJUnitEnvRestoreInfo;
import kd.fi.v2.fah.utils.StringUtils;
import org.apache.commons.io.FileUtils;

public class FahJUnitEnvRestoreHelper {
    public static FahJUnitEnvRestoreInfo buildSampleRestoreInfo(String configUrl, String clusterName, String tenantId, boolean containLicense, BiConsumer<String, String> systemParamConsumer) {
        FahJUnitEnvRestoreInfo result = new FahJUnitEnvRestoreInfo();
        HashMap<String, String> configParams = new HashMap<String, String>(16);
        result.setSystemParams(configParams);
        configParams.put("logfactory.className", "kd.fi.v2.fah.junit.mock.log.FahMockLogFactory");
        configParams.put("appName", "mservice");
        configParams.put("clusterName", clusterName);
        configParams.put("configUrl", configUrl);
        configParams.put("db.sql.out", "false");
        configParams.put("db.sql.out.withParameter", "false");
        configParams.put("tempfile.cachetype", "disk");
        configParams.put("mc.type", "ZK");
        configParams.put("tenantid", tenantId);
        configParams.put("domain.tenantCode", tenantId);
        configParams.put("bos.checkThreadContext", "false");
        configParams.put("Schedule.disableToWork", "false");
        configParams.put("trace.enable", "false");
        configParams.put("audit.enable", "false");
        configParams.put("redis.backendcheck.enable", "false");
        configParams.put("ha.component.enable", "false");
        configParams.put("dts.sync.enable", "false");
        configParams.put("dts.sync.allAccount.enable.fordev", "false");
        configParams.put("dts.query.enable", "false");
        configParams.put("configAppName", "mservice,web");
        configParams.put("webmserviceinone", "true");
        configParams.put("dubbo.consumer.url", "dubbo://localhost:20880");
        configParams.put("dubbo.consumer.url.qing", "dubbo://localhost:30880");
        configParams.put("dubbo.registry.register", "false");
        configParams.put("dubbo.service.lookup.local", "true");
        configParams.put("appSplit", "false");
        configParams.put("JETTY_WEBAPP_PATH", "C:\\biz-evn-dev\\mservice\\webapp");
        configParams.put("JETTY_PORT", "58080");
        configParams.put("JETTY_CONTEXT", "/ierp");
        configParams.put("login.type", "STANDALONE");
        configParams.put("tenant.code.type", "config");
        if (containLicense) {
            FahJUnitEnvRestoreHelper.restoreSystemProperties(configParams, systemParamConsumer);
            FahJUnitEnvRestoreHelper.reloadAccountInfo(result);
            FahJUnitEnvRestoreHelper.restoreRequestContext(result);
            FahJUnitEnvRestoreHelper.reLoadLicenseCache(result);
            FahJUnitEnvRestoreHelper.reloadLicenseDetailCache(result);
        }
        return result;
    }

    public static FahJUnitEnvRestoreInfo buildSampleRestoreInfo(String configUrl, String clusterName, boolean containLicense, BiConsumer<String, String> systemParamConsumer) {
        return FahJUnitEnvRestoreHelper.buildSampleRestoreInfo(configUrl, clusterName, "tenant_" + clusterName, containLicense, systemParamConsumer);
    }

    public static FahJUnitEnvRestoreInfo buildSampleRestoreInfo(String configUrl, String clusterName, BiConsumer<String, String> systemParamConsumer) {
        return FahJUnitEnvRestoreHelper.buildSampleRestoreInfo(configUrl, clusterName, "tenant_" + clusterName, true, systemParamConsumer);
    }

    public static boolean outputSampleRestoreInfo(FahJUnitEnvRestoreInfo srcInfo, File file) throws IOException {
        if (srcInfo == null || StringUtils.isEmpty(file)) {
            return false;
        }
        FileUtils.write((File)file, (CharSequence)JSON.toJSONString((Object)srcInfo, (boolean)true), (Charset)StandardCharsets.UTF_8);
        return true;
    }

    public static void restoreRequestContext(FahJUnitEnvRestoreInfo srcInfo) {
        RequestContext requestContext = RequestContext.create();
        requestContext.setTenantId(srcInfo.getTenantId());
        requestContext.setAccountId(srcInfo.getAccountId());
        requestContext.setLang(Lang.defaultLang());
    }

    public static void reloadAccountInfo(FahJUnitEnvRestoreInfo outputInfo) {
        Account account;
        List accountList = AccountUtils.getAllAccountsOfCurrentEnv();
        outputInfo.setAccountList(accountList);
        if (accountList != null && !accountList.isEmpty() && (account = (Account)accountList.get(0)) != null) {
            outputInfo.setAccountId(account.getAccountId());
            outputInfo.setTenantId(account.getTenantId());
        }
    }

    public static void reLoadLicenseCache(FahJUnitEnvRestoreInfo outputInfo) {
        String type = LicenseCacheMrg.getType4UserLicenseGroups();
        outputInfo.setType4UserLicenseGroups(type);
        String sql = "SELECT FUSERID, FGROUPID FROM T_LIC_USERLICENSEGROUP where fsyncstatus = '1' ";
        Map userLicGroupMap = (Map)DB.query((DBRoute)DBRoute.base, (String)sql, row -> {
            HashMap<String, Set> map = new HashMap<String, Set>(1024);
            while (row.next()) {
                String userId = row.getString("FUSERID");
                String groupId = row.getString("FGROUPID");
                map.computeIfAbsent(userId, k1 -> new HashSet()).add(groupId);
            }
            return map;
        });
        HashMap<String, String> userLicenseGroups = new HashMap<String, String>(userLicGroupMap.size());
        for (Map.Entry entry : userLicGroupMap.entrySet()) {
            userLicenseGroups.put((String)entry.getKey(), SerializationUtils.toJsonString(entry.getValue()));
        }
        outputInfo.setUserLicenseGrp(userLicenseGroups);
    }

    public static void reloadLicenseDetailCache(FahJUnitEnvRestoreInfo outputInfo) {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"lic_license", (String)"lic_licensedetail.group,lic_licensedetail.totalcount", (QFilter[])null);
        String licenseDetailType = LicenseCacheMrg.getType4LicenseDetail();
        outputInfo.setLicenseDetailType(licenseDetailType);
        HashMap<String, String> licenseDetail = new HashMap<String, String>(16);
        if (load != null && load.length != 0) {
            DynamicObject[] var3 = load;
            int var4 = load.length;
            for (int var5 = 0; var5 < var4; ++var5) {
                DynamicObject licenseObj = var3[var5];
                DynamicObjectCollection details = licenseObj.getDynamicObjectCollection("lic_licensedetail");
                for (DynamicObject detailGroup : details) {
                    licenseDetail.put(detailGroup.getDynamicObject("group").getPkValue().toString(), detailGroup.getString("totalcount"));
                }
            }
        }
        licenseDetail.put("DATA_LOADED", "DATA_LOADED");
        outputInfo.setLicenseDetail(licenseDetail);
    }

    public static void restoreSystemProperties(Map<String, String> systemParams, BiConsumer<String, String> systemParamConsumer) {
        if (systemParams != null && !systemParams.isEmpty() && systemParamConsumer != null) {
            for (Map.Entry<String, String> en : systemParams.entrySet()) {
                systemParamConsumer.accept(en.getKey(), en.getValue());
            }
        }
    }

    public static void restoreXDBConfig() {
        XDBConfig.setupXDBEnable(() -> Boolean.TRUE);
        ShardingManager.get().loadShardingConfigs(true);
    }

    public static void restoreBosEnv(FahJUnitEnvRestoreInfo restoreInfo, boolean clearLicenseCache, BiConsumer<String, String> systemParamConsumer) {
        FahJUnitEnvRestoreHelper.restoreSystemProperties(restoreInfo.getSystemParams(), systemParamConsumer);
        FahJUnitEnvRestoreHelper.restoreRequestContext(restoreInfo);
        String type4UserLicenseGroups = restoreInfo.getType4UserLicenseGroups();
        if (clearLicenseCache) {
            LicenseCacheMrg.clearCache((String)type4UserLicenseGroups);
        }
        LicenseCacheMrg.putCache((String)type4UserLicenseGroups, (String)"DATA_LOADED", (String)"DATA_LOADED");
        LicenseCacheMrg.putCache((String)type4UserLicenseGroups, restoreInfo.getUserLicenseGrp());
        String licenseDetailType = restoreInfo.getLicenseDetailType();
        if (clearLicenseCache) {
            LicenseCacheMrg.clearCache((String)licenseDetailType);
        }
        LicenseCacheMrg.putCache((String)licenseDetailType, restoreInfo.getLicenseDetail());
        FahJUnitEnvRestoreHelper.restoreXDBConfig();
    }

    public static boolean restoreFromFile(File srcFile, BiConsumer<String, String> systemParamConsumer) throws IOException {
        if (srcFile == null) {
            return false;
        }
        String fileStr = FileUtils.readFileToString((File)srcFile, (Charset)StandardCharsets.UTF_8);
        FahJUnitEnvRestoreInfo restoreInfo = (FahJUnitEnvRestoreInfo)JSON.parseObject((String)fileStr, FahJUnitEnvRestoreInfo.class);
        FahJUnitEnvRestoreHelper.restoreBosEnv(restoreInfo, true, systemParamConsumer);
        return true;
    }
}

