/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.log;

import java.util.Collection;
import java.util.Collections;
import kd.fi.v2.fah.log.LogLevelEnum;
import kd.fi.v2.fah.task.context.IBackgroundTaskContext;
import kd.fi.v2.fah.utils.StringUtils;

public interface ILogHandler<STAGE_CODE, TASK_CONTEXT extends IBackgroundTaskContext> {
    public boolean outputLog(LogLevelEnum var1, STAGE_CODE var2, Object var3, Collection<String> var4, Throwable var5, TASK_CONTEXT var6);

    default public boolean outputLog(LogLevelEnum logLevel, STAGE_CODE stageCode, Object srcModel, Collection<String> msgs, Throwable throwable) {
        return this.outputLog(logLevel, stageCode, srcModel, msgs, throwable, null);
    }

    default public boolean outputLog(LogLevelEnum logLevel, STAGE_CODE stageCode, Object srcModel, Collection<String> msgs) {
        return this.outputLog(logLevel, stageCode, srcModel, msgs, null);
    }

    default public boolean outputLog(LogLevelEnum logLevel, Object srcModel, Collection<String> msgs) {
        return this.outputLog(logLevel, null, srcModel, msgs, null);
    }

    default public boolean outputLog(LogLevelEnum logLevel, String msg) {
        return this.outputLog(logLevel, null, null, Collections.singletonList(msg), null);
    }

    default public boolean debug(String msg) {
        return this.outputLog(LogLevelEnum.Debug, null, null, Collections.singletonList(msg), null);
    }

    default public boolean onDebug(String msg) {
        return this.outputLog(LogLevelEnum.Debug, null, null, Collections.singletonList(msg), null);
    }

    default public boolean onDebug(String msg, Object srcModel) {
        return this.outputLog(LogLevelEnum.Debug, null, srcModel, Collections.singletonList(msg), null);
    }

    default public boolean onDebug(int prefixLevel, String msg, Object srcModel) {
        return this.outputLog(LogLevelEnum.Debug, null, srcModel, Collections.singletonList(StringUtils.buildPrefix("   ", prefixLevel) + msg), null);
    }

    default public boolean onDebug(Collection<String> msgs, Object srcModel) {
        return this.outputLog(LogLevelEnum.Debug, null, srcModel, msgs, null);
    }

    default public boolean onDebug(STAGE_CODE stageCode, Object srcModel, TASK_CONTEXT taskContext) {
        return this.outputLog(LogLevelEnum.Debug, stageCode, srcModel, null, null, taskContext);
    }

    default public boolean debug(String msgTemplate, Object ... params) {
        return this.debug(0, msgTemplate, params);
    }

    default public boolean debug(int level, String msgTemplate, Object ... params) {
        if (params == null || params.length == 0) {
            return this.outputLog(LogLevelEnum.Debug, null, null, Collections.singletonList(StringUtils.buildPrefix("   ", level) + msgTemplate), null);
        }
        return this.outputLog(LogLevelEnum.Debug, null, null, Collections.singletonList(StringUtils.buildPrefix("   ", level) + String.format(msgTemplate, params)), null);
    }

    default public boolean info(String msg) {
        return this.outputLog(LogLevelEnum.Info, null, null, Collections.singletonList(msg), null);
    }

    default public boolean onInfo(String msg) {
        return this.outputLog(LogLevelEnum.Info, null, null, Collections.singletonList(msg), null);
    }

    default public boolean onInfo(String msg, Object srcModel) {
        return this.outputLog(LogLevelEnum.Info, null, srcModel, Collections.singletonList(msg), null);
    }

    default public boolean onInfo(int prefixLevel, String msg, Object srcModel) {
        return this.outputLog(LogLevelEnum.Info, null, srcModel, Collections.singletonList(StringUtils.buildPrefix("   ", prefixLevel) + msg), null);
    }

    default public boolean onInfo(Collection<String> msgs, Object srcModel) {
        return this.outputLog(LogLevelEnum.Info, null, srcModel, msgs, null);
    }

    default public boolean onInfo(STAGE_CODE stageCode, Object srcModel, TASK_CONTEXT taskContext) {
        return this.outputLog(LogLevelEnum.Info, stageCode, srcModel, null, null, taskContext);
    }

    default public boolean warning(String msg, Throwable throwable) {
        return this.outputLog(LogLevelEnum.Warning, null, null, Collections.singletonList(msg), null);
    }

    default public boolean onWarning(String msg, Throwable throwable) {
        return this.outputLog(LogLevelEnum.Warning, null, null, Collections.singletonList(msg), null);
    }

    default public boolean onWarning(String msg, Object srcModel, Throwable throwable) {
        return this.outputLog(LogLevelEnum.Warning, null, srcModel, Collections.singletonList(msg), null);
    }

    default public boolean onWarning(int prefixLevel, String msg, Object srcModel, Throwable throwable) {
        return this.outputLog(LogLevelEnum.Warning, null, srcModel, Collections.singletonList(StringUtils.buildPrefix("   ", prefixLevel) + msg), null);
    }

    default public boolean onWarning(Collection<String> msgs, Object srcModel, Throwable throwable) {
        return this.outputLog(LogLevelEnum.Warning, null, srcModel, msgs, null);
    }

    default public boolean error(String msg, Throwable throwable) {
        return this.outputLog(LogLevelEnum.Error, null, null, Collections.singletonList(msg), throwable);
    }

    default public boolean onError(String msg, Throwable throwable) {
        return this.outputLog(LogLevelEnum.Error, null, null, Collections.singletonList(msg), throwable);
    }

    default public boolean onError(String msg, Object srcModel, Throwable throwable) {
        return this.outputLog(LogLevelEnum.Error, null, srcModel, Collections.singletonList(msg), throwable);
    }

    default public boolean onError(int prefixLevel, String msg, Object srcModel, Throwable throwable) {
        return this.outputLog(LogLevelEnum.Error, null, srcModel, Collections.singletonList(StringUtils.buildPrefix("   ", prefixLevel) + msg), throwable);
    }

    default public boolean onError(Collection<String> msgs, Object srcModel, Throwable throwable) {
        return this.outputLog(LogLevelEnum.Error, null, srcModel, msgs, throwable);
    }

    default public boolean onError(STAGE_CODE stageCode, Object srcModel, String errorMsg, Throwable throwable, TASK_CONTEXT taskContext) {
        return this.outputLog(LogLevelEnum.Error, stageCode, srcModel, Collections.singleton(errorMsg), throwable, taskContext);
    }

    default public boolean onError(STAGE_CODE stageCode, Object srcModel, String msg, TASK_CONTEXT taskContext) {
        return this.outputLog(LogLevelEnum.Error, stageCode, srcModel, Collections.singleton(msg), null, taskContext);
    }

    default public boolean onError(STAGE_CODE stageCode, Object srcModel, Collection<String> msgs, TASK_CONTEXT taskContext) {
        return this.outputLog(LogLevelEnum.Error, stageCode, srcModel, msgs, null, taskContext);
    }

    default public boolean onError(String errorMsg, Throwable throwable, Object srcModel) {
        return this.outputLog(LogLevelEnum.Error, null, srcModel, Collections.singleton(errorMsg), throwable, null);
    }

    default public boolean onError(String errorMsg, Object srcModel) {
        return this.outputLog(LogLevelEnum.Error, null, srcModel, Collections.singleton(errorMsg), null, null);
    }

    default public boolean onFatal(STAGE_CODE stageCode, Object srcModel, String errorMsg, Throwable throwable, TASK_CONTEXT taskContext) {
        return this.outputLog(LogLevelEnum.Fatal, stageCode, srcModel, Collections.singleton(errorMsg), throwable, taskContext);
    }

    default public boolean onFatal(STAGE_CODE stageCode, Object srcModel, String errorMsg, TASK_CONTEXT taskContext) {
        return this.outputLog(LogLevelEnum.Fatal, stageCode, srcModel, Collections.singleton(errorMsg), null, taskContext);
    }

    default public boolean onFatal(STAGE_CODE stageCode, Object srcModel, Collection<String> errorMsgs, TASK_CONTEXT taskContext) {
        return this.outputLog(LogLevelEnum.Fatal, stageCode, srcModel, errorMsgs, null, taskContext);
    }
}

