/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.meta;

import java.util.Collection;
import java.util.function.Function;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.models.table.meta.impl.SimpleTableFieldMeta;
import kd.fi.v2.fah.models.table.meta.impl.SimpleTableMeta;

public class SimpleBaseDTOMeta
extends SimpleTableMeta<String> {
    protected int pkColumnIndex = -1;
    protected int seqColumnIndex = -1;

    protected SimpleBaseDTOMeta() {
    }

    protected SimpleBaseDTOMeta(String tableNum) {
        super(tableNum);
    }

    public SimpleTableFieldMeta addColumn(String columnNum, DataValueTypeEnum dataValueType, String alias) {
        SimpleTableFieldMeta fieldMeta = new SimpleTableFieldMeta(columnNum, dataValueType);
        fieldMeta.setDbFieldNum(alias);
        int idx = this.size();
        fieldMeta.setAccessPosIdx(new int[]{idx, idx});
        fieldMeta.setSeq(idx);
        this.add(fieldMeta);
        return fieldMeta;
    }

    public SimpleTableFieldMeta addColumn(String columnNum) {
        return this.addColumn(columnNum, null, columnNum);
    }

    public static SimpleBaseDTOMeta buildSimpleBaseDTOMeta(String tableName, String[] columns, DataValueTypeEnum[] columnDataTypes) {
        SimpleBaseDTOMeta dtoMeta = new SimpleBaseDTOMeta(tableName);
        boolean addDataType = columnDataTypes != null && columnDataTypes.length == columns.length;
        int idx = 0;
        for (String col : columns) {
            SimpleTableFieldMeta fieldMeta = new SimpleTableFieldMeta(col, addDataType ? columnDataTypes[idx] : null);
            fieldMeta.setDbFieldNum(col);
            fieldMeta.setAccessPosIdx(new int[]{idx, idx});
            fieldMeta.setSeq(idx);
            dtoMeta.cache(fieldMeta);
            ++idx;
        }
        dtoMeta.flush();
        return dtoMeta;
    }

    public static SimpleBaseDTOMeta buildSimpleBaseDTOMeta(String tableName, String[] columns) {
        return SimpleBaseDTOMeta.buildSimpleBaseDTOMeta(tableName, columns, null);
    }

    public static SimpleBaseDTOMeta buildSimpleBaseDTOMeta(String tableName, Collection<String> columns) {
        return SimpleBaseDTOMeta.buildSimpleBaseDTOMeta(tableName, columns.toArray(new String[0]));
    }

    public boolean validateColumnIndex(int columnIdx) {
        return columnIdx >= 0 && columnIdx < this.size();
    }

    public int getColumnPos(String columnNum, boolean readPos) {
        SimpleTableFieldMeta fieldMeta = (SimpleTableFieldMeta)this.get(columnNum);
        return fieldMeta != null ? (readPos ? fieldMeta.getReadPos() : fieldMeta.getWritePos()) : -1;
    }

    public <T> T accessFiledMeta(int columnIdx, Function<SimpleTableFieldMeta, T> accessFunc) {
        SimpleTableFieldMeta fieldMeta = (SimpleTableFieldMeta)this.get(columnIdx);
        return fieldMeta != null ? (T)accessFunc.apply(fieldMeta) : null;
    }

    public <T> T accessFiledMeta(String columnNum, Function<SimpleTableFieldMeta, T> accessFunc) {
        return this.accessFiledMeta(this.getIndex(columnNum), accessFunc);
    }

    public int getPkColumnIndex() {
        return this.pkColumnIndex;
    }

    public void setPkColumnIndex(int pkColumnIndex) {
        this.pkColumnIndex = pkColumnIndex;
    }

    public int getSeqColumnIndex() {
        return this.seqColumnIndex;
    }

    public void setSeqColumnIndex(int seqColumnIndex) {
        this.seqColumnIndex = seqColumnIndex;
    }
}

