/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.common.tree;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import kd.fi.v2.fah.models.common.tree.IBaseTreeNode;
import kd.fi.v2.fah.models.common.tree.ICommonTreeModel;
import kd.fi.v2.fah.utils.TreeModelUtils;

public interface IBaseTreeModel<NODE_KEY, V, NODE_TYPE extends IBaseTreeNode<NODE_KEY, V>>
extends ICommonTreeModel<NODE_KEY> {
    public boolean addChildNode(NODE_TYPE var1);

    public NODE_TYPE getNodeByKey(NODE_KEY var1, boolean var2);

    default public NODE_TYPE getChildNodeByKey(NODE_KEY nodeKey) {
        return this.getNodeByKey(nodeKey, true);
    }

    default public NODE_TYPE getParentNodeByKey(NODE_KEY nodeKey) {
        return this.getNodeByKey(nodeKey, false);
    }

    public boolean containNodeKey(NODE_KEY var1);

    public NODE_TYPE createEmptyNode(NODE_KEY var1);

    default public NODE_TYPE createEmptyNode(NODE_KEY[] nodePath, int pathStartIndex) {
        if ((pathStartIndex = TreeModelUtils.validatePathIndex(nodePath, pathStartIndex)) >= 0) {
            NODE_TYPE node = this.getNodeByKey(nodePath[pathStartIndex], true);
            if (node == null) {
                node = this.createEmptyNode(nodePath[pathStartIndex]);
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Failed on Create Path Node=%s, pathStartIndex=%d", Arrays.deepToString(nodePath), pathStartIndex));
                }
                this.addChildNode(node);
            }
            return (NODE_TYPE)(pathStartIndex >= nodePath.length - 1 ? node : node.createEmptyNode(nodePath, pathStartIndex + 1));
        }
        return null;
    }

    default public NODE_TYPE createEmptyNode(List nodePath, int pathStartIndex) {
        if ((pathStartIndex = TreeModelUtils.validatePathIndex(nodePath, pathStartIndex)) >= 0) {
            Object key = nodePath.get(pathStartIndex);
            NODE_TYPE node = this.getNodeByKey(key, true);
            if (node == null) {
                node = this.createEmptyNode(key);
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Failed on Create Path Node=%s, pathStartIndex=%d", nodePath, pathStartIndex));
                }
                this.addChildNode(node);
            }
            return (NODE_TYPE)(pathStartIndex >= nodePath.size() - 1 ? node : node.createEmptyNode(nodePath, pathStartIndex + 1));
        }
        return null;
    }

    default public NODE_TYPE addChild(NODE_KEY nodeKey, NODE_KEY[] parentPath, int pathStartIndex) {
        Object resultNewNode;
        IBaseTreeNode parentNode;
        if (nodeKey == null) {
            return null;
        }
        if ((pathStartIndex = TreeModelUtils.validatePathIndex(parentPath, pathStartIndex)) >= 0) {
            NODE_TYPE NODE_TYPE = this.getChildByPath(parentPath, pathStartIndex);
            parentNode = (IBaseTreeNode)NODE_TYPE;
            if (NODE_TYPE == null && (parentNode = this.createEmptyNode(parentPath, pathStartIndex)) == null) {
                throw new IllegalArgumentException(String.format("Failed on Create Path Node=%s, pathStartIndex=%d", Arrays.deepToString(parentPath), pathStartIndex));
            }
            this.addChildNode(parentNode);
        } else {
            parentNode = null;
        }
        if (parentNode != null) {
            resultNewNode = parentNode.getChildNodeByKey(nodeKey);
            if (resultNewNode == null) {
                resultNewNode = parentNode.addChild(nodeKey);
            }
        } else {
            resultNewNode = this.getChildNodeByKey(nodeKey);
            if (resultNewNode == null && !this.addChildNode(resultNewNode = this.createEmptyNode(nodeKey))) {
                throw new IllegalArgumentException(String.format("Failed on Create Node=%s, Path=%s, pathStartIndex=%d", nodeKey, Arrays.deepToString(parentPath), pathStartIndex));
            }
        }
        this.addChildNode(resultNewNode);
        return (NODE_TYPE)resultNewNode;
    }

    default public NODE_TYPE addChild(NODE_KEY nodeKey, NODE_KEY[] parentPath) {
        return this.addChild(nodeKey, parentPath, 0);
    }

    default public NODE_TYPE addChild(NODE_KEY nodeKey) {
        return this.addChild(nodeKey, null, 0);
    }

    default public NODE_TYPE addChildByPathKey(NODE_KEY[] pathKey, int pathStartIndex) {
        NODE_TYPE newNode = this.createEmptyNode(pathKey, pathStartIndex);
        return (NODE_TYPE)(this.addChildNode(newNode) ? newNode : null);
    }

    default public NODE_TYPE getChildByPath(NODE_KEY nodeKey, NODE_KEY[] parentPath, int pathStartIndex) {
        NODE_TYPE childNode = this.getChildByPath(parentPath, pathStartIndex);
        return childNode != null ? (NODE_TYPE)childNode.getNodeByKey(nodeKey, true) : null;
    }

    default public NODE_TYPE getChildByPath(NODE_KEY[] nodePath, int pathStartIndex) {
        if ((pathStartIndex = TreeModelUtils.validatePathIndex(nodePath, pathStartIndex)) < 0) {
            return null;
        }
        NODE_TYPE childNode = this.getParentNodeByKey(nodePath[pathStartIndex]);
        if (childNode == null) {
            return null;
        }
        return (NODE_TYPE)(pathStartIndex >= nodePath.length - 1 ? childNode : childNode.getChildByPath(nodePath, pathStartIndex + 1));
    }

    default public NODE_TYPE getChildByPath(NODE_KEY[] nodePath) {
        return this.getChildByPath(nodePath, 0);
    }

    public void dumpNode(StringBuilder var1, String var2, Integer var3, boolean var4, BiFunction<int[], V, String> var5);

    @Override
    default public void dumpNode(StringBuilder output, String levelPrefix, boolean reverseMode) {
        this.dumpNode(output, levelPrefix, null, reverseMode, null);
    }
}

