/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.common.tree;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import kd.fi.v2.fah.models.common.tree.ICommonTreeModel;
import kd.fi.v2.fah.models.common.tree.common.AbstractBaseTreeNode;
import kd.fi.v2.fah.utils.TreeModelUtils;

public interface IBaseTreeNode<NODE_KEY, V>
extends ICommonTreeModel<NODE_KEY> {
    public Collection<Object> getNodePath(boolean var1, boolean var2, Function<AbstractBaseTreeNode, Object> var3);

    public V getNodeValues();

    public void setNodeValues(V var1);

    public boolean hasParent();

    public int getDependencyLevel(boolean var1);

    public boolean addParentNode(IBaseTreeNode<NODE_KEY, V> var1);

    public boolean addChildNode(IBaseTreeNode<NODE_KEY, V> var1);

    public <T extends IBaseTreeNode<NODE_KEY, V>> T getNodeByKey(NODE_KEY var1, boolean var2);

    default public <T extends IBaseTreeNode<NODE_KEY, V>> T getChildNodeByKey(NODE_KEY nodeKey) {
        return this.getNodeByKey(nodeKey, true);
    }

    default public <T extends IBaseTreeNode<NODE_KEY, V>> T getParentNodeByKey(NODE_KEY nodeKey) {
        return this.getNodeByKey(nodeKey, false);
    }

    public <T extends IBaseTreeNode<NODE_KEY, V>> T createEmptyNode(NODE_KEY var1);

    @JSONField(serialize=false)
    @JsonIgnore
    default public <T extends IBaseTreeNode<NODE_KEY, V>> T getNodeCopy() {
        T newNode = this.createEmptyNode(this.getKey());
        newNode.setNodeValues(this.getNodeValues());
        newNode.doNodeMerge(this);
        return newNode;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public <T extends IBaseTreeNode<NODE_KEY, V>> Collection<T> getParentsCopy();

    @JSONField(serialize=false)
    @JsonIgnore
    public <T extends IBaseTreeNode<NODE_KEY, V>> Collection<T> getChildCopy();

    default public <T extends IBaseTreeNode<NODE_KEY, V>> Collection<T> getDependencyCopy(boolean reverseMode) {
        return reverseMode ? this.getChildCopy() : this.getParentsCopy();
    }

    public boolean hasDependencyCopy(boolean var1);

    public boolean doNodeMerge(IBaseTreeNode<NODE_KEY, V> var1);

    default public <T extends IBaseTreeNode<NODE_KEY, V>> T createEmptyNode(NODE_KEY[] nodePath, int pathStartIndex) {
        if ((pathStartIndex = TreeModelUtils.validatePathIndex(nodePath, pathStartIndex)) >= 0) {
            T node = this.getNodeByKey(nodePath[pathStartIndex], true);
            if (node == null) {
                node = this.createEmptyNode(nodePath[pathStartIndex]);
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Failed on Create Path Node=%s, pathStartIndex=%d", Arrays.deepToString(nodePath), pathStartIndex));
                }
                this.addChildNode((IBaseTreeNode<NODE_KEY, V>)node);
            }
            return pathStartIndex >= nodePath.length - 1 ? node : node.createEmptyNode(nodePath, pathStartIndex + 1);
        }
        return null;
    }

    default public <T extends IBaseTreeNode<NODE_KEY, V>> T createEmptyNode(List nodePath, int pathStartIndex) {
        if ((pathStartIndex = TreeModelUtils.validatePathIndex(nodePath, pathStartIndex)) >= 0) {
            Object key = nodePath.get(pathStartIndex);
            T node = this.getNodeByKey(key, true);
            if (node == null) {
                node = this.createEmptyNode(key);
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Failed on Create Path Node=%s, pathStartIndex=%d", nodePath, pathStartIndex));
                }
                this.addChildNode((IBaseTreeNode<NODE_KEY, V>)node);
            }
            return pathStartIndex >= nodePath.size() - 1 ? node : node.createEmptyNode(nodePath, pathStartIndex + 1);
        }
        return null;
    }

    default public <T extends IBaseTreeNode<NODE_KEY, V>> T addChild(NODE_KEY nodeKey, NODE_KEY[] parentPath, int pathStartIndex) {
        T resultNewNode;
        IBaseTreeNode<NODE_KEY, V> parentNode;
        if (nodeKey == null) {
            return null;
        }
        if ((pathStartIndex = TreeModelUtils.validatePathIndex(parentPath, pathStartIndex)) >= 0) {
            T t = this.getChildByPath(parentPath, pathStartIndex);
            parentNode = (IBaseTreeNode<NODE_KEY, V>)t;
            if (t == null && (parentNode = this.createEmptyNode(parentPath, pathStartIndex)) == null) {
                throw new IllegalArgumentException(String.format("Failed on Create Path Node=%s, pathStartIndex=%d", Arrays.deepToString(parentPath), pathStartIndex));
            }
            this.addChildNode(parentNode);
        } else {
            parentNode = null;
        }
        if (parentNode != null) {
            resultNewNode = parentNode.getChildNodeByKey(nodeKey);
            if (resultNewNode == null) {
                resultNewNode = parentNode.addChild(nodeKey);
            }
        } else {
            resultNewNode = this.getChildNodeByKey(nodeKey);
            if (resultNewNode == null && !this.addChildNode((IBaseTreeNode<NODE_KEY, V>)(resultNewNode = this.createEmptyNode(nodeKey)))) {
                throw new IllegalArgumentException(String.format("Failed on Create Node=%s, Path=%s, pathStartIndex=%d", nodeKey, Arrays.deepToString(parentPath), pathStartIndex));
            }
        }
        this.addChildNode((IBaseTreeNode<NODE_KEY, V>)resultNewNode);
        return resultNewNode;
    }

    default public <T extends IBaseTreeNode<NODE_KEY, V>> T addChild(NODE_KEY nodeKey, NODE_KEY[] parentPath) {
        return this.addChild(nodeKey, parentPath, 0);
    }

    default public <T extends IBaseTreeNode<NODE_KEY, V>> T addChild(NODE_KEY nodeKey) {
        return this.addChild(nodeKey, null, 0);
    }

    default public <T extends IBaseTreeNode<NODE_KEY, V>> T addChildByPathKey(NODE_KEY[] pathKey, int pathStartIndex) {
        T newNode = this.createEmptyNode(pathKey, pathStartIndex);
        return (T)(this.addChildNode((IBaseTreeNode<NODE_KEY, V>)newNode) ? newNode : null);
    }

    default public <T extends IBaseTreeNode<NODE_KEY, V>> T getChildByPath(NODE_KEY nodeKey, NODE_KEY[] parentPath, int pathStartIndex) {
        T childNode = this.getChildByPath(parentPath, pathStartIndex);
        return childNode != null ? (T)childNode.getNodeByKey(nodeKey, true) : null;
    }

    default public <T extends IBaseTreeNode<NODE_KEY, V>> T getChildByPath(NODE_KEY[] nodePath, int pathStartIndex) {
        if ((pathStartIndex = TreeModelUtils.validatePathIndex(nodePath, pathStartIndex)) < 0) {
            return null;
        }
        T childNode = this.getParentNodeByKey(nodePath[pathStartIndex]);
        if (childNode == null) {
            return null;
        }
        return pathStartIndex >= nodePath.length - 1 ? childNode : childNode.getChildByPath(nodePath, pathStartIndex + 1);
    }

    default public <T extends IBaseTreeNode<NODE_KEY, V>> T getChildByPath(NODE_KEY[] nodePath) {
        return this.getChildByPath(nodePath, 0);
    }

    public void dumpNode(int var1, StringBuilder var2, String var3, Integer var4, boolean var5, BiFunction<int[], V, String> var6);

    default public void dumpNode(StringBuilder output, String levelPrefix, Integer seqNo, boolean reverseMode, BiFunction<int[], V, String> dumpNodeValueFunc) {
        this.dumpNode(this.getDependencyLevel(reverseMode), output, levelPrefix, seqNo, reverseMode, dumpNodeValueFunc);
    }

    @Override
    default public void dumpNode(StringBuilder output, String levelPrefix, boolean reverseMode) {
        this.dumpNode(output, levelPrefix, null, reverseMode, null);
    }
}

