/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.common.tree.common;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.models.common.tree.IBaseTreeModel;
import kd.fi.v2.fah.models.common.tree.IBaseTreeNode;
import kd.fi.v2.fah.models.common.tree.common.AbstractCommonTreeModel;

public abstract class AbstractBaseTreeModel<NODE_KEY, V, NODE_TYPE extends IBaseTreeNode<NODE_KEY, V>>
extends AbstractCommonTreeModel<NODE_KEY, V, NODE_TYPE>
implements IBaseTreeModel<NODE_KEY, V, NODE_TYPE> {
    protected transient Map<Object, NODE_TYPE> _cache_rootFields;
    protected transient int _max_level_cache = -1;
    protected transient boolean _cache_reverseMode;

    public AbstractBaseTreeModel() {
    }

    public AbstractBaseTreeModel(NODE_KEY treeKey) {
        super(treeKey);
    }

    public Collection<NODE_TYPE> getRootNodes(boolean reverseMode) {
        if (this._cache_rootFields == null && !this.rebuildRootNodeCache(reverseMode)) {
            return Collections.emptyList();
        }
        return this._cache_rootFields.values();
    }

    @Override
    public int getMaxLevel(boolean reverseMode) {
        if (this._max_level_cache < 0 || this._cache_rootFields == null) {
            this.rebuildRootNodeCache(reverseMode);
        }
        return Math.max(this._max_level_cache, 0);
    }

    public boolean rebuildRootNodeCache(boolean reverseMode) {
        Collection<NODE_TYPE> srcRootNodes;
        this._cache_reverseMode = reverseMode;
        if (this._cache_rootFields != null) {
            this._cache_rootFields.clear();
        }
        if ((srcRootNodes = this.__getAllNodeStorage(reverseMode)) == null || srcRootNodes.isEmpty()) {
            return false;
        }
        this._max_level_cache = 0;
        LinkedList<IBaseTreeNode> _rootNodes = new LinkedList<IBaseTreeNode>();
        for (IBaseTreeNode field : srcRootNodes) {
            if (field == null || (!reverseMode ? field.hasChild() : field.hasParent())) continue;
            _rootNodes.add(field);
            int node_level = field.getMaxLevel(reverseMode);
            if (this._max_level_cache >= node_level) continue;
            this._max_level_cache = node_level;
        }
        if (this._cache_rootFields == null) {
            this._cache_rootFields = new LinkedHashMap<Object, NODE_TYPE>(_rootNodes.size());
        }
        for (IBaseTreeNode rootNode : _rootNodes) {
            this._cache_rootFields.put(this.parseNodeKey(rootNode), rootNode);
        }
        return true;
    }

    protected Collection<NODE_TYPE> __getAllNodeStorage(boolean reverseMode) {
        if (this.childNodes == null) {
            return Collections.EMPTY_LIST;
        }
        Collection nodeBufList = this.childNodes.values();
        LinkedList<IBaseTreeNode> result = new LinkedList<IBaseTreeNode>();
        while (!nodeBufList.isEmpty()) {
            LinkedList childNodeBuf = new LinkedList();
            for (IBaseTreeNode node : nodeBufList) {
                result.add(node);
                if (reverseMode) {
                    if (!node.hasParent()) continue;
                    childNodeBuf.addAll(node.getParentsCopy());
                    continue;
                }
                if (!node.hasChild()) continue;
                childNodeBuf.addAll(node.getChildCopy());
            }
            nodeBufList = childNodeBuf;
        }
        return new LinkedHashSet(result);
    }

    public boolean isEmpty() {
        return !this.hasChild();
    }

    public int size() {
        return this.childNodes != null ? this.childNodes.size() : 0;
    }

    @Override
    public void dumpNode(StringBuilder output, String levelPrefix, Integer seqNo, boolean reverseMode, BiFunction<int[], V, String> dumpNodeValueFunc) {
        if (output == null) {
            return;
        }
        if (this._cache_rootFields == null) {
            return;
        }
        int nodeIdx = 0;
        for (IBaseTreeNode node : this._cache_rootFields.values()) {
            node.dumpNode(0, output, levelPrefix, nodeIdx++, reverseMode, dumpNodeValueFunc);
        }
    }

    public Collection<NODE_TYPE>[] getLevelGrps(boolean reverseMode) {
        LinkedHashSet<Object> parentList;
        if (this.isEmpty()) {
            return null;
        }
        int maxLevel = this.getMaxLevel(reverseMode);
        Set[] result = new Set[maxLevel + 1];
        int currentLevel = 0;
        if (this._cache_rootFields == null) {
            this.getRootNodes(reverseMode);
        }
        result[currentLevel++] = parentList = new LinkedHashSet<NODE_TYPE>(this._cache_rootFields.values());
        while (currentLevel <= maxLevel) {
            LinkedHashSet<IBaseTreeNode> currentList;
            result[currentLevel] = currentList = new LinkedHashSet<IBaseTreeNode>(4);
            for (IBaseTreeNode f : parentList) {
                if (!(reverseMode ? f.hasChild() : f.hasParent())) continue;
                for (IBaseTreeNode child : reverseMode ? f.getChildCopy() : f.getParentsCopy()) {
                    if (child.getDependencyLevel(reverseMode) != currentLevel) continue;
                    currentList.add(child);
                }
            }
            parentList = currentList;
            ++currentLevel;
        }
        return result;
    }

    public Collection<NODE_TYPE>[] getNodeDependencyHierarchyGrps(boolean reverseMode) {
        LinkedHashSet<NODE_TYPE> parentList;
        if (this.isEmpty()) {
            return null;
        }
        Set[] result = new Set[this.getMaxLevel(reverseMode) + 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new LinkedHashSet(4);
        }
        if (this._cache_rootFields == null) {
            this.getRootNodes(reverseMode);
        }
        result[0] = parentList = new LinkedHashSet<NODE_TYPE>(this._cache_rootFields.values());
        for (IBaseTreeNode rootNode : parentList) {
            this.__parseNodeHierarchyDependency(rootNode, reverseMode, result, 0);
        }
        return result;
    }

    protected void __parseNodeHierarchyDependency(NODE_TYPE rootNode, boolean reverseMode, Set<NODE_TYPE>[] outputResult, int currentLevel) {
        if (rootNode == null) {
            return;
        }
        Collection dependencies = rootNode.getDependencyCopy(reverseMode);
        if (dependencies == null || dependencies.isEmpty()) {
            for (int i = currentLevel + 1; i < outputResult.length; ++i) {
                outputResult[i].add(rootNode);
            }
        } else {
            int nextLevel = currentLevel + 1;
            for (IBaseTreeNode child : dependencies) {
                if (child == null) continue;
                int cross_level_grap = child.getDependencyLevel(reverseMode) - currentLevel;
                if (cross_level_grap > 1) {
                    for (int i = 1; i < cross_level_grap; ++i) {
                        outputResult[currentLevel + i].add(rootNode);
                    }
                } else {
                    outputResult[nextLevel].add(child);
                }
                this.__parseNodeHierarchyDependency(child, reverseMode, outputResult, nextLevel);
            }
        }
    }

    public Collection<NODE_TYPE>[] getHierarchyOutputGrps(boolean reverseMode, Function<NODE_TYPE, Object> nodeUniqueKeyParserFunc) {
        Map<Object, NODE_TYPE>[] resultMaps = this.getDistinctNodeCollection(reverseMode, nodeUniqueKeyParserFunc);
        if (resultMaps == null || resultMaps.length == 0) {
            return new Collection[0];
        }
        Collection[] result = new Collection[resultMaps.length];
        int i = -1;
        for (Map<Object, NODE_TYPE> map : resultMaps) {
            ++i;
            if (map == null) continue;
            result[i] = map.values();
        }
        return result;
    }

    public Collection<NODE_TYPE>[] getHierarchyOutputGrps(boolean reverseMode) {
        return this.getHierarchyOutputGrps(reverseMode, node -> node.getKey());
    }

    protected int checkDuplicateNode(Object nodeKey, Map<Object, NODE_TYPE>[] checkTargets, int startLevelIndex) {
        if (startLevelIndex < checkTargets.length - 1) {
            for (int i = checkTargets.length - 1; i >= startLevelIndex; --i) {
                Map<Object, NODE_TYPE> targetMap = checkTargets[i];
                if (targetMap == null || targetMap.isEmpty() || !targetMap.containsKey(nodeKey)) continue;
                return i;
            }
        }
        return -1;
    }

    public Map<Object, NODE_TYPE>[] getDistinctNodeCollection(boolean reverseMode, Function<NODE_TYPE, Object> nodeUniqueKeyParserFunc) {
        if (this._cache_rootFields == null) {
            this.getRootNodes(reverseMode);
        }
        if (this._cache_rootFields == null || this._cache_rootFields.isEmpty()) {
            return new Map[0];
        }
        int maxLevel = this.getMaxLevel(reverseMode);
        Map[] outputResult = new Map[maxLevel + 1];
        Map[] duplicateOutput = new Map[maxLevel + 1];
        for (int i = 0; i < outputResult.length; ++i) {
            outputResult[i] = new LinkedHashMap(8);
        }
        LinkedList<NODE_TYPE> rootNodes = new LinkedList<NODE_TYPE>(this._cache_rootFields.values());
        for (IBaseTreeNode rootNode : rootNodes) {
            if (rootNode == null) continue;
            this.__buildDistinctNodeCollection(rootNode, reverseMode, outputResult, duplicateOutput, 0, nodeUniqueKeyParserFunc);
        }
        return outputResult;
    }

    protected void fillHierarchyLevelNodes(boolean reverseMode, List<NODE_TYPE>[] outputResult) {
        for (IBaseTreeNode rootNode : this._cache_rootFields.values()) {
            if (rootNode != null) continue;
        }
    }

    protected void __buildDistinctNodeCollection(NODE_TYPE rootNode, boolean reverseMode, Map<Object, NODE_TYPE>[] outputResult, Map<Object, PairTuple<NODE_TYPE, List<NODE_TYPE>>>[] duplicateOutput, int level, Function<NODE_TYPE, Object> nodeUniqueKeyParserFunc) {
        Object nodePathKey = nodeUniqueKeyParserFunc.apply(rootNode);
        int rootNodeLevel = rootNode.getDependencyLevel(reverseMode);
        IBaseTreeNode existingNode = (IBaseTreeNode)outputResult[rootNodeLevel].get(nodePathKey);
        if (existingNode == null) {
            outputResult[rootNodeLevel].put(nodePathKey, rootNode);
        } else if (existingNode != rootNode) {
            this.__handleDuplicateNodeOnDistinct(nodePathKey, existingNode, rootNode, reverseMode, level);
        }
        for (IBaseTreeNode child : reverseMode ? rootNode.getChildCopy() : rootNode.getParentsCopy()) {
            int cross_level_grap = child.getDependencyLevel(reverseMode) - rootNodeLevel;
            if (cross_level_grap > 1) {
                for (int leveIdx = level + 1; leveIdx < cross_level_grap; ++leveIdx) {
                    if (outputResult[leveIdx].containsKey(nodePathKey)) continue;
                    outputResult[leveIdx].put(nodePathKey, rootNode);
                }
            }
            this.__buildDistinctNodeCollection(child, reverseMode, outputResult, duplicateOutput, level + 1, nodeUniqueKeyParserFunc);
        }
    }

    protected abstract void __handleDuplicateNodeOnDistinct(Object var1, NODE_TYPE var2, NODE_TYPE var3, boolean var4, int var5);

    public void setTreeKey(NODE_KEY treeKey) {
        this.setNodeKey(treeKey);
    }

    @Override
    public boolean addChildNode(NODE_TYPE child) {
        if (child == null) {
            return false;
        }
        if (this.childNodes == null) {
            this.childNodes = new LinkedHashMap(2);
        }
        this.childNodes.put(this.parseNodeKey(child), child);
        return true;
    }

    @Override
    public NODE_TYPE getNodeByKey(NODE_KEY nodeKey, boolean childOrParent) {
        return (NODE_TYPE)(this.hasChild() ? (IBaseTreeNode)this.childNodes.get(nodeKey) : null);
    }

    @Override
    public boolean containNodeKey(NODE_KEY nodeKey) {
        return this.hasChild() ? this.childNodes.containsKey(nodeKey) : false;
    }

    @Override
    protected Map<Object, NODE_TYPE> getNodeMap(boolean reverseMode) {
        return this.childNodes;
    }
}

