/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.common.tree.common;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import kd.fi.v2.fah.models.common.tree.IBaseTreeNode;
import kd.fi.v2.fah.models.common.tree.common.AbstractCommonTreeModel;

public abstract class AbstractBaseTreeNode<NODE_KEY, V, NODE_TYPE extends IBaseTreeNode<NODE_KEY, V>>
extends AbstractCommonTreeModel<NODE_KEY, V, NODE_TYPE>
implements IBaseTreeNode<NODE_KEY, V> {
    protected V nodeValues;
    protected transient Map<Object, NODE_TYPE> parentNodes;

    public AbstractBaseTreeNode() {
    }

    public AbstractBaseTreeNode(NODE_KEY nodeKey) {
        super(nodeKey);
    }

    public AbstractBaseTreeNode(NODE_KEY nodeKey, V nodeValues) {
        super(nodeKey);
        this.nodeValues = nodeValues;
    }

    public String toString() {
        StringBuilder parentKeys = new StringBuilder();
        if (this.parentNodes != null) {
            for (IBaseTreeNode node : this.parentNodes.values()) {
                parentKeys.append(node.getKey()).append(',');
            }
        }
        return "AbstractBaseTreeNode={nodeKey=" + this.key + ", nodeValues=" + this.nodeValues + ", parents=" + parentKeys + ", childFields=" + this.childNodes + '}';
    }

    @Override
    public <T extends IBaseTreeNode<NODE_KEY, V>> T getNodeByKey(NODE_KEY nodeKey, boolean childOrParent) {
        if (childOrParent) {
            return (T)(this.hasChild() ? (IBaseTreeNode)this.childNodes.get(nodeKey) : null);
        }
        return (T)(this.hasParent() ? (IBaseTreeNode)this.parentNodes.get(nodeKey) : null);
    }

    @Override
    public boolean containNodeKey(NODE_KEY nodeKey, boolean childOrParent) {
        if (childOrParent) {
            return this.hasChild() ? this.childNodes.containsKey(nodeKey) : false;
        }
        return this.hasParent() ? this.parentNodes.containsKey(nodeKey) : false;
    }

    @Override
    public int getDefaultNodePathType() {
        return 0;
    }

    @Override
    protected Object parseNodeKey(IBaseTreeNode<NODE_KEY, V> srcNode) {
        return srcNode == null ? null : srcNode.getItemKey();
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean hasParent() {
        return this.parentNodes != null && !this.parentNodes.isEmpty();
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean hasChild() {
        return this.childNodes != null && !this.childNodes.isEmpty();
    }

    @Override
    public int getMaxLevel(boolean reverseMode) {
        int result = 0;
        Map<Object, NODE_TYPE> travelMap = this.getNodeMap(reverseMode);
        if (travelMap != null && !travelMap.isEmpty()) {
            for (IBaseTreeNode child : travelMap.values()) {
                int childLevel;
                if (child == null || result >= (childLevel = child.getMaxLevel(reverseMode) + 1)) continue;
                result = childLevel;
            }
        }
        return result;
    }

    @Override
    public boolean doNodeMerge(IBaseTreeNode<NODE_KEY, V> target) {
        Collection mergeNodeList;
        if (target == null) {
            return true;
        }
        if (target.hasParent()) {
            mergeNodeList = target.getParentsCopy();
            if (this.parentNodes == null) {
                this.parentNodes = new LinkedHashMap<Object, NODE_TYPE>(mergeNodeList.size());
            }
            for (IBaseTreeNode p : mergeNodeList) {
                this.parentNodes.put(this.parseNodeKey(p), p);
            }
        }
        if (target.hasChild()) {
            mergeNodeList = target.getChildCopy();
            if (this.childNodes == null) {
                this.childNodes = new LinkedHashMap(mergeNodeList.size());
            }
            for (IBaseTreeNode p : target.getChildCopy()) {
                this.childNodes.put(this.parseNodeKey(p), p);
            }
        }
        return this.doCustomeMerge(target);
    }

    @Override
    public Collection<Object> getNodePath(boolean reverseMode, boolean includeSelfNode, Function<AbstractBaseTreeNode, Object> nodePathKeyBuilderFunc) {
        LinkedList<Object> pathKeyList = new LinkedList<Object>();
        if (reverseMode && this.parentNodes != null) {
            for (IBaseTreeNode parent : this.parentNodes.values()) {
                pathKeyList.add(parent.getNodePath(true, true, nodePathKeyBuilderFunc));
            }
        }
        if (includeSelfNode) {
            this.buildCustomNodePathKey(pathKeyList, nodePathKeyBuilderFunc);
        }
        if (!reverseMode && this.childNodes != null) {
            for (IBaseTreeNode child : this.childNodes.values()) {
                pathKeyList.add(child.getNodePath(false, true, nodePathKeyBuilderFunc));
            }
        }
        return pathKeyList;
    }

    public Collection<Object> getNodePath(boolean reverseMode, boolean includeSelfNode) {
        return this.getNodePath(reverseMode, includeSelfNode, null);
    }

    protected void buildCustomNodePathKey(List<Object> outputPathKey, Function<AbstractBaseTreeNode, Object> nodePathKeyBuilderFunc) {
        if (nodePathKeyBuilderFunc != null) {
            outputPathKey.add(nodePathKeyBuilderFunc.apply(this));
        } else {
            outputPathKey.add(this.key);
        }
    }

    @Override
    protected boolean doCustomeMerge(IBaseTreeNode<NODE_KEY, V> target) {
        return true;
    }

    @Override
    public boolean addParentNode(IBaseTreeNode<NODE_KEY, V> parent) {
        if (parent == null) {
            return false;
        }
        if (this.parentNodes == null) {
            this.parentNodes = new LinkedHashMap<Object, NODE_TYPE>(2);
        }
        this.parentNodes.put(this.parseNodeKey(parent), parent);
        return true;
    }

    @Override
    public boolean addChildNode(IBaseTreeNode<NODE_KEY, V> child) {
        if (child == null) {
            return false;
        }
        if (this.childNodes == null) {
            this.childNodes = new LinkedHashMap(2);
        }
        this.childNodes.put(this.parseNodeKey(child), child);
        child.addParentNode(this);
        return true;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public Collection<IBaseTreeNode<NODE_KEY, V>> getParentsCopy() {
        return this.getNodeCopy(this.parentNodes);
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public Collection<IBaseTreeNode<NODE_KEY, V>> getChildCopy() {
        return this.getNodeCopy(this.childNodes);
    }

    @Override
    public boolean hasDependencyCopy(boolean reverseMode) {
        return reverseMode ? this.childNodes != null && !this.childNodes.isEmpty() : this.parentNodes != null && !this.parentNodes.isEmpty();
    }

    @Override
    protected Map<Object, NODE_TYPE> getNodeMap(boolean reverseMode) {
        return reverseMode ? (this.childNodes != null ? this.childNodes : Collections.emptyMap()) : (this.parentNodes != null ? this.parentNodes : Collections.emptyMap());
    }

    @Override
    protected void dumpNodeValue(StringBuilder output, int level, Integer seqNo, boolean reverseMode, BiFunction<int[], V, String> dumpNodeValueFunc) {
        if (dumpNodeValueFunc != null) {
            output.append(dumpNodeValueFunc.apply(new int[]{level, seqNo}, this.nodeValues));
        } else {
            output.append(this.key).append(" (Level=").append(level).append(", MaxLevel=").append(this.getMaxLevel(reverseMode)).append(", DependencyLevel=").append(this.getDependencyLevel(reverseMode)).append(')');
        }
    }

    public Map<Object, NODE_TYPE> getParentNodes() {
        return this.parentNodes;
    }

    @Override
    public V getNodeValues() {
        return this.nodeValues;
    }

    @Override
    public void setNodeValues(V nodeValues) {
        this.nodeValues = nodeValues;
    }
}

