/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.context;

import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.enums.StatusEnum;
import kd.fi.v2.fah.models.context.DuplicateTargetV2;
import kd.fi.v2.fah.models.context.ValueSetDuplicateCheckResultV2;
import kd.fi.v2.fah.models.mapping.IMapInput;
import kd.fi.v2.fah.models.valueset.IDataValueSet;

public class DuplicateMappingCheckerContextV2 {
    private int serialNumber;
    private final Map<Integer, ValueSetDuplicateCheckResultV2> resultMap;
    private final Map<Integer, PairTuple<Date, Date>> toBeCheckRowsMap;
    private final Map<Object, List<Integer>>[] _columnCheckMaps;
    private final int _columnCnt;
    private static final Object EmptyObjectRef = new Object();

    public DuplicateMappingCheckerContextV2(int columnCnt) {
        if (columnCnt <= 0) {
            throw new IllegalArgumentException("Column Count cannot less than zero!");
        }
        this._columnCnt = columnCnt;
        this._columnCheckMaps = new Map[this._columnCnt];
        for (int i = 0; i < this._columnCnt; ++i) {
            this._columnCheckMaps[i] = new HashMap<Object, List<Integer>>(16);
        }
        this.toBeCheckRowsMap = new LinkedHashMap<Integer, PairTuple<Date, Date>>(64);
        this.resultMap = new HashMap<Integer, ValueSetDuplicateCheckResultV2>(1024);
    }

    public Map<Long, ValueSetDuplicateCheckResultV2> getDuplicateResultMap() {
        HashMap<Long, ValueSetDuplicateCheckResultV2> duplicateResultMap = new HashMap<Long, ValueSetDuplicateCheckResultV2>(8);
        for (ValueSetDuplicateCheckResultV2 result : this.resultMap.values()) {
            if (!result.hasDuplicate()) continue;
            Long mapDataId = result.getItemKey();
            duplicateResultMap.put(mapDataId, result);
        }
        return duplicateResultMap;
    }

    public void addAndCheckSingleValue(IDataValueSet<Long> checkTargetValueSet) {
        ValueSetDuplicateCheckResultV2 outputResultBuffer = this.checkValue(checkTargetValueSet, false);
        this.resultMap.put(checkTargetValueSet.getSerialNumber(), outputResultBuffer);
        this.addToBeCheckValue(checkTargetValueSet);
    }

    private void addToBeCheckValue(IDataValueSet<Long> checkTargetValueSet) {
        this.toBeCheckRowsMap.put(checkTargetValueSet.getSerialNumber(), (PairTuple<Date, Date>)new PairTuple((Object)checkTargetValueSet.getEffectDate(), (Object)checkTargetValueSet.getExpireDate()));
        this.serialNumber = checkTargetValueSet.getSerialNumber();
    }

    public void checkSingleFromDBValue(IMapInput checkTargetValueSet) {
        if (checkTargetValueSet.getSerialNumber() <= this.serialNumber && StatusEnum.UNPUBLISHED.getCode().equals(checkTargetValueSet.getStatus())) {
            return;
        }
        ValueSetDuplicateCheckResultV2 outputResultBuffer = this.checkValue(checkTargetValueSet, true);
        if (outputResultBuffer.hasDuplicate()) {
            this.updateResultMap(outputResultBuffer);
        }
    }

    private void updateResultMap(ValueSetDuplicateCheckResultV2 dbDataDuplicateResult) {
        Map<Integer, DuplicateTargetV2> duplicateTargets = dbDataDuplicateResult.getDuplicateTargets();
        for (Map.Entry<Integer, DuplicateTargetV2> entry : duplicateTargets.entrySet()) {
            Integer targetSerialNumber = entry.getKey();
            DuplicateTargetV2 target = entry.getValue();
            DuplicateTargetV2 dbTarget = target.transToDbTarget(dbDataDuplicateResult.getSrcSerialNumber());
            ValueSetDuplicateCheckResultV2 duplicateCheckResult = this.resultMap.get(targetSerialNumber);
            duplicateCheckResult.addDBDuplicateTarget(dbTarget);
        }
    }

    protected ValueSetDuplicateCheckResultV2 checkValue(IDataValueSet<Long> checkTargetValueSet, boolean fromDB) {
        boolean needCheckDateRange = checkTargetValueSet.hasValidDateRange();
        Date startDate = checkTargetValueSet.getEffectDate();
        Date endDate = checkTargetValueSet.getExpireDate();
        boolean hasMultiValue = checkTargetValueSet.hasHasMulValue();
        ValueSetDuplicateCheckResultV2 outputResultBuffer = new ValueSetDuplicateCheckResultV2((Long)checkTargetValueSet.getItemKey(), checkTargetValueSet.getSerialNumber(), this._columnCnt);
        BitSet columnCheckBitSet = outputResultBuffer.getColumnCheckBitSetBuffer();
        BitSet duplicateRowBitSetBuffer = outputResultBuffer.getDuplicateRowBitSetBuffer();
        for (int colIndex = 0; colIndex < this._columnCnt; ++colIndex) {
            Map<Object, List<Integer>> columnMap = this._columnCheckMaps[colIndex];
            Object columnValueBuf = Optional.of(checkTargetValueSet.get(colIndex)).orElse(EmptyObjectRef);
            List<Object> multiValues = hasMultiValue ? (List<Object>)columnValueBuf : Collections.singletonList(columnValueBuf);
            columnCheckBitSet.clear();
            this.checkColumn(checkTargetValueSet.getSerialNumber(), colIndex, columnMap, multiValues, columnCheckBitSet, needCheckDateRange, startDate, endDate, fromDB, outputResultBuffer);
            if (colIndex == 0) {
                duplicateRowBitSetBuffer.or(columnCheckBitSet);
                continue;
            }
            duplicateRowBitSetBuffer.and(columnCheckBitSet);
        }
        outputResultBuffer.clearNotDuplicateRows();
        return outputResultBuffer;
    }

    private void checkColumn(int serialNumber, int currentCheckColumnIndex, Map<Object, List<Integer>> columnMap, Collection<Object> multiValues, BitSet columnCheckBitSet, boolean needCheckDateRange, Date startDate, Date endDate, boolean fromDB, ValueSetDuplicateCheckResultV2 outputResultBuffer) {
        for (Object value : multiValues) {
            List refSerialNumberList;
            List list = refSerialNumberList = fromDB ? columnMap.get(value) : columnMap.computeIfAbsent(value, k -> new LinkedList());
            if (refSerialNumberList == null) continue;
            for (Integer duplicateSerialNumber : refSerialNumberList) {
                PairTuple<Date, Date> datePairTuple = this.toBeCheckRowsMap.get(duplicateSerialNumber);
                if (needCheckDateRange) {
                    if (DuplicateMappingCheckerContextV2.isOverlapDateRange(startDate, endDate, (Date)datePairTuple.getKey(), (Date)datePairTuple.getValue())) {
                        columnCheckBitSet.set(duplicateSerialNumber);
                    }
                } else {
                    columnCheckBitSet.set(duplicateSerialNumber);
                }
                outputResultBuffer.addDuplicateTarget(duplicateSerialNumber, fromDB, currentCheckColumnIndex, value, (Date)datePairTuple.getKey(), (Date)datePairTuple.getValue());
            }
            if (fromDB) continue;
            refSerialNumberList.add(serialNumber);
        }
    }

    public static boolean isOverlapDateRange(Date startDate1, Date endDate1, Date startDate2, Date endDate2) {
        long end2;
        long start1 = startDate1 == null ? 0L : startDate1.getTime();
        long end1 = endDate1 == null ? Long.MAX_VALUE : endDate1.getTime();
        long start2 = startDate2 == null ? 0L : startDate2.getTime();
        long l = end2 = endDate2 == null ? Long.MAX_VALUE : endDate2.getTime();
        if (start1 >= end1 || start2 >= end2) {
            throw new IllegalArgumentException(String.format("Invalid Date Range: [%s ~ %s] vs [%s ~ %s]", startDate1, endDate1, startDate2, endDate2));
        }
        return start1 < end2 && start2 < end1;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }
}

