/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.context;

import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import kd.fi.v2.fah.storage.IDataItemKey;

public class DuplicateTargetV2
implements IDataItemKey<Integer> {
    Integer targetSerialNumber;
    boolean fromDB;
    Date effectDate;
    Date expireDate;
    List<Object>[] duplicateValues;

    public DuplicateTargetV2(int serialNumber, boolean fromDB, int checkColumnCnt) {
        this.reset(serialNumber, fromDB, checkColumnCnt);
    }

    private DuplicateTargetV2() {
    }

    public String toString() {
        return "DuplicateTarget{targetSerialNumber=" + this.targetSerialNumber + ", fromDB=" + this.fromDB + ", duplicateValues=" + Arrays.toString(this.duplicateValues) + '}';
    }

    public DuplicateTargetV2 addDuplicateColumn(int columnIndex, Object duplicateValue) {
        List<Object> valList = this.duplicateValues[columnIndex];
        if (valList == null) {
            this.duplicateValues[columnIndex] = new LinkedList<Object>();
            this.duplicateValues[columnIndex].add(duplicateValue);
        } else {
            valList.add(duplicateValue);
        }
        return this;
    }

    public void forEachDuplicateColumn(BiConsumer<Integer, List<Object>> consumer) {
        for (int columnIndex = 0; columnIndex < this.duplicateValues.length; ++columnIndex) {
            consumer.accept(columnIndex, this.duplicateValues[columnIndex]);
        }
    }

    public List<Object>[] getDuplicateValues() {
        return this.duplicateValues;
    }

    public Integer getTargetSerialNumber() {
        return this.targetSerialNumber;
    }

    public void reset(Integer targetSerialNumber, boolean fromDB, int checkColumnCnt) {
        this.targetSerialNumber = targetSerialNumber;
        this.fromDB = fromDB;
        this.effectDate = null;
        this.expireDate = null;
        if (this.duplicateValues != null && checkColumnCnt == this.duplicateValues.length) {
            for (int i = 0; i < checkColumnCnt; ++i) {
                this.duplicateValues[i].clear();
            }
        } else {
            this.duplicateValues = new List[checkColumnCnt];
        }
    }

    @Override
    public Integer getItemKey() {
        return this.targetSerialNumber;
    }

    public DuplicateTargetV2 transToDbTarget(Integer targetSerialNumber) {
        DuplicateTargetV2 dbTarget = new DuplicateTargetV2();
        dbTarget.targetSerialNumber = targetSerialNumber;
        dbTarget.fromDB = true;
        dbTarget.duplicateValues = this.duplicateValues;
        dbTarget.effectDate = this.effectDate;
        dbTarget.expireDate = this.expireDate;
        return dbTarget;
    }

    public Date getEffectDate() {
        return this.effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(Date expireDate) {
        this.expireDate = expireDate;
    }

    protected void setDates(Date effectDate, Date expireDate) {
        this.expireDate = expireDate;
        this.effectDate = effectDate;
    }
}

