/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.context;

import java.io.Serializable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import kd.fi.v2.fah.models.context.DuplicateTarget;
import kd.fi.v2.fah.models.valueset.IDataValueSet;
import kd.fi.v2.fah.storage.IDataItemKey;

public class ValueSetDuplicateCheckResult
implements IDataItemKey<Object> {
    int innerRowId;
    Object rowID;
    IDataValueSet sourceData;
    int checkColumnCnt;
    Map<Object, DuplicateTarget> duplicateTargets;
    transient BitSet columnCheckBitSetBuffer;
    BitSet duplicateRowBitSetBuffer;

    public ValueSetDuplicateCheckResult(Object rowID, IDataValueSet sourceData, int checkColumnCnt) {
        this.rowID = rowID;
        this.sourceData = sourceData;
        this.checkColumnCnt = checkColumnCnt;
        this.duplicateTargets = new HashMap<Object, DuplicateTarget>(4);
        this.duplicateRowBitSetBuffer = new BitSet(0);
        this.columnCheckBitSetBuffer = new BitSet(0);
    }

    public int getInnerRowId() {
        return this.innerRowId;
    }

    public void setInnerRowId(int innerRowId) {
        this.innerRowId = innerRowId;
    }

    @Override
    public Object getItemKey() {
        return this.rowID;
    }

    public boolean hasDuplicate() {
        return !this.duplicateRowBitSetBuffer.isEmpty() || !this.duplicateTargets.isEmpty();
    }

    public String toString() {
        return "ValueSetDuplicateCheckResult{innerRowId=" + this.innerRowId + ", rowID=" + this.rowID + ", checkColumnCnt=" + this.checkColumnCnt + ", duplicateTargets=" + this.duplicateTargets + ", columnCheckBitSetBuffer=" + this.columnCheckBitSetBuffer.isEmpty() + ", duplicateRowBitSetBuffer=" + this.duplicateRowBitSetBuffer.isEmpty() + '}';
    }

    public void addDuplicateTarget(Serializable targetRowID, boolean fromDB, IDataValueSet duplicateTarget, int duplicateColumnIndex, Object duplicateValue) {
        this.duplicateTargets.computeIfAbsent(targetRowID, v -> new DuplicateTarget(targetRowID, fromDB, duplicateTarget, this.checkColumnCnt)).addDuplicateColumn(duplicateColumnIndex, duplicateValue);
    }

    public void addDuplicateTarget(Serializable targetRowID, boolean fromDB, int duplicateColumnIndex, Object duplicateValue) {
        this.addDuplicateTarget(targetRowID, fromDB, null, duplicateColumnIndex, duplicateValue);
    }

    public void addDuplicateTarget(Serializable targetRowID, boolean fromDB) {
        this.duplicateTargets.computeIfAbsent(targetRowID, v -> new DuplicateTarget(targetRowID, fromDB, null, this.checkColumnCnt));
    }

    public boolean clearNotDuplicateRows() {
        if (this.duplicateRowBitSetBuffer.isEmpty()) {
            this.duplicateTargets.clear();
        }
        int rowIndex = -1;
        LinkedList<Integer> rowIds = new LinkedList<Integer>();
        while ((rowIndex = this.duplicateRowBitSetBuffer.nextSetBit(rowIndex + 1)) >= 0) {
            rowIds.add(rowIndex);
        }
        HashMap<Object, DuplicateTarget> _keepRows = new HashMap<Object, DuplicateTarget>(rowIds.size());
        for (Integer rowId : rowIds) {
            _keepRows.put(rowId, this.duplicateTargets.get(rowId));
        }
        this.duplicateTargets = _keepRows;
        return !this.duplicateTargets.isEmpty();
    }

    public void clear() {
        this.duplicateTargets.clear();
        this.columnCheckBitSetBuffer.clear();
        this.duplicateRowBitSetBuffer.clear();
    }

    public void reset(Serializable rowID, IDataValueSet sourceData, int checkColumnCnt) {
        this.rowID = rowID;
        this.sourceData = sourceData;
        this.checkColumnCnt = checkColumnCnt;
        this.duplicateTargets.clear();
    }

    public Object getRowID() {
        return this.rowID;
    }

    public void setRowID(Object rowID) {
        this.rowID = rowID;
    }

    public IDataValueSet getSourceData() {
        return this.sourceData;
    }

    public void setSourceData(IDataValueSet sourceData) {
        this.sourceData = sourceData;
    }

    public int getCheckColumnCnt() {
        return this.checkColumnCnt;
    }

    public void setCheckColumnCnt(int checkColumnCnt) {
        this.checkColumnCnt = checkColumnCnt;
    }

    public BitSet getColumnCheckBitSetBuffer() {
        return this.columnCheckBitSetBuffer;
    }

    public BitSet getDuplicateRowBitSetBuffer() {
        return this.duplicateRowBitSetBuffer;
    }

    public Map<Object, DuplicateTarget> getDuplicateTargets() {
        return this.duplicateTargets;
    }
}

