/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.context;

import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import kd.fi.v2.fah.models.context.DuplicateTargetV2;
import kd.fi.v2.fah.models.valueset.IDataValueSet;
import kd.fi.v2.fah.storage.IDataItemKey;

public class ValueSetDuplicateCheckResultV2
implements IDataItemKey<Long> {
    private Long srcId;
    private int srcSerialNumber;
    private int checkColumnCnt;
    private Map<Integer, DuplicateTargetV2> duplicateTargets;
    transient BitSet columnCheckBitSetBuffer;
    private final BitSet duplicateRowBitSetBuffer;

    public ValueSetDuplicateCheckResultV2(Long srcId, int serialNumber, int checkColumnCnt) {
        this.srcId = srcId;
        this.srcSerialNumber = serialNumber;
        this.checkColumnCnt = checkColumnCnt;
        this.duplicateTargets = new HashMap<Integer, DuplicateTargetV2>(4);
        this.duplicateRowBitSetBuffer = new BitSet(0);
        this.columnCheckBitSetBuffer = new BitSet(0);
    }

    public int getSrcSerialNumber() {
        return this.srcSerialNumber;
    }

    public void setSrcSerialNumber(int srcSerialNumber) {
        this.srcSerialNumber = srcSerialNumber;
    }

    @Override
    public Long getItemKey() {
        return this.srcId;
    }

    public boolean hasDuplicate() {
        return !this.duplicateRowBitSetBuffer.isEmpty() || !this.duplicateTargets.isEmpty();
    }

    public String toString() {
        return "ValueSetDuplicateCheckResult{, srcId=" + this.srcId + "srcSerialNumber=" + this.srcSerialNumber + ", checkColumnCnt=" + this.checkColumnCnt + ", duplicateTargets=" + this.duplicateTargets + ", columnCheckBitSetBuffer=" + this.columnCheckBitSetBuffer + ", duplicateRowBitSetBuffer=" + this.duplicateRowBitSetBuffer + '}';
    }

    public void addDuplicateTarget(int targetSerialNumber, boolean fromDB, int duplicateColumnIndex, Object duplicateValue, Date effectDate, Date expireDate) {
        this.duplicateTargets.computeIfAbsent(targetSerialNumber, v -> new DuplicateTargetV2(targetSerialNumber, fromDB, this.checkColumnCnt)).addDuplicateColumn(duplicateColumnIndex, duplicateValue).setDates(effectDate, expireDate);
    }

    public boolean clearNotDuplicateRows() {
        if (this.duplicateRowBitSetBuffer.isEmpty()) {
            this.duplicateTargets.clear();
        }
        int rowIndex = -1;
        LinkedList<Integer> rowIds = new LinkedList<Integer>();
        while ((rowIndex = this.duplicateRowBitSetBuffer.nextSetBit(rowIndex + 1)) >= 0) {
            rowIds.add(rowIndex);
        }
        HashMap<Integer, DuplicateTargetV2> _keepRows = new HashMap<Integer, DuplicateTargetV2>(rowIds.size());
        for (Integer rowId : rowIds) {
            _keepRows.put(rowId, this.duplicateTargets.get(rowId));
        }
        this.duplicateTargets = _keepRows;
        return !this.duplicateTargets.isEmpty();
    }

    public void clear() {
        this.duplicateTargets.clear();
        this.columnCheckBitSetBuffer.clear();
        this.duplicateRowBitSetBuffer.clear();
    }

    public void reset(Long id, IDataValueSet sourceData, int checkColumnCnt) {
        this.srcId = id;
        this.checkColumnCnt = checkColumnCnt;
        this.duplicateTargets.clear();
    }

    public int getCheckColumnCnt() {
        return this.checkColumnCnt;
    }

    public void setCheckColumnCnt(int checkColumnCnt) {
        this.checkColumnCnt = checkColumnCnt;
    }

    public BitSet getColumnCheckBitSetBuffer() {
        return this.columnCheckBitSetBuffer;
    }

    public BitSet getDuplicateRowBitSetBuffer() {
        return this.duplicateRowBitSetBuffer;
    }

    public Map<Integer, DuplicateTargetV2> getDuplicateTargets() {
        return this.duplicateTargets;
    }

    public void setDuplicateTargets(Map<Integer, DuplicateTargetV2> duplicateTargets) {
        this.duplicateTargets = duplicateTargets;
    }

    public void addDBDuplicateTarget(DuplicateTargetV2 dbTarget) {
        this.duplicateTargets.put(dbTarget.targetSerialNumber, dbTarget);
    }
}

