/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.dynamic;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Objects;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IMetadata;
import kd.fi.v2.fah.models.common.BitStatusSwitchFactory;
import kd.fi.v2.fah.models.common.IBitStatusSwitch;

public class SimpleDynamicMetadata
implements IMetadata,
Serializable {
    private static final long serialVersionUID = -1L;
    protected IBitStatusSwitch baseConfig = BitStatusSwitchFactory.createDefaultSwitch();
    protected String name;
    protected String alias = "";
    protected LocaleString displayName;

    protected SimpleDynamicMetadata() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SimpleDynamicMetadata that = (SimpleDynamicMetadata)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name);
    }

    public String toString() {
        return "SimpleDynamicMetadata{name='" + this.name + '\'' + ", alias='" + this.alias + '\'' + ", displayName=" + this.displayName + '}';
    }

    public boolean getConfigFlag(BaseConfigFlag flag) {
        if (flag == null) {
            throw new IllegalArgumentException("Config Flag cannot be null!");
        }
        return this.baseConfig.isSwitchOn(flag.bitPos);
    }

    public boolean setConfigFlag(BaseConfigFlag flag, boolean value) {
        if (flag == null) {
            return false;
        }
        return this.baseConfig.setSwitch(flag.bitPos, value);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public LocaleString getDisplayName() {
        return this.displayName;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getAlias() {
        return this.alias;
    }

    public boolean isDbIgnore() {
        return this.getConfigFlag(BaseConfigFlag.IsDbIgnore);
    }

    public Object clone() throws CloneNotSupportedException {
        throw new RuntimeException("Not Support yet!");
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setDisplayName(LocaleString displayName) {
        this.displayName = displayName;
    }

    public Serializable getBaseConfig() {
        return this.baseConfig.getSwitchValue();
    }

    public void setBaseConfig(IBitStatusSwitch baseConfig) {
        this.baseConfig = baseConfig;
    }

    public static enum BaseConfigFlag {
        HasAlias(0),
        HasDefaultValue(1),
        RequiredLength(2),
        IsDbIgnore(3),
        IsRequired(4),
        IsReadOnly(5),
        IsPrimaryKey(6),
        IsBaseData(7);

        int bitPos;

        private BaseConfigFlag(int pos) {
            this.bitPos = pos;
        }
    }
}

