/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.mapping;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.fi.v2.fah.constant.enums.StatusEnum;
import kd.fi.v2.fah.dao.DaoFactory;
import kd.fi.v2.fah.dao.flex.MappingOutValueDaoImpl;
import kd.fi.v2.fah.dao.flex.MappingValueDao;
import kd.fi.v2.fah.models.flex.FlexFieldCfg;
import kd.fi.v2.fah.models.flex.FlexFieldGrpCfg;
import kd.fi.v2.fah.models.mapping.MappingMetaCache;
import kd.fi.v2.fah.models.mapping.MappingOutputValueSet;
import kd.fi.v2.fah.models.mapping.impl.ArrayDataValueSetImpl;
import kd.fi.v2.fah.models.mapping.impl.MappingStructureMeta;
import kd.fi.v2.fah.models.valueset.IValueSetMeta;

public class MappingDataCache {
    public static Map<Long, List<ArrayDataValueSetImpl<Object>>> getMappingInCache(Long mappingType) {
        Map mappingInCache = (Map)ThreadCache.get((Object)"MappingDataCache.getMappingInCache", HashMap::new);
        return mappingInCache.computeIfAbsent(mappingType, k -> MappingDataCache.getAllMappingInByType(mappingType));
    }

    public static Map<Long, Map<Integer, MappingOutputValueSet>> getMappingOutCache(Long mappingType) {
        Map mappingOutCache = (Map)ThreadCache.get((Object)"MappingDataCache.getMappingOutCache", HashMap::new);
        return mappingOutCache.computeIfAbsent(mappingType, k -> MappingDataCache.getAllMappingOutByType(mappingType));
    }

    private static Map<Long, List<ArrayDataValueSetImpl<Object>>> getAllMappingInByType(Long mapTypeId) {
        return MappingDataCache.getMappingIn(mapTypeId, inputParamMeta -> {
            MappingValueDao instance = DaoFactory.getInstance(MappingValueDao.class);
            return instance.queryAllMappingSingleValues(mapTypeId, (IValueSetMeta)inputParamMeta, StatusEnum.PUBLISHED.getCode());
        });
    }

    private static boolean checkMapTypeEnable(Long mappingType) {
        MappingValueDao instance = DaoFactory.getInstance(MappingValueDao.class);
        try (DataSet mapTypeDataSet = instance.queryMapType(mappingType);){
            if (mapTypeDataSet == null) {
                boolean bl = false;
                return bl;
            }
            if (mapTypeDataSet.hasNext()) {
                Row row = mapTypeDataSet.next();
                boolean bl = row.getBoolean("fenable");
                return bl;
            }
        }
        return false;
    }

    private static Map<Long, Map<Integer, MappingOutputValueSet>> getAllMappingOutByType(Long mapTypeId) {
        return MappingDataCache.getMappingOut(null, null, mapTypeId, null);
    }

    public static Map<Long, Map<Integer, MappingOutputValueSet>> getMappingOutByDB(Integer outValueSetSN, Long outValueSetOrg, Long mapTypeId, Long mapTypeOrgId) {
        return MappingDataCache.getMappingOut(outValueSetSN, outValueSetOrg, mapTypeId, mapTypeOrgId);
    }

    private static Map<Long, Map<Integer, MappingOutputValueSet>> getMappingOut(Integer outValueSetSN, Long outValueSetOrg, Long mapTypeId, Long mapTypeOrgId) {
        MappingStructureMeta mappingStructureMeta = MappingMetaCache.getMappingMetaCached(mapTypeId, new Object[0]);
        FlexFieldGrpCfg outputParamMeta = mappingStructureMeta.getOutputParamMeta();
        LinkedList<String> outFields = new LinkedList<String>();
        for (FlexFieldCfg flexFieldCfg : outputParamMeta) {
            outFields.add(flexFieldCfg.getDbFieldNum());
        }
        HashMap<Long, Map<Integer, MappingOutputValueSet>> mappingOutMap = new HashMap<Long, Map<Integer, MappingOutputValueSet>>(8);
        try (DataSet dataSet = new MappingOutValueDaoImpl().queryMappingOutValues(mapTypeId, outFields, outValueSetSN, new HashSet<Long>(Arrays.asList(outValueSetOrg, mapTypeOrgId)));){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Object[] outValues = new Object[outFields.size()];
                int index = 0;
                for (String field : outFields) {
                    outValues[index++] = row.get(field);
                }
                MappingOutputValueSet outValueSet = new MappingOutputValueSet();
                outValueSet.setMeta(outputParamMeta);
                outValueSet.setId(row.getLong("fid"));
                outValueSet.setOrgGroupId(row.getLong("fgroupid"));
                outValueSet.setOwnOrgId(row.getLong("fownorgid"));
                outValueSet.setValues(outValues);
                mappingOutMap.computeIfAbsent(row.getLong("fgroupid"), k -> new HashMap(8)).put(row.getInteger("fserialnumber"), outValueSet);
            }
        }
        return mappingOutMap;
    }

    public static Map<Long, List<ArrayDataValueSetImpl<Object>>> getMappingInByDB(Long mapTypeId, Long hashCode) {
        return MappingDataCache.getMappingIn(mapTypeId, inputParamMeta -> {
            MappingValueDao instance = DaoFactory.getInstance(MappingValueDao.class);
            return instance.queryMappingSingleValues(mapTypeId, (IValueSetMeta)inputParamMeta, StatusEnum.PUBLISHED.getCode(), hashCode);
        });
    }

    public static Map<Long, List<ArrayDataValueSetImpl<Object>>> getMappingIn(Long mapTypeId, Function<FlexFieldGrpCfg, DataSet> queryFunction) {
        HashMap<Long, List<ArrayDataValueSetImpl<Object>>> mappingInMap = new HashMap<Long, List<ArrayDataValueSetImpl<Object>>>(8);
        boolean mapTypeEnable = MappingDataCache.checkMapTypeEnable(mapTypeId);
        if (!mapTypeEnable) {
            return mappingInMap;
        }
        MappingStructureMeta mappingStructureMeta = MappingMetaCache.getMappingMetaCached(mapTypeId, new Object[0]);
        FlexFieldGrpCfg inputParamMeta = mappingStructureMeta.getInputParamMeta();
        LinkedList<String> inFields = new LinkedList<String>();
        for (FlexFieldCfg flexFieldCfg : inputParamMeta) {
            inFields.add(flexFieldCfg.getDbFieldNum());
        }
        try (DataSet dataSet = queryFunction.apply(inputParamMeta);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Object[] inValues = new Object[inFields.size()];
                int index = 0;
                for (String field : inFields) {
                    inValues[index++] = row.get(field);
                }
                ArrayDataValueSetImpl<Object> inValueSet = new ArrayDataValueSetImpl<Object>();
                inValueSet.setOrgGroupId(row.getLong("fgroupid"));
                inValueSet.setOwnOrgId(row.getLong("fownorgid"));
                inValueSet.setMeta(inputParamMeta);
                inValueSet.setValues(inValues);
                inValueSet.setId(row.getLong("fid"));
                inValueSet.setSerialNumber(row.getInteger("fserialnumber"));
                inValueSet.setEffectDate(row.getDate("feffectdate"));
                inValueSet.setExpireDate(row.getDate("fexpiredate"));
                mappingInMap.computeIfAbsent(row.getLong("fhashcode"), k -> new LinkedList()).add(inValueSet);
            }
        }
        return mappingInMap;
    }
}

