/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.mapping.impl;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.models.common.ThreeValueTuple;
import kd.fi.v2.fah.models.flex.FlexFieldCfg;
import kd.fi.v2.fah.models.flex.FlexFieldGrpCfg;
import kd.fi.v2.fah.models.mapping.IMappingStructureMeta;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.utils.StringUtils;

public class MappingStructureMeta
extends FlexFieldGrpCfg
implements IMappingStructureMeta<FlexFieldCfg, FlexFieldGrpCfg> {
    protected Long orgId;
    @Deprecated
    protected List<Long> enabledOrgIdList;
    protected Map<Long, String> enabledOrgs;
    protected FlexFieldGrpCfg outputParamMeta;
    protected transient Map<ThreeValueTuple<Byte, String, Long>, Integer> outPutColumnLookupIndex;

    public MappingStructureMeta() {
    }

    public MappingStructureMeta(Long id, String number, String name) {
        super(id, number, name);
        this.outputParamMeta = new FlexFieldGrpCfg(id, number, name);
    }

    @Override
    public void dumpCfgModel(StringBuilder output, String levelPrefix, int level) {
        if (output == null) {
            return;
        }
        output.append(StringUtils.buildPrefix(levelPrefix, level));
        output.append("[MappingStructureMeta]:EnableOrgIds=").append(this.enabledOrgs);
        String childPrefix = "\n" + StringUtils.buildPrefix(levelPrefix, level + 1);
        String child_field_Prefix = "\n" + StringUtils.buildPrefix(levelPrefix, level + 2);
        output.append(childPrefix).append("[InParam]:").append(String.format("[id=%s, number=%s, name=%s, Table=%s, Entity=%s, typeId=%s]", this.id, this.number, this.name, this.ownerTableName, this.ownerEntityNum, this.typeId));
        if (this.collections != null && !((BaseMutableArrayMapStorage)this.collections).isEmpty()) {
            for (FlexFieldCfg field : (BaseMutableArrayMapStorage)this.collections) {
                output.append(child_field_Prefix).append(field.toString());
            }
        }
        if (this.outputParamMeta != null) {
            output.append(childPrefix).append("[OutParam]:").append(String.format("[id=%s, number=%s, name=%s, Table=%s, Entity=%s, typeId=%s]", this.outputParamMeta.getId(), this.outputParamMeta.getNumber(), this.outputParamMeta.getName(), this.outputParamMeta.getOwnerTableName(), this.outputParamMeta.getOwnerEntityNum(), this.outputParamMeta.getTypeId()));
            if (!this.outputParamMeta.isEmpty()) {
                for (FlexFieldCfg field : (BaseMutableArrayMapStorage)this.outputParamMeta.getCollections()) {
                    output.append(child_field_Prefix).append(field.toString());
                }
            }
        }
    }

    @Override
    public void dumpCfgModel(StringBuilder output, int level) {
        this.dumpCfgModel(output, "   ", level);
    }

    @Override
    public void dumpCfgModel(StringBuilder output) {
        this.dumpCfgModel(output, "   ", 0);
    }

    public void setOutputParamMeta(FlexFieldGrpCfg outputParamMeta) {
        this.outputParamMeta = outputParamMeta;
        if (this.outputParamMeta != null) {
            this.buildOutPutColumnLookupIndex(outputParamMeta);
        } else {
            this.outPutColumnLookupIndex = null;
        }
    }

    protected void buildOutPutColumnLookupIndex(FlexFieldGrpCfg outputParamMeta) {
        if (this.outPutColumnLookupIndex == null) {
            this.outPutColumnLookupIndex = new HashMap<ThreeValueTuple<Byte, String, Long>, Integer>(outputParamMeta.columnCnt() * 2);
        } else {
            this.outPutColumnLookupIndex.clear();
        }
        block4: for (int i = 0; i < outputParamMeta.columnCnt(); ++i) {
            FlexFieldCfg outFieldCfg = outputParamMeta.getColumnBySeq(i);
            switch (outFieldCfg.getDataType()) {
                case BaseProp: 
                case Kingdee_CashFlow: {
                    this.outPutColumnLookupIndex.put(new ThreeValueTuple<Byte, String, Object>(IMappingStructureMeta.ColumnLookupType.RefEntity.getIndex(), outFieldCfg.getRefEntity(), null), i);
                    continue block4;
                }
                case FahValueSet: 
                case AssistProp: 
                case Kingdee_AccountTable: 
                case Kingdee_AcctAssistDim: {
                    this.outPutColumnLookupIndex.put(new ThreeValueTuple<Byte, String, Long>(IMappingStructureMeta.ColumnLookupType.RefType.getIndex(), outFieldCfg.getRefEntity(), outFieldCfg.getRefTypeId()), i);
                    continue block4;
                }
                default: {
                    this.outPutColumnLookupIndex.put(new ThreeValueTuple<Byte, String, Long>(IMappingStructureMeta.ColumnLookupType.RefType.getIndex(), outFieldCfg.getRefEntity(), outFieldCfg.getRefTypeId()), i);
                }
            }
        }
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    @Deprecated
    public List<Long> getEnabledOrgIdList() {
        return this.enabledOrgIdList;
    }

    @Deprecated
    public void setEnabledOrgIdList(List<Long> enabledOrgIdList) {
        this.enabledOrgIdList = enabledOrgIdList;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public FlexFieldGrpCfg getInputParamMeta() {
        return this;
    }

    @Override
    public FlexFieldGrpCfg getOutputParamMeta() {
        return this.outputParamMeta;
    }

    @Override
    public FlexFieldCfg searchOutputColumn(IMappingStructureMeta.ColumnLookupType lookupType, String refEntity, Long refTypeId) {
        Integer idx;
        if (lookupType == null || this.outputParamMeta == null) {
            return null;
        }
        if (this.outPutColumnLookupIndex == null) {
            this.buildOutPutColumnLookupIndex(this.outputParamMeta);
        }
        return (idx = this.outPutColumnLookupIndex.get(new ThreeValueTuple<Byte, String, Long>(lookupType.getIndex(), refEntity, refTypeId))) != null ? this.outputParamMeta.getColumnBySeq(idx) : null;
    }

    public void setInputParamMeta(FlexFieldGrpCfg inputParamMeta) {
        this.id = inputParamMeta.getId();
        this.name = inputParamMeta.getName();
        this.number = inputParamMeta.getNumber();
        this.description = inputParamMeta.getDescription();
        this.enabled = inputParamMeta.isEnabled();
        this.ownerEntityNum = inputParamMeta.getOwnerEntityNum();
        this.ownerTableName = inputParamMeta.getOwnerTableName();
        this.typeId = inputParamMeta.getTypeId();
        this.collections = inputParamMeta.getCollections();
    }

    public void forEach(IMappingStructureMeta.MappingParamMetaType paramMetaType, BiConsumer<IMappingStructureMeta.MappingParamMetaType, FlexFieldCfg> consumer) {
        ArrayList<PairTuple> loopParam = new ArrayList<PairTuple>(2);
        switch (paramMetaType) {
            case Input_Params: {
                loopParam.add(new PairTuple((Object)IMappingStructureMeta.MappingParamMetaType.Input_Params, (Object)this));
                break;
            }
            case All_Params: {
                loopParam.add(new PairTuple((Object)IMappingStructureMeta.MappingParamMetaType.Input_Params, (Object)this));
            }
            case Output_Params: {
                loopParam.add(new PairTuple((Object)IMappingStructureMeta.MappingParamMetaType.Output_Params, (Object)this.outputParamMeta));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Param Meta Type:" + (Object)((Object)paramMetaType));
            }
        }
        for (PairTuple en : loopParam) {
            IMappingStructureMeta.MappingParamMetaType param = (IMappingStructureMeta.MappingParamMetaType)((Object)en.getKey());
            ((FlexFieldGrpCfg)en.getValue()).forEach(f -> consumer.accept(param, (FlexFieldCfg)f));
        }
    }

    @Override
    public FlexFieldCfg getFlexFieldCfgByTableFieldNum(String tableFieldNum, int flexGrpCode) {
        FlexFieldGrpCfg lookup = this._getFlexGrp(flexGrpCode);
        return lookup != null ? (FlexFieldCfg)lookup.getFlexFieldCfgByTableFieldNum(tableFieldNum) : null;
    }

    protected FlexFieldGrpCfg _getFlexGrp(int flexGrpCode) {
        IMappingStructureMeta.MappingParamMetaType type = IMappingStructureMeta.MappingParamMetaType.parseType(flexGrpCode);
        if (type == null) {
            return null;
        }
        switch (type) {
            case Input_Params: {
                return this;
            }
            case Output_Params: {
                return this.outputParamMeta;
            }
        }
        throw new IllegalArgumentException("Unkown FlexGroupCode=" + flexGrpCode);
    }

    @Override
    public List<FlexFieldCfg> getSortedFlexFieldCfgs(int flexGrpCode) {
        FlexFieldGrpCfg lookup = this._getFlexGrp(flexGrpCode);
        return lookup != null ? lookup.getAllSortedFlexFieldCfgs() : Collections.emptyList();
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public List<FlexFieldCfg> getAllSortedFlexFieldCfgs() {
        ArrayList<FlexFieldCfg> result = new ArrayList<FlexFieldCfg>(this.totalFieldCnt());
        result.addAll(Arrays.asList(((BaseMutableArrayMapStorage)this.getCollections()).getValues()));
        if (this.outputParamMeta != null && !((BaseMutableArrayMapStorage)this.outputParamMeta.getCollections()).isEmpty()) {
            result.addAll(Arrays.asList(((BaseMutableArrayMapStorage)this.outputParamMeta.getCollections()).getValues()));
        }
        Collections.sort(result);
        return result;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public int totalFieldCnt() {
        return this.size() + (this.outputParamMeta != null && this.outputParamMeta.getCollections() != null ? ((BaseMutableArrayMapStorage)this.outputParamMeta.getCollections()).size() : 0);
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public void clear() {
        super.clear();
        if (this.outputParamMeta != null) {
            this.outputParamMeta.clear();
        }
    }

    public Map<Long, String> getEnabledOrgs() {
        return this.enabledOrgs;
    }

    public void setEnabledOrgs(Map<Long, String> enabledOrgs) {
        this.enabledOrgs = enabledOrgs;
    }
}

