/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.modeling.base;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.collections.IKeyedCollectionBase;
import kd.fi.v2.fah.models.modeling.base.AbstractCacheableArrayModelCollection;
import kd.fi.v2.fah.storage.IDataItemKey;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;

public abstract class AbstractBaseModelCollection<COLLECTION_KEY, ITEM_KEY, V extends IDataItemKey>
extends AbstractCacheableArrayModelCollection<COLLECTION_KEY, V, BaseMutableArrayMapStorage<ITEM_KEY, V>>
implements IKeyedCollectionBase<ITEM_KEY, V> {
    public AbstractBaseModelCollection() {
    }

    public AbstractBaseModelCollection(Long id, String number, String name) {
        super(id, number, name);
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public String toString() {
        return "AbstractBaseModelCollection{id=" + this.id + ", number='" + this.number + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", collections=" + this.collections + '}';
    }

    protected Function<V, ITEM_KEY> getItemKeyParser() {
        return v -> v != null ? v.getItemKey() : null;
    }

    @Override
    protected BaseMutableArrayMapStorage<ITEM_KEY, V> __createStorage() {
        return new BaseMutableArrayMapStorage<ITEM_KEY, V>(this.getItemKeyParser());
    }

    @Override
    protected BaseMutableArrayMapStorage<ITEM_KEY, V> __createStorage(int newSize, Class clazzType) {
        return new BaseMutableArrayMapStorage<ITEM_KEY, V>(newSize, clazzType, true, this.getItemKeyParser());
    }

    public int update(V value, boolean autoAdd) {
        int result;
        int n = result = this.collections != null ? ((BaseMutableArrayMapStorage)this.collections).update(value, autoAdd) : -1;
        if (result >= 0) {
            this.updateValueReference(value, false);
        }
        return result;
    }

    public boolean containsKey(ITEM_KEY k) {
        return this.collections != null && ((BaseMutableArrayMapStorage)this.collections).containsKey(k);
    }

    public V get(ITEM_KEY k) {
        return (V)(this.collections != null ? (IDataItemKey)((BaseMutableArrayMapStorage)this.collections).get(k) : null);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public int getIndexSize() {
        return this.collections != null ? ((BaseMutableArrayMapStorage)this.collections).getIndexSize() : 0;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Iterator<Map.Entry<ITEM_KEY, V>> getMapEntryIterator() {
        return this.collections != null ? ((BaseMutableArrayMapStorage)this.collections).getMapEntryIterator() : null;
    }

    protected void rebuildIndex(int startPos) {
        if (this.collections != null) {
            ((BaseMutableArrayMapStorage)this.collections).rebuildIndex(startPos);
        }
    }

    public int getIndex(ITEM_KEY key) {
        return this.collections != null ? ((BaseMutableArrayMapStorage)this.collections).getIndex(key) : -1;
    }

    public V removeEx(ITEM_KEY key) {
        return (V)((IDataItemKey)this.removeByIndex(this.getIndex(key)));
    }
}

