/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.modeling.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.metadata.entity.fielddefvalue.DefValueDesign;
import kd.fi.v2.fah.constant.MasterDataGroupTypeEnum;
import kd.fi.v2.fah.constant.enums.FieldPropEnum;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.models.modeling.IHasParentHierarchy;
import kd.fi.v2.fah.models.modeling.base.BaseModelFieldCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCollection;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldPropCfg;
import kd.fi.v2.fah.serializer.CustomCollectionModelSerializer;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.utils.DataModelUtils;
import kd.fi.v2.fah.utils.ICommonDataValueUtil;
import kd.fi.v2.fah.utils.StringUtils;
import kd.fi.v2.fah.validator.IUpdatableRef;
import kd.fi.v2.fah.validator.context.BasePropReferenceInfo;

public class DataModelFieldCfg
extends BaseModelFieldCfg
implements IHasParentHierarchy<DataModelFieldCollection>,
IUpdatableRef<Object> {
    protected static boolean _LocalTest_UseLocalString = false;
    protected transient DataModelFieldCollection __parent;
    @JSONField(ordinal=110)
    protected String createType;
    @JSONField(ordinal=112)
    protected Boolean isEnable;
    protected String apifield;
    @JSONField(ordinal=111)
    protected String requiredCondition;
    @JSONField(name="datas", serializeUsing=CustomCollectionModelSerializer.class, deserializeUsing=CustomCollectionModelSerializer.class)
    protected FieldPropCollectionImpl props;
    @JSONField(serialize=false)
    @JsonIgnore
    protected transient FilterCondition _filterCondition;
    private static final int FLG_IDX_HasRequiredCondition = 2;
    private static final int FLG_IDX_FormulaCondition = 3;

    public DataModelFieldCfg() {
    }

    public DataModelFieldCfg(Long id, String number, String name) {
        super(id, number, name);
    }

    @Override
    public String toString() {
        return "DataModelFieldCfg{" + super.toString() + ", createType='" + this.createType + '\'' + ", dataType='" + (Object)((Object)this.dataType) + '\'' + ", refBaseProp=" + this.refBaseProp + ", refAssistProp=" + this.refAssistProp + ", hasRequiredCondition=" + this.hasRequiredCondition() + ", _formulaCondition=" + this.isFormulaCondition() + ", requiredCondition='" + this.requiredCondition + '\'' + ", _filterCondition=" + this._filterCondition + ", props=" + this.props + ", description=" + this.description + '}';
    }

    public String getCreateType() {
        return this.createType;
    }

    public void setCreateType(String createType) {
        this.createType = createType;
    }

    public String getApifield() {
        return this.apifield;
    }

    public void setApifield(String apifield) {
        this.apifield = apifield;
    }

    public String getRequiredCondition() {
        return this.requiredCondition;
    }

    public void setRequiredCondition(String requiredCondition) {
        this.requiredCondition = requiredCondition;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Object getFormattedDefaultValue() {
        String strMsg;
        switch (this.dataType) {
            case Date: {
                return ICommonDataValueUtil.dateToString(new Date(), this.getPropValue(FieldPropEnum.DATEFORMAT, "yyyy-MM-dd"));
            }
            case BaseProp: {
                strMsg = String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u7f16\u7801\uff0c\u6700\u5927\u9650\u957f\u4e3a\u201c%s\u201d\u3002", (String)"DataModelFieldCfg_0", (String)"fi-ai-common", (Object[])new Object[0]), this.getPropValue(FieldPropEnum.MAXLENGTH, 1));
                break;
            }
            case AssistProp: {
                strMsg = String.format(ResManager.loadKDString((String)"\u8f85\u52a9\u8d44\u6599\u7f16\u7801\uff0c\u6700\u5927\u9650\u957f\u4e3a\u201c%s\u201d\u3002", (String)"DataModelFieldCfg_1", (String)"fi-ai-common", (Object[])new Object[0]), this.getPropValue(FieldPropEnum.MAXLENGTH, 1));
                break;
            }
            case String: {
                strMsg = String.format(ResManager.loadKDString((String)"\u6587\u672c\u5185\u5bb9\uff0c\u6700\u5927\u9650\u957f\u4e3a\u201c%s\u201d\u3002", (String)"DataModelFieldCfg_2", (String)"fi-ai-common", (Object[])new Object[0]), this.getPropValue(FieldPropEnum.MAXLENGTH, 1));
                break;
            }
            case Bool: {
                return true;
            }
            case Int: {
                return 32;
            }
            case Decimal: {
                return BigDecimal.ONE.setScale((int)ObjectConverterFactory.convert(this.getPropValue(FieldPropEnum.SCALE, 2), Integer.class), 4);
            }
            default: {
                return "";
            }
        }
        return strMsg;
    }

    public <T> T getPropValue(FieldPropEnum fieldProp, T defaultValue) {
        return (T)(this.props.containsKey(fieldProp.getNumber()) ? ((DataModelFieldPropCfg)this.props.get(fieldProp.getNumber())).getPropValue() : defaultValue);
    }

    @JSONField(name="datas")
    public void setProps(BaseMutableArrayMapStorage<String, DataModelFieldPropCfg> props) {
        if (props != null) {
            this.props = new FieldPropCollectionImpl(props);
        } else if (this.props != null) {
            this.props.clear();
        }
    }

    @JSONField(name="datas")
    public BaseMutableArrayMapStorage<String, DataModelFieldPropCfg> getProps() {
        if (this.props == null) {
            this.props = new FieldPropCollectionImpl();
        }
        if (this.props != null && this.props.getCustomSerializeClass() == null) {
            this.props.setCustomSerializeClass(DataModelFieldPropCfg.class);
        }
        return this.props;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public FilterCondition getFilterCondition() {
        return this._filterCondition;
    }

    public void setFilterCondition(FilterCondition filterCondition) {
        this._filterCondition = filterCondition;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public DataModelFieldCollection getParent() {
        return this.__parent;
    }

    @Override
    public void setParent(DataModelFieldCollection parent) {
        this.__parent = parent;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Boolean isFormulaCondition() {
        return this.controlFlags.isSwitchOn(3);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean hasRequiredCondition() {
        return this.controlFlags.isSwitchOn(2);
    }

    public boolean isSameModel(DataModelFieldCfg o) {
        return StringUtils.isEquals(this.number, o.getNumber()) && StringUtils.isEquals(this.name, o.getName()) && StringUtils.isEquals(this.createType, o.getCreateType()) && StringUtils.isEquals(this.apifield, o.getApifield()) && this.dataType == o.getDataType() && StringUtils.isEquals(this.refBaseProp, o.getRefBaseProp()) && ICommonDataValueUtil.isEquals(this.refAssistProp, o.getRefAssistProp()) & this.controlFlags.equals(o.controlFlags) && StringUtils.isEquals(this.requiredCondition, o.getRequiredCondition()) && this._filterCondition == o.getFilterCondition() && StringUtils.isEquals(this.description, o.getDescription()) && this.isPropEqual(this.props, o.getProps()) && Objects.equals(this.isEnable, o.getEnable());
    }

    private boolean isPropEqual(BaseMutableArrayMapStorage<String, DataModelFieldPropCfg> p1, BaseMutableArrayMapStorage<String, DataModelFieldPropCfg> p2) {
        if (p1 == null && p2 == null) {
            return true;
        }
        if (p1 != null && p2 != null) {
            return StringUtils.isEquals(JSON.toJSONString(p1.getValues()), JSON.toJSONString(p2.getValues()));
        }
        return false;
    }

    @Override
    public boolean updateReference(Object oldValue, Object newValue) {
        if (null == newValue) {
            return false;
        }
        if (newValue.equals(oldValue)) {
            return true;
        }
        MasterDataGroupTypeEnum dataGroupType = MasterDataGroupTypeEnum.convert(this.getDataType());
        if (null != dataGroupType) {
            Object defaultValue = this.getPropValue(FieldPropEnum.DEFVALUEDESIGN, null);
            if (defaultValue == null) {
                return false;
            }
            DefValueDesign defValueDesign = (DefValueDesign)JSON.parseObject((String)defaultValue, DefValueDesign.class);
            JSONObject jsonObj = JSON.parseObject((String)defValueDesign.getFuncParameter());
            switch (dataGroupType) {
                case Base_Prop: 
                case Assist_Prop: {
                    jsonObj.put("id", newValue);
                    break;
                }
            }
        }
        return true;
    }

    @Override
    public String getUpdateErrorMsg(MasterDataGroupTypeEnum masterDataGrpType, Object dateTypeKey, BasePropReferenceInfo referenceInfo) {
        DataModelFieldCollection fieldCollection;
        if (referenceInfo.getUpdatedCnt() != 1 && null != (fieldCollection = this.getParent())) {
            DataModelCfg modelCfg;
            if (null != this.getProps()) {
                this.getProps().removeEx(FieldPropEnum.DEFVALUEDESIGN.getNumber());
            }
            if (null != (modelCfg = fieldCollection.getParent())) {
                String fieldName = this.getName() + "(" + this.getNumber() + ")";
                String fieldFullName = DataModelUtils.getFieldFullName(fieldName, modelCfg, fieldCollection);
                if (referenceInfo.getUpdatedCnt() <= 0) {
                    return String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%s\u201d\u9ed8\u8ba4\u503c\u672a\u5339\u914d\u5230\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"DataModelFieldCfg_6", (String)"fi-ai-common", (Object[])new Object[0]), fieldFullName);
                }
                if (referenceInfo.getUpdatedCnt() > 1) {
                    return String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%s\u201d\u9ed8\u8ba4\u503c\u5339\u914d\u5230\u591a\u6761\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"DataModelFieldCfg_4", (String)"fi-ai-common", (Object[])new Object[0]), fieldFullName);
                }
            }
        }
        return null;
    }

    public Boolean getEnable() {
        return this.isEnable;
    }

    public void setEnable(Boolean enable) {
        this.isEnable = enable;
    }

    public static class FieldPropCollectionImpl
    extends BaseMutableArrayMapStorage<String, DataModelFieldPropCfg> {
        public FieldPropCollectionImpl() {
            super(0, DataModelFieldPropCfg.class, true);
        }

        public FieldPropCollectionImpl(BaseMutableArrayMapStorage<String, DataModelFieldPropCfg> props) {
            super(0, DataModelFieldPropCfg.class, props.isCaseSensitive());
            if (props != null && props.size() > 0) {
                this.batchAdd(Arrays.asList(props.getValues()));
            }
        }

        public FieldPropCollectionImpl(int initialSize, Class<DataModelFieldPropCfg> clazzType, boolean caseInsensitive) {
            super(initialSize, clazzType, caseInsensitive);
        }
    }
}

