/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.modeling.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.function.BiFunction;
import kd.fi.v2.fah.constant.enums.AppVersionEnum;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.DefaultDataFieldGroupEnum;
import kd.fi.v2.fah.migration.common.ICustomDataMigration;
import kd.fi.v2.fah.models.modeling.IHasParentHierarchy;
import kd.fi.v2.fah.models.modeling.base.BaseModelCollection;
import kd.fi.v2.fah.models.modeling.impl.DataModelCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCfg;
import kd.fi.v2.fah.serializer.LongJsonDeserializer;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.utils.StringUtils;

public class DataModelFieldCollection
extends BaseModelCollection<String, DataModelFieldCfg>
implements IHasParentHierarchy<DataModelCfg>,
ICustomDataMigration {
    protected transient DataModelCfg __parent;
    protected int groupSeq;
    @JSONField(name="groupType")
    protected DefaultDataFieldGroupEnum groupType;
    protected String tableName;
    @JSONField(deserializeUsing=LongJsonDeserializer.class)
    private long parentId;
    protected int groupLevel;

    public DataModelFieldCollection() {
    }

    public DataModelFieldCollection(Long id, String number, String name) {
        super(id, number, name);
    }

    public int getGroupSeq() {
        return this.groupSeq;
    }

    public void setGroupSeq(int groupSeq) {
        this.groupSeq = groupSeq;
    }

    public DefaultDataFieldGroupEnum getGroupType() {
        return this.groupType;
    }

    public void setGroupType(DefaultDataFieldGroupEnum groupType) {
        this.groupType = groupType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public int getGroupLevel() {
        return this.groupLevel;
    }

    public void setGroupLevel(int groupLevel) {
        this.groupLevel = groupLevel;
    }

    protected JSONObject buildJson(JSONObject outputTargetJson, int seq, boolean skipNullValue, BiFunction<Integer, DataModelFieldCfg, Object> dataGenFunc) {
        boolean useDataGenFunc;
        if (this.isEmpty()) {
            return new JSONObject();
        }
        boolean bl = useDataGenFunc = dataGenFunc != null;
        if (this.collections != null && !((BaseMutableArrayMapStorage)this.collections).isEmpty()) {
            for (DataModelFieldCfg fieldCfg : (BaseMutableArrayMapStorage)this.collections) {
                String apifield;
                Object fieldValue = useDataGenFunc ? dataGenFunc.apply(seq, fieldCfg) : fieldCfg.getFormattedDefaultValue();
                if (fieldValue == null && skipNullValue || !StringUtils.isNotEmpty((String)(apifield = fieldCfg.getApifield()))) continue;
                if (fieldCfg.getDataType() == DataValueTypeEnum.String || fieldCfg.getDataType() == DataValueTypeEnum.BaseProp || fieldCfg.getDataType() == DataValueTypeEnum.AssistProp) {
                    outputTargetJson.put(apifield, (Object)String.format("\u3010%s\u3011--%s", fieldCfg.getName(), fieldValue));
                    continue;
                }
                outputTargetJson.put(apifield, fieldValue);
            }
        }
        return outputTargetJson;
    }

    public JSONObject buildJson(int seq, boolean skipNullValue) {
        return this.buildJson(new JSONObject(new LinkedHashMap(this.size())), seq, skipNullValue, (idx, field) -> field.getFormattedDefaultValue());
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public void forEachField(BiFunction<Integer, DataModelFieldCfg, Boolean> fieldProcessFunc) {
        if (this.collections != null && !((BaseMutableArrayMapStorage)this.collections).isEmpty() && fieldProcessFunc != null) {
            int index = 0;
            for (DataModelFieldCfg fieldCfg : (BaseMutableArrayMapStorage)this.collections) {
                if (fieldCfg == null || fieldProcessFunc.apply(index++, fieldCfg).booleanValue()) continue;
                return;
            }
        }
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public DataModelCfg getParent() {
        return this.__parent;
    }

    @Override
    public void setParent(DataModelCfg parent) {
        this.__parent = parent;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public DataModelFieldCollection getParentGroup() {
        for (DataModelFieldCollection group : (BaseMutableArrayMapStorage)this.getParent().getCollections()) {
            if (this.getParentId() != group.getId().longValue()) continue;
            return group;
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataModelFieldCollection that = (DataModelFieldCollection)o;
        return this.groupSeq == that.groupSeq && this.parentId == that.parentId && this.groupLevel == that.groupLevel && this.groupType == that.groupType && Objects.equals(this.tableName, that.tableName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.__parent, this.groupSeq, this.groupType, this.tableName, this.parentId, this.groupLevel});
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public void onAfterLoadMigrationDataModel(Object dataVersion) {
        if (this.collections == null) {
            return;
        }
        for (DataModelFieldCfg cfg : (BaseMutableArrayMapStorage)this.collections) {
            if (cfg == null) continue;
            switch (AppVersionEnum.parserAppVersionEnum(dataVersion)) {
                case NEW_APP: {
                    if (!StringUtils.isEmpty((String)cfg.getApifield())) break;
                    cfg.setApifield(cfg.getNumber());
                    break;
                }
                case NEW_APP_2: {
                    break;
                }
            }
        }
    }
}

