/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.valueset;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.models.valueset.IBaseSimpleValueRow;
import kd.fi.v2.fah.utils.ArrayUtils;

public interface IBaseSimpleValueSet<V>
extends IBaseSimpleValueRow<V> {
    @JSONField(serialize=false)
    @JsonIgnore
    default public boolean isHasMulValue() {
        return false;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    default public int getMultiValueComboRowCnt() {
        if (!this.isHasMulValue()) {
            return 0;
        }
        int[] totalRowCnt = new int[]{1};
        this.forEach((colIdx, cellValue) -> {
            if (cellValue instanceof Collection && !((Collection)cellValue).isEmpty()) {
                totalRowCnt[0] = totalRowCnt[0] * ((Collection)cellValue).size();
            }
            return true;
        });
        return totalRowCnt[0];
    }

    default public void forEachMulValueColumn(BiConsumer<Integer, V> valueConsumer) {
    }

    @JSONField(serialize=false)
    @JsonIgnore
    default public V[] getCombineValues() {
        Object[] reserveData;
        PairTuple<Boolean, V[]> reserve;
        Supplier<PairTuple<Boolean, V[]>> func = this.getReserveDataSupplier();
        if (func != null && (reserve = func.get()).getValue() != null && (reserveData = (Object[])reserve.getValue()) != null && reserveData.length > 0) {
            return ArrayUtils.combineArray(reserveData, this.getValues(), (Boolean)reserve.getKey());
        }
        return this.getValues();
    }

    default public void setReserveDataSupplier(Supplier<PairTuple<Boolean, V[]>> reserveDataSupplier) {
    }

    @JSONField(serialize=false)
    @JsonIgnore
    default public Supplier<PairTuple<Boolean, V[]>> getReserveDataSupplier() {
        return null;
    }
}

