/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.valueset;

import java.io.Serializable;
import java.util.Date;
import kd.fi.v2.fah.models.valueset.IBaseValueSet;
import kd.fi.v2.fah.storage.IDataItemKey;

public interface IDataValueSet<ID extends Serializable>
extends IBaseValueSet,
IDataItemKey<ID> {
    public Date getEffectDate();

    public Date getExpireDate();

    public Integer getSerialNumber();

    public boolean isEnabled();

    public boolean hasHasMulValue();

    default public boolean hasValidDateRange() {
        Date effectDate = this.getEffectDate();
        Date expireDate = this.getExpireDate();
        return effectDate == null || effectDate.getTime() >= 10L || expireDate != null;
    }

    default public boolean isActive(Date currentDate) {
        Date effectDate = this.getEffectDate();
        Date expireDate = this.getExpireDate();
        return this.isEnabled() && (currentDate != null || effectDate == null && expireDate == null) && (effectDate == null || !effectDate.before(currentDate)) && (expireDate == null || !currentDate.after(expireDate));
    }
}

