/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.valueset.base;

import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import kd.fi.bd.util.iterators.impl.IntArraySequenceIterator;
import kd.fi.v2.fah.models.valueset.IBaseSimpleValueSet;
import kd.fi.v2.fah.models.valueset.IBaseSimpleValueSetCollection;
import kd.fi.v2.fah.models.valueset.base.SimpleBaseValueSet;
import kd.fi.v2.fah.utils.ValueSetUtilHelper;

public class CombItemValueSetWrapperIterator<T extends IBaseSimpleValueSet, COLLECTION extends IBaseSimpleValueSetCollection<T>>
implements Iterator<T> {
    protected int _totalColumnCnt;
    protected COLLECTION srcValueSetCollection;
    protected transient Iterator<T> _srcValueIterator;
    protected transient IntArraySequenceIterator _comboValueIterator;
    protected Function<Object[], T> valueSetSupplier;
    protected long startSeqNo;
    protected transient long currentSeqNo;
    protected int Seq_Column_Index = -1;
    protected transient boolean needGenerateSeq = false;
    protected boolean eof;

    public CombItemValueSetWrapperIterator(COLLECTION srcValueSetCollection, int totalColumnCnt) {
        this.srcValueSetCollection = srcValueSetCollection;
        if (this.srcValueSetCollection == null) {
            throw new IllegalArgumentException("Source ValueSet cannot be null!");
        }
        this._totalColumnCnt = totalColumnCnt;
        this.valueSetSupplier = rowData -> this._createNewValueSet((Object[])rowData);
        this._srcValueIterator = srcValueSetCollection.iterator();
        this.eof = !this._srcValueIterator.hasNext();
        this.currentSeqNo = 0L;
    }

    protected T _createNewValueSet(Object[] rowData) {
        SimpleBaseValueSet<Object> newValueSet = new SimpleBaseValueSet<Object>(rowData.length, Object.class);
        newValueSet._updateStorageValues((Object[])rowData, false);
        return (T)newValueSet;
    }

    public void setStartSeqNo(int columnIdx, long startSeqNo) {
        this.startSeqNo = startSeqNo;
        this.Seq_Column_Index = columnIdx;
        this.needGenerateSeq = true;
    }

    @Override
    public boolean hasNext() {
        if (this.eof) {
            return false;
        }
        if (this._comboValueIterator == null) {
            return this.moveToNextSourceRow();
        }
        return this._comboValueIterator.hasNext() || this.moveToNextSourceRow();
    }

    protected boolean moveToNextSourceRow() {
        IBaseSimpleValueSet newSrcRow;
        do {
            if (this._srcValueIterator.hasNext()) continue;
            return false;
        } while ((newSrcRow = (IBaseSimpleValueSet)this._srcValueIterator.next()) == null);
        this._comboValueIterator = ValueSetUtilHelper.buildComboItemIterator(newSrcRow);
        this.eof = !this._comboValueIterator.hasNext();
        return !this.eof;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new IndexOutOfBoundsException("Multi-Value Iterator EOF!");
        }
        Object[] newRowBuf = this._comboValueIterator.next();
        newRowBuf = Arrays.copyOf(newRowBuf, newRowBuf.length);
        if (this.needGenerateSeq) {
            newRowBuf[this.Seq_Column_Index] = this.currentSeqNo++ + this.startSeqNo;
        }
        return (T)((IBaseSimpleValueSet)this.valueSetSupplier.apply(newRowBuf));
    }

    public int size() {
        return ValueSetUtilHelper.calculateTotalRowCnt(this.srcValueSetCollection);
    }

    public boolean isEmpty() {
        return this.srcValueSetCollection.isEmpty();
    }

    public T getSourceValueSet(int index) {
        return this.srcValueSetCollection.get(index);
    }

    public int getTotalColumnCnt() {
        return this._totalColumnCnt;
    }
}

