/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.valueset.base;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import kd.fi.v2.fah.models.valueset.base.SimpleBaseValueSet;
import kd.fi.v2.fah.storage.impl.MutableArrayStorage;

public class SimpleBaseMultiItemValueSet
extends SimpleBaseValueSet<Object> {
    protected BitSet mulValueColumnPos;
    protected Supplier<Collection<Object>> valueMergeCollectionSupplier = () -> new LinkedList();

    public SimpleBaseMultiItemValueSet() {
        this.mulValueColumnPos = new BitSet();
    }

    public SimpleBaseMultiItemValueSet(int colCount) {
        super(colCount, Object.class);
        this.mulValueColumnPos = new BitSet();
    }

    @Override
    public String toString() {
        return "SimpleMultiValueValueSet{hashCode=" + this.hashCode + ", mulValueColumnPos=" + this.mulValueColumnPos + ", columnValues=" + this._storageData + '}';
    }

    protected Collection mergeMultiValue(Object oldValue, Object newValue) {
        LinkedList<Object> result = new LinkedList<Object>();
        result.add(oldValue);
        result.add(newValue);
        return result;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public BitSet getMultiValueColumnPos() {
        BitSet multiValueColumnPos = new BitSet(0);
        if (this._storageData == null) {
            return multiValueColumnPos;
        }
        for (int i = 0; i < this._storageData.size(); ++i) {
            if (!(this._storageData.get(i) instanceof Collection)) continue;
            multiValueColumnPos.set(i);
        }
        return multiValueColumnPos;
    }

    @Override
    public int setColumnValue(int colIdx, Object newValue, boolean addOrUpdate) {
        if (addOrUpdate) {
            this._storageData.set(colIdx, newValue);
            return colIdx;
        }
        return this.addColumnValue(colIdx, newValue);
    }

    @Override
    public int addColumnValue(int colIdx, Object newValue) {
        int valuePos;
        Object oldValue;
        Collection<Object> bufList;
        if (newValue == null) {
            return -1;
        }
        boolean newValueIsCollection = false;
        if (newValue instanceof Collection) {
            bufList = (Collection<Object>)newValue;
            switch (bufList.size()) {
                case 0: {
                    return -1;
                }
                case 1: {
                    newValue = bufList.iterator().next();
                    break;
                }
                default: {
                    newValueIsCollection = true;
                    this.mulValueColumnPos.set(colIdx);
                }
            }
        }
        if ((oldValue = this._storageData.get(colIdx)) == null) {
            this._storageData.set(colIdx, newValue);
            valuePos = 0;
        } else {
            if (oldValue instanceof Collection) {
                bufList = (Collection)oldValue;
                if (newValueIsCollection) {
                    bufList.addAll((Collection)newValue);
                } else {
                    bufList.add(newValue);
                }
            } else if (newValueIsCollection) {
                bufList = (Collection)newValue;
                bufList.add(oldValue);
                this._storageData.set(colIdx, newValue);
            } else {
                bufList = this.valueMergeCollectionSupplier.get();
                bufList.add(oldValue);
                bufList.add(newValue);
                this._storageData.set(colIdx, bufList);
                this.mulValueColumnPos.set(colIdx);
            }
            valuePos = bufList.size() - 1;
        }
        return valuePos;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isHasMulValue() {
        return this.mulValueColumnPos != null && !this.mulValueColumnPos.isEmpty();
    }

    @Override
    public void forEachMulValueColumn(BiConsumer<Integer, Object> valueConsumer) {
        if (valueConsumer != null && !this.isEmpty() && this.isHasMulValue()) {
            int pos = 0;
            while ((pos = this.mulValueColumnPos.nextSetBit(pos)) > 0) {
                valueConsumer.accept(pos, this._storageData.get(pos));
            }
        }
    }

    public BitSet getMulValueColumnPos() {
        return this.mulValueColumnPos;
    }

    @Override
    public MutableArrayStorage<Object> get_storageData() {
        return this._storageData;
    }

    @Override
    public void set_storageData(MutableArrayStorage<Object> _storageData) {
        this._storageData = _storageData;
    }

    @Override
    public Supplier<Collection<Object>> getValueMergeCollectionSupplier() {
        return this.valueMergeCollectionSupplier;
    }

    @Override
    public void setValueMergeCollectionSupplier(Supplier<Collection<Object>> valueMergeCollectionSupplier) {
        this.valueMergeCollectionSupplier = valueMergeCollectionSupplier;
    }
}

