/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.serializer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.BitSet;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.utils.ArrayUtils;

public class BitSetJsonDeserializer
implements ObjectDeserializer,
ObjectSerializer {
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        Object value = parser.parse();
        if (value == null) {
            return null;
        }
        if (!(value instanceof JSONArray)) {
            throw new IllegalArgumentException("Expect Input Json Value is JSONArray! Actual=" + value.getClass());
        }
        JSONArray jsonArray = (JSONArray)value;
        int totalLevelCnt = ArrayUtils.getJSonArrayLevelCnt(jsonArray);
        if (totalLevelCnt <= 1) {
            return (T)this.convertToBitSet(jsonArray);
        }
        int[] arrayDimCnts = ArrayUtils.getArrayDimensionMaxCnts(value, -1);
        Object results = Array.newInstance(BitSet.class, arrayDimCnts);
        ArrayUtils.convertArray(value, ArrayUtils.buildMulDimArrayLookupFunc(results), true, json -> this.convertToBitSet(json));
        return (T)results;
    }

    private BitSet convertToBitSet(Object srcValue) {
        if (srcValue instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)srcValue;
            long[] vals = new long[jsonArray.size()];
            int i = 0;
            for (Object src : jsonArray) {
                vals[i++] = ObjectConverterFactory.convert(src, Long.TYPE);
            }
            return BitSet.valueOf(vals);
        }
        if (srcValue instanceof Number) {
            return BitSet.valueOf(new long[]{((Number)srcValue).longValue()});
        }
        throw new IllegalArgumentException("Unsupported Value:" + srcValue);
    }

    public int getFastMatchToken() {
        return 0;
    }

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        if (object instanceof BitSet) {
            serializer.write((Object)((BitSet)object).toLongArray());
        } else if (ArrayUtils.getArrayDimensions(object, BitSet.class) >= 0) {
            int[] arrayDimCnts = ArrayUtils.getArrayDimensionMaxCnts(object, 1);
            Object results = Array.newInstance(Long.TYPE, arrayDimCnts);
            ArrayUtils.convertArray(object, ArrayUtils.buildMulDimArrayLookupFunc(results), false, obj -> ((BitSet)obj).toLongArray());
            serializer.write(results);
        } else if (object == null) {
            serializer.writeNull();
        } else {
            serializer.write(object);
        }
    }
}

