/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.serializer;

import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import kd.fi.v2.fah.models.serialize.JsonSerializeNodeWrapper;
import kd.fi.v2.fah.serializer.CustomJsonSerializeHelper;
import kd.fi.v2.fah.serializer.ICustomJsonSerialize;

public class CustomJsonSerializer
implements ObjectSerializer,
ObjectDeserializer {
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        return CustomJsonSerializeHelper.parseJsonSerializeNodeWrapper(parser.parseObject(), type, fieldName);
    }

    public int getFastMatchToken() {
        return 0;
    }

    protected boolean isClassCanBeInstance(Class targetClassType) {
        return !targetClassType.isInterface() && !Modifier.isAbstract(targetClassType.getModifiers()) || targetClassType.isAnonymousClass() && Modifier.isPublic(targetClassType.getModifiers()) && Modifier.isStatic(targetClassType.getModifiers());
    }

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        if (object == null) {
            serializer.writeNull();
            return;
        }
        if (object instanceof ICustomJsonSerialize) {
            if (((ICustomJsonSerialize)object).needToSerialize()) {
                serializer.write((Object)new JsonSerializeNodeWrapper(object));
            } else {
                serializer.writeNull();
            }
        } else {
            boolean needUseWrapper = false;
            Class<?> outputClassType = object.getClass();
            Object outputBuf = object;
            if (fieldType != null) {
                if (fieldType instanceof ParameterizedType) {
                    outputClassType = (Class<?>)((ParameterizedType)fieldType).getRawType();
                    if (!this.isClassCanBeInstance(outputClassType)) {
                        outputClassType = object.getClass();
                    }
                } else if (fieldType instanceof TypeVariable) {
                    JsonSerializeNodeWrapper jsoWrapper = new JsonSerializeNodeWrapper(object);
                    jsoWrapper.setCustomSerializeClass(object.getClass());
                    outputBuf = jsoWrapper;
                    needUseWrapper = true;
                }
                if (!this.isClassCanBeInstance(outputClassType)) {
                    throw new IllegalArgumentException(String.format("Class Type cannot be instantiation! Object.Class:%s, FieldName=%s, FieldType=%s", object.getClass(), fieldName, fieldType));
                }
            }
            if (needUseWrapper) {
                serializer.write(outputBuf);
            } else {
                serializer.writeAs(outputBuf, outputClassType);
            }
        }
    }
}

