/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.sqlbuilder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import kd.fi.v2.fah.constant.enums.SqlStatementType;
import kd.fi.v2.fah.models.flex.FlexFieldCfg;
import kd.fi.v2.fah.models.table.meta.impl.SimpleTableFieldMeta;
import kd.fi.v2.fah.sqlbuilder.IAddSqlColumn;
import kd.fi.v2.fah.sqlbuilder.IBaseSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.IFlexFieldLookup;
import kd.fi.v2.fah.sqlbuilder.SQLColumnInfo;
import kd.fi.v2.fah.utils.StringUtils;

public abstract class AbstractBaseSqlBuilder<BATCH_ID>
implements IBaseSqlBuilder<BATCH_ID>,
IAddSqlColumn {
    protected SqlStatementType sqlStatementType;
    protected BATCH_ID batchId;
    protected String tableName;
    protected List<SQLColumnInfo> columns;
    protected int _totalColumnCnt;
    protected int[] columnTypeCnt;
    protected int PK_Column_Index = -1;
    protected int Seq_Column_Index = -1;

    public AbstractBaseSqlBuilder(BATCH_ID batchId, SqlStatementType sqlStatementType, String tableName) {
        this.batchId = batchId;
        this.sqlStatementType = sqlStatementType;
        this.tableName = tableName;
        this.columns = new LinkedList<SQLColumnInfo>();
        this.columnTypeCnt = new int[IAddSqlColumn.ColumnGrpType.values().length];
        Arrays.fill(this.columnTypeCnt, 0);
        this._totalColumnCnt = 0;
    }

    public String toString() {
        return "AbstractBaseSqlBuilder{sqlStatementType=" + (Object)((Object)this.sqlStatementType) + ", batchId=" + this.batchId + ", tableName='" + this.tableName + '\'' + ", columnTypeCnt=" + Arrays.toString(this.columnTypeCnt) + ", _totalColumnCnt=" + this._totalColumnCnt + ", columns=" + this.columns + '}';
    }

    @Override
    public String getSqlTableName() {
        return this.tableName;
    }

    @Override
    public Collection<String> getSqlColumnNames() {
        if (this.columns == null || this.columns.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List[] colGrpBufs = new List[IAddSqlColumn.ColumnGrpType.values().length];
        boolean i = false;
        for (SQLColumnInfo col : this.columns) {
            LinkedList<String> colGrpNameBuf = colGrpBufs[col.getColumnGrpType().getSeq()];
            if (colGrpNameBuf == null) {
                colGrpBufs[col.getColumnGrpType().getSeq()] = colGrpNameBuf = new LinkedList<String>();
            }
            colGrpNameBuf.add(this.getConvertedColumnName(col.getColumnGrpType(), col.getDbFieldNum()));
        }
        LinkedList<String> result = new LinkedList<String>();
        for (List cols : colGrpBufs) {
            if (cols == null || cols.isEmpty()) continue;
            result.addAll(cols);
        }
        return result;
    }

    @Override
    public void cleanColumns(IAddSqlColumn.ColumnGrpType ... columnGrpTypes) {
        ArrayList<SQLColumnInfo> backup = new ArrayList<SQLColumnInfo>(this.columns);
        this.columns.clear();
        Arrays.fill(this.columnTypeCnt, 0);
        this._totalColumnCnt = 0;
        if (columnGrpTypes != null && columnGrpTypes.length > 0) {
            HashSet<IAddSqlColumn.ColumnGrpType> filter = new HashSet<IAddSqlColumn.ColumnGrpType>(columnGrpTypes.length);
            filter.addAll(Arrays.asList(columnGrpTypes));
            for (SQLColumnInfo sqlColumnInfo : backup) {
                if (sqlColumnInfo == null || filter.contains((Object)sqlColumnInfo.getColumnGrpType())) continue;
                String columnName = sqlColumnInfo.getName();
                block0 : switch (sqlColumnInfo.getColumnGrpType()) {
                    case ConstantValueColumn: {
                        switch (sqlColumnInfo.getColumnUsageType()) {
                            case PK_Column: {
                                this.addPKColumn(columnName, new Object[0]);
                                break block0;
                            }
                            case Sequence: {
                                this.addSequenceColumn(columnName, new Object[0]);
                                break block0;
                            }
                        }
                        this.addConstantValueColumn(columnName, sqlColumnInfo.getColumnValue());
                        break;
                    }
                    case FixPosColumn: {
                        this.addFixPosColumn(columnName, new Object[0]);
                        break;
                    }
                    case FlexColumn: {
                        this.addFlexColumn(columnName, new Object[0]);
                    }
                }
            }
        }
    }

    protected String getConvertedColumnName(IAddSqlColumn.ColumnGrpType columnGrpType, String columnInfo) {
        return columnInfo;
    }

    protected int addSingleColumn(IAddSqlColumn.ColumnGrpType columnGrpType, String columnNumber, IAddSqlColumn.ColumnUsageType columnUsageType, Object ... columnParams) {
        if (StringUtils.isEmpty((String)columnNumber)) {
            return -1;
        }
        int seqNo = this._totalColumnCnt++;
        int n = columnGrpType.getSeq();
        int n2 = this.columnTypeCnt[n];
        this.columnTypeCnt[n] = n2 + 1;
        SQLColumnInfo columnInfo = new SQLColumnInfo(columnGrpType, columnNumber, columnNumber, seqNo, n2, columnUsageType);
        this.columns.add(columnInfo);
        if (IAddSqlColumn.ColumnGrpType.ConstantValueColumn == columnGrpType && columnParams != null && columnParams.length > 0) {
            columnInfo.setColumnValue(columnParams[0]);
        }
        return seqNo;
    }

    protected boolean addColumns(IAddSqlColumn.ColumnGrpType columnGrpType, Collection<String> columnNumbers, IAddSqlColumn.ColumnUsageType columnUsageType, Object ... columnParams) {
        if (columnNumbers == null || columnNumbers.size() == 0) {
            return false;
        }
        for (String columnNumber : columnNumbers) {
            this.addSingleColumn(columnGrpType, columnNumber, columnUsageType, columnParams);
        }
        return true;
    }

    @Override
    public int addConstantValueColumn(String columnNumber, Object columnParam) {
        return this.addSingleColumn(IAddSqlColumn.ColumnGrpType.ConstantValueColumn, columnNumber, IAddSqlColumn.ColumnUsageType.NormalData, columnParam);
    }

    @Override
    public int addFixPosColumn(String columnNumber, Object ... columnParams) {
        return this.addSingleColumn(IAddSqlColumn.ColumnGrpType.FixPosColumn, columnNumber, IAddSqlColumn.ColumnUsageType.NormalData, columnParams);
    }

    @Override
    public int addFlexColumn(String columnNumber, Object ... columnParams) {
        return this.addSingleColumn(IAddSqlColumn.ColumnGrpType.FlexColumn, columnNumber, IAddSqlColumn.ColumnUsageType.FlexDataType, columnParams);
    }

    @Override
    public int addPKColumn(String columnNumber, Object ... columnParams) {
        this.PK_Column_Index = this.columnTypeCnt[IAddSqlColumn.ColumnGrpType.ConstantValueColumn.getSeq()];
        this.addSingleColumn(IAddSqlColumn.ColumnGrpType.ConstantValueColumn, columnNumber, IAddSqlColumn.ColumnUsageType.PK_Column, columnParams);
        return this.PK_Column_Index;
    }

    @Override
    public int addSequenceColumn(String columnNumber, Object ... columnParams) {
        this.Seq_Column_Index = this.columnTypeCnt[IAddSqlColumn.ColumnGrpType.ConstantValueColumn.getSeq()];
        this.addSingleColumn(IAddSqlColumn.ColumnGrpType.ConstantValueColumn, columnNumber, IAddSqlColumn.ColumnUsageType.Sequence, columnParams);
        return this.Seq_Column_Index;
    }

    public boolean setColumnUsageType(int columnIndex, IAddSqlColumn.ColumnUsageType columnUsageType) {
        if (columnIndex < 0 || columnIndex >= this.columns.size()) {
            return false;
        }
        this.columns.get(columnIndex).setColumnUsageType(columnUsageType);
        return true;
    }

    @Override
    public void accessColumnInfos(Function<SQLColumnInfo, Boolean> consumerFunc) {
        if (consumerFunc == null) {
            return;
        }
        for (SQLColumnInfo columnInfo : this.columns) {
            if (consumerFunc.apply(columnInfo).booleanValue()) continue;
            return;
        }
    }

    public int getColumnTypeCnt(IAddSqlColumn.ColumnGrpType grpType) {
        return grpType != null ? this.columnTypeCnt[grpType.getSeq()] : 0;
    }

    public int getColumnGrpAccessOffset(IAddSqlColumn.ColumnGrpType grpType) {
        if (grpType == null) {
            return -1;
        }
        switch (grpType) {
            case ConstantValueColumn: {
                return 0;
            }
            case FixPosColumn: {
                return this.columnTypeCnt[IAddSqlColumn.ColumnGrpType.ConstantValueColumn.getSeq()];
            }
            case FlexColumn: {
                return this.columnTypeCnt[IAddSqlColumn.ColumnGrpType.ConstantValueColumn.getSeq()] + this.columnTypeCnt[IAddSqlColumn.ColumnGrpType.FixPosColumn.getSeq()];
            }
        }
        return -1;
    }

    public int[] getFlexFieldAccessPos(IFlexFieldLookup lookup, int paramType) {
        if (lookup == null) {
            return new int[0];
        }
        List flexFieldCfgs = lookup.getAllSortedFlexFieldCfgs();
        HashMap<String, Integer> sortedFlexFieldCfg = new HashMap<String, Integer>(flexFieldCfgs.size());
        int cfgSeq = 0;
        for (Object fieldCfg : flexFieldCfgs) {
            if (paramType != ((FlexFieldCfg)fieldCfg).getFieldUsageType()) continue;
            sortedFlexFieldCfg.put(((SimpleTableFieldMeta)fieldCfg).getDbFieldNum(), cfgSeq++);
        }
        LinkedList<SQLColumnInfo> bufferList = new LinkedList<SQLColumnInfo>();
        for (SQLColumnInfo field : this.columns) {
            if (field.getColumnGrpType() != IAddSqlColumn.ColumnGrpType.FlexColumn) continue;
            bufferList.add(field);
        }
        bufferList.sort((oldCfg, newCfg) -> {
            if (oldCfg == null && newCfg == null) {
                return 0;
            }
            if (oldCfg == null) {
                return 1;
            }
            if (newCfg == null) {
                return -1;
            }
            if (oldCfg.getAddSeq().intValue() == newCfg.getAddSeq().intValue()) {
                return 0;
            }
            return oldCfg.getAddSeq() >= newCfg.getAddSeq() ? -1 : 1;
        });
        int accessPos = this.columnTypeCnt[IAddSqlColumn.ColumnGrpType.ConstantValueColumn.getSeq()] + this.columnTypeCnt[IAddSqlColumn.ColumnGrpType.FixPosColumn.getSeq()];
        int flexFieldCnt = this.columnTypeCnt[IAddSqlColumn.ColumnGrpType.FlexColumn.getSeq()];
        int[] resultPos = new int[flexFieldCnt];
        for (SQLColumnInfo columnInfo : bufferList) {
            resultPos[((Integer)sortedFlexFieldCfg.get((Object)columnInfo.getName())).intValue()] = accessPos++;
        }
        return resultPos;
    }

    public void clearSqlParamData() {
        throw new UnsupportedOperationException("Not Implement Yet!");
    }

    @Override
    public SqlStatementType getSqlStatementType() {
        return this.sqlStatementType;
    }

    public void setSqlStatementType(SqlStatementType sqlStatementType) {
        this.sqlStatementType = sqlStatementType;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public BATCH_ID getBatchId() {
        return this.batchId;
    }

    public void setBatchId(BATCH_ID batchId) {
        this.batchId = batchId;
    }

    public int getTotalColumnCnt() {
        return this._totalColumnCnt;
    }

    public int getPK_Column_Index() {
        return this.PK_Column_Index;
    }

    public int getSeq_Column_Index() {
        return this.Seq_Column_Index;
    }

    public void setPK_Column_Index(int PK_Column_Index) {
        this.PK_Column_Index = PK_Column_Index;
    }

    public void setSeq_Column_Index(int seq_Column_Index) {
        this.Seq_Column_Index = seq_Column_Index;
    }
}

