/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.sqlbuilder;

import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Function;
import kd.fi.v2.fah.sqlbuilder.SQLColumnInfo;

public interface IAddSqlColumn {
    public String getTableName();

    public int addConstantValueColumn(String var1, Object var2);

    public int addFixPosColumn(String var1, Object ... var2);

    public int addFlexColumn(String var1, Object ... var2);

    public int addPKColumn(String var1, Object ... var2);

    public int addSequenceColumn(String var1, Object ... var2);

    public void cleanColumns(ColumnGrpType ... var1);

    public void accessColumnInfos(Function<SQLColumnInfo, Boolean> var1);

    default public void getColumnByUsageType(ColumnUsageType columnUsageType, Function<SQLColumnInfo, Boolean> consumerFunc) {
        this.accessColumnInfos(col -> {
            if (col.getColumnUsageType() == columnUsageType) {
                return (Boolean)consumerFunc.apply((SQLColumnInfo)col);
            }
            return true;
        });
    }

    default public Collection<String> getColumnNameByUsageType(ColumnUsageType columnUsageType, boolean useAliasName) {
        LinkedList<String> result = new LinkedList<String>();
        this.getColumnByUsageType(columnUsageType, col -> {
            result.add(useAliasName ? col.getAlias() : col.getName());
            return true;
        });
        return result;
    }

    public static enum ColumnUsageType {
        PK_Column,
        FK_Column,
        Sequence,
        FlexDataType,
        Multi_Value,
        NormalData;

    }

    public static enum ColumnGrpType {
        ConstantValueColumn(0, 0),
        FixPosColumn(1, 1),
        FlexColumn(2, 2),
        DataColumn(9, 3);

        int index;
        int seq;

        private ColumnGrpType(int index, int seqNo) {
            this.index = index;
            this.seq = seqNo;
        }

        public int getSeq() {
            return this.seq;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

