/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.sqlbuilder.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.enums.MappingValueType;
import kd.fi.v2.fah.models.flex.FlexFieldCfg;
import kd.fi.v2.fah.models.flex.FlexFieldGrpCfg;
import kd.fi.v2.fah.models.mapping.impl.MappingStructureMeta;
import kd.fi.v2.fah.sqlbuilder.IInsertSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.ISqlParamBuffer;
import kd.fi.v2.fah.sqlbuilder.SQLColumnInfo;
import kd.fi.v2.fah.sqlbuilder.impl.BaseInsertSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.impl.FlexTableInsertSqlBuilder;

public class FlexMappingTabInsertSqlBuilder {
    protected FlexTableInsertSqlBuilder srcSqlBuilder;
    protected MappingStructureMeta mappingStructureMeta;
    protected transient BiFunction<String, Integer, Object[]> idGeneratorFunction;

    public FlexMappingTabInsertSqlBuilder(FlexTableInsertSqlBuilder srcSqlBuilder, MappingStructureMeta mappingStructureMeta, BiFunction<String, Integer, Object[]> idGeneratorFunction) {
        this.srcSqlBuilder = srcSqlBuilder;
        this.mappingStructureMeta = mappingStructureMeta;
        this.idGeneratorFunction = idGeneratorFunction != null ? idGeneratorFunction : (tabName, cnt) -> srcSqlBuilder.getIdGeneratorFunction().apply((Integer)cnt);
    }

    public Object[] pkGenerator(String tableName, Integer cnt) {
        return this.idGeneratorFunction.apply(tableName, cnt);
    }

    public IInsertSqlBuilder[] getSqlBuilder() {
        int i;
        int builderCnt = 2;
        String tableName = this.srcSqlBuilder.getSqlTableName();
        Object batchId = this.srcSqlBuilder.getBatchId();
        HashMap<String, PairTuple> flexFieldGrp = new HashMap<String, PairTuple>(this.srcSqlBuilder.getSqlParamColumnCnt());
        IInsertSqlBuilder[] insertSqlBuilders = new BaseInsertSqlBuilder[2];
        List[] srcParamReadPos = new List[2];
        block8: for (MappingValueType valueType : MappingValueType.values()) {
            FlexFieldGrpCfg grpCfg;
            i = valueType.getCode();
            switch (valueType) {
                case INPUT: {
                    grpCfg = this.mappingStructureMeta.getInputParamMeta();
                    break;
                }
                case OUTPUT: {
                    grpCfg = this.mappingStructureMeta.getOutputParamMeta();
                    break;
                }
                default: {
                    continue block8;
                }
            }
            BaseInsertSqlBuilder sqlBuilder = insertSqlBuilders[i] = new BaseInsertSqlBuilder(batchId, tableName);
            sqlBuilder.addConstantValueColumn("fMapValueType", i);
            srcParamReadPos[i] = new LinkedList();
            for (FlexFieldCfg field : grpCfg) {
                flexFieldGrp.put(field.getNumber(), new PairTuple((Object)i, (Object)field.getDbFieldNum()));
            }
        }
        Iterator<SQLColumnInfo> iterator = this.srcSqlBuilder.getAddColumns().iterator();
        block10: while (iterator.hasNext()) {
            SQLColumnInfo col;
            SQLColumnInfo columnInfo = col = iterator.next();
            switch (columnInfo.getColumnGrpType()) {
                case ConstantValueColumn: 
                case FixPosColumn: {
                    for (i = 0; i < insertSqlBuilders.length; ++i) {
                        insertSqlBuilders[i].addFixPosColumn(columnInfo.getName(), new Object[0]);
                        srcParamReadPos[i].add(columnInfo.getAddSeq());
                    }
                    continue block10;
                }
                case FlexColumn: {
                    PairTuple flexInfo = (PairTuple)flexFieldGrp.get(columnInfo.getName());
                    if (flexInfo == null) {
                        throw new IllegalArgumentException("Unknown Flex Field: " + columnInfo);
                    }
                    insertSqlBuilders[(Integer)flexInfo.getKey()].addFixPosColumn((String)flexInfo.getValue(), new Object[0]);
                    srcParamReadPos[(Integer)flexInfo.getKey()].add(columnInfo.getAddSeq());
                }
            }
        }
        int pkIndex = this.srcSqlBuilder.getPK_Column_Index();
        Object[] ids = this.pkGenerator(this.srcSqlBuilder.getTableName(), this.srcSqlBuilder.getSqlParamRowCnt() * 2);
        ISqlParamBuffer[] sqlParamBuffers = new ISqlParamBuffer[]{insertSqlBuilders[0].getSqlParamBuffer(), insertSqlBuilders[1].getSqlParamBuffer()};
        int row = 0;
        int rowIdx = 0;
        for (Object[] srcRow : this.srcSqlBuilder.getSqlParams()) {
            for (int i2 = 0; i2 < insertSqlBuilders.length; ++i2) {
                int col = 0;
                if (row > 0) {
                    sqlParamBuffers[i2].moveToNextParamRow();
                }
                for (Integer readPos : srcParamReadPos[i2]) {
                    sqlParamBuffers[i2].set(col++, srcRow[readPos]);
                }
                sqlParamBuffers[i2].set(pkIndex, ids[rowIdx++]);
            }
            ++row;
        }
        return insertSqlBuilders;
    }

    public FlexTableInsertSqlBuilder getSrcSqlBuilder() {
        return this.srcSqlBuilder;
    }

    public void setSrcSqlBuilder(FlexTableInsertSqlBuilder srcSqlBuilder) {
        this.srcSqlBuilder = srcSqlBuilder;
    }

    public MappingStructureMeta getMappingStructureMeta() {
        return this.mappingStructureMeta;
    }

    public void setMappingStructureMeta(MappingStructureMeta mappingStructureMeta) {
        this.mappingStructureMeta = mappingStructureMeta;
    }

    public BiFunction<String, Integer, Object[]> getIdGeneratorFunction() {
        return this.idGeneratorFunction;
    }

    public void setIdGeneratorFunction(BiFunction<String, Integer, Object[]> idGeneratorFunction) {
        this.idGeneratorFunction = idGeneratorFunction;
    }
}

