/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.storage.impl;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import kd.bos.dataentity.collections.IKeyedCollectionBase;
import kd.fi.bd.util.iterators.impl.ArrayIterator;
import kd.fi.v2.fah.models.common.SimpleMapEntry;
import kd.fi.v2.fah.storage.impl.CacheableMutableArrayStorage;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public abstract class AbstractMutableArrayMapStorage<K, V>
extends CacheableMutableArrayStorage<V>
implements IKeyedCollectionBase<K, V>,
Serializable {
    protected boolean caseSensitive;
    @JSONField(serialize=false)
    @JsonIgnore
    protected Map<K, Integer> indexMap;
    protected transient Function<V, K> itemKeyParser;

    protected AbstractMutableArrayMapStorage(Function<V, K> itemKeyParser) {
        this.caseSensitive = true;
        this.itemKeyParser = itemKeyParser;
    }

    public AbstractMutableArrayMapStorage(V[] values, Class clazzType, Function<V, K> itemKeyParser) {
        this(values, clazzType, true, itemKeyParser);
    }

    public AbstractMutableArrayMapStorage(V[] values, Class clazzType, boolean caseSensitive, Function<V, K> itemKeyParser) {
        super(values, clazzType);
        this.caseSensitive = caseSensitive;
        this.itemKeyParser = itemKeyParser;
        this.__rebuildIndex(0);
    }

    public AbstractMutableArrayMapStorage(int initialSize, Class<V> clazzType, boolean caseSensitive, Function<V, K> itemKeyParser) {
        super(initialSize, clazzType);
        this.itemKeyParser = itemKeyParser;
        this.caseSensitive = caseSensitive;
        this.indexMap = this.createIndexMap();
    }

    @Override
    public String toString() {
        return "AbstractMutableArrayMapStorage{caseInsensitive=" + this.caseSensitive + ", indexMap=" + this.indexMap + ", values=" + Arrays.toString(this.values) + ", __current_store_pos=" + this.__current_store_pos + '}';
    }

    private Map<K, Integer> createIndexMap() {
        return this.caseSensitive ? new HashMap(4) : new CaseInsensitiveMap(4);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public int getIndexSize() {
        return this.indexMap != null ? this.indexMap.size() : 0;
    }

    protected int put(K key, V element) {
        int valIndex;
        if (this.indexMap == null) {
            this.indexMap = this.createIndexMap();
        }
        if ((valIndex = this.indexMap.computeIfAbsent(key, k -> this.__current_store_pos).intValue()) < this.__current_store_pos) {
            this.set(valIndex, element);
        } else {
            super.set(valIndex, element);
            ++this.__current_store_pos;
        }
        return valIndex;
    }

    protected K getItemKey(V item) {
        return item == null ? null : (K)this.itemKeyParser.apply(item);
    }

    @Override
    public V set(int index, V newValue) {
        Integer duplicateIdx;
        if (!this.validateIndex(index)) {
            throw new IndexOutOfBoundsException(String.format("Index=%s, Value=%s", index, newValue));
        }
        V oldValue = this.get((K)index);
        K oldKey = this.getItemKey(oldValue);
        this.indexMap.remove(oldKey);
        V setValue = super.set(index, newValue);
        if (setValue != null && (duplicateIdx = this.indexMap.put(this.getItemKey(newValue), index)) != null && duplicateIdx != index) {
            this.removeByIndex(duplicateIdx);
        }
        return setValue;
    }

    @Override
    public int addEx(V value) {
        K key = this.getItemKey(value);
        return key != null ? this.put(key, value) : -1;
    }

    public int update(V value, boolean autoAdd) {
        K key = this.getItemKey(value);
        if (key == null) {
            return -1;
        }
        int valIndex = -1;
        if (this.indexMap == null) {
            if (autoAdd) {
                return this.put(key, value);
            }
        } else {
            valIndex = this.indexMap.getOrDefault(key, -1);
            if (valIndex == -1) {
                if (autoAdd) {
                    return this.put(key, value);
                }
            } else {
                this.set(valIndex, value);
            }
        }
        return valIndex;
    }

    @Override
    public int batchAdd(Collection<V> newValues) {
        if (newValues == null || newValues.isEmpty()) {
            return -1;
        }
        LinkedHashMap<K, Object[]> newAddBuf = new LinkedHashMap<K, Object[]>(newValues.size());
        if (this.indexMap == null) {
            this.indexMap = this.createIndexMap();
        }
        for (V val : newValues) {
            int index;
            K itemKey = this.getItemKey(val);
            if (itemKey == null) continue;
            if (this._clazzType == null) {
                this._clazzType = val.getClass();
            }
            if ((index = this.indexMap.getOrDefault(itemKey, -1).intValue()) >= 0) {
                super.set(index, val);
                continue;
            }
            newAddBuf.put(itemKey, new Object[]{itemKey, val});
        }
        if (this.ensureCapacity(this.__current_store_pos + newAddBuf.size(), this._clazzType)) {
            for (Object[] buf : newAddBuf.values()) {
                this.indexMap.put(buf[0], this.__current_store_pos);
                this.values[this.__current_store_pos++] = buf[1];
            }
        }
        return this.__current_store_pos;
    }

    @Override
    public V removeByIndex(int index) {
        Object result = super.removeByIndex(index);
        if (result != null) {
            this.indexMap.remove(this.getItemKey(result));
            this.__rebuildIndex(index);
        }
        return result;
    }

    public V removeEx(K key) {
        return this.removeByIndex(this.getIndex(key));
    }

    @Override
    public List<V> batchRemoveByRange(int start, int end) {
        List result = super.batchRemoveByRange(start, end);
        if (result != null && !result.isEmpty()) {
            for (Object item : result) {
                this.indexMap.remove(this.getItemKey(item));
            }
            this.__rebuildIndex(start);
        }
        return result;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public void clear() {
        super.clear();
        if (this.indexMap != null) {
            this.indexMap.clear();
        }
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean flush() {
        int startReIndexPos = this.__current_store_pos;
        if (this.cachedSize > 0) {
            if (this.values == null) {
                this.values = this.cacheListToArray();
                this.__current_store_pos = this.cachedSize;
            } else {
                this.batchAdd(this.cacheList);
            }
            this.__rebuildIndex(startReIndexPos);
            this.cachedSize = 0;
            this.cacheList = null;
            return true;
        }
        return false;
    }

    private void __rebuildIndex(int startPos) {
        if (this.values == null || startPos < 0 || startPos >= this.values.length) {
            return;
        }
        if (this.indexMap == null) {
            this.indexMap = this.createIndexMap();
        }
        for (int i = startPos; i < this.values.length; ++i) {
            Object buf = this.values[i];
            if (buf == null) continue;
            this.indexMap.put(this.getItemKey(buf), i);
        }
    }

    public void rebuildIndex(int startPos) {
        this.__rebuildIndex(startPos);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Iterator<Map.Entry<K, V>> getMapEntryIterator() {
        return new Iterator<Map.Entry<K, V>>(){
            final ArrayIterator<V> srcIt;
            final SimpleMapEntry<K, V> entryBuf;
            {
                this.srcIt = new ArrayIterator(AbstractMutableArrayMapStorage.this.values);
                this.entryBuf = new SimpleMapEntry();
            }

            @Override
            public boolean hasNext() {
                return this.srcIt.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                Object buf = this.srcIt.next();
                return this.entryBuf.reset(AbstractMutableArrayMapStorage.this.getItemKey(buf), buf);
            }
        };
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Map<K, Integer> getIndexMap() {
        return this.indexMap;
    }

    public void setIndexMap(Map<K, Integer> indexMap) {
        this.indexMap = indexMap;
    }

    public boolean containsKey(K key) {
        return this.indexMap != null && this.indexMap.containsKey(key);
    }

    public V get(K key) {
        if (this.indexMap == null) {
            return null;
        }
        return super.get(this.indexMap.getOrDefault(key, -1));
    }

    public int getIndex(K key) {
        return this.indexMap == null ? -1 : this.indexMap.getOrDefault(key, -1);
    }

    @Override
    public boolean sort(Comparator comparator) {
        if (super.sort(comparator)) {
            this.__rebuildIndex(0);
            return true;
        }
        return false;
    }

    @Override
    public boolean sort(int fromIndex, int toIndex, Comparator comparator) {
        if (super.sort(fromIndex, toIndex, comparator)) {
            this.__rebuildIndex(fromIndex);
            return true;
        }
        return false;
    }

    @Override
    @JSONField(name="data")
    public void setJsonSerializeV(Object values, Class clazzType, boolean caseSensitive) {
        super.setJsonSerializeV(values, clazzType, caseSensitive);
        this.caseSensitive = caseSensitive;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean rebuildAfterDeSerialize() {
        this.__rebuildIndex(0);
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractMutableArrayMapStorage that = (AbstractMutableArrayMapStorage)o;
        return this.caseSensitive == that.caseSensitive && Objects.equals(this.indexMap, that.indexMap);
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.caseSensitive, this.indexMap);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public void setItemKeyParser(Function<V, K> itemKeyParser) {
        this.itemKeyParser = itemKeyParser;
    }
}

