/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.storage.impl;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import kd.fi.bd.util.data.IDataValueUtil;
import kd.fi.bd.util.iterators.impl.ArrayIterator;
import kd.fi.v2.fah.serializer.ICustomJsonSerialize;
import kd.fi.v2.fah.storage.IOpenDataStorage;
import kd.fi.v2.fah.utils.ArrayUtils;

public class MutableArrayStorage<V>
implements IOpenDataStorage<V>,
ICustomJsonSerialize {
    @JSONField(ordinal=1)
    protected Class<?> _clazzType;
    @JSONField(ordinal=2, name="datas")
    protected V[] values;
    @JSONField(serialize=false)
    @JsonIgnore
    protected int __current_store_pos;

    public MutableArrayStorage() {
        this.__current_store_pos = 0;
        this._clazzType = null;
    }

    public MutableArrayStorage(Object[] values, Class clazzType) {
        if (values == null) {
            throw new IllegalArgumentException("Initial Array cannot be null!");
        }
        if (clazzType == null) {
            throw new IllegalArgumentException("Initial Array Class Type cannot be null!");
        }
        this._clazzType = clazzType;
        this.__current_store_pos = values.length;
        this.values = values.getClass().getComponentType().equals(clazzType) ? values : ArrayUtils.copyArray(values, clazzType);
    }

    public MutableArrayStorage(int initialSize, Class clazzType) {
        this._clazzType = clazzType;
        this.values = (Object[])Array.newInstance(this._clazzType, initialSize);
        this.__current_store_pos = 0;
    }

    public static MutableArrayStorage<Object> getObjectArrayStorage(int initialSize) {
        return new MutableArrayStorage<Object>(new Object[initialSize], Object.class);
    }

    protected boolean validateIndex(int index) {
        return this.values != null && index >= 0 && index < this.values.length;
    }

    protected Class<?> getItemClazzType() {
        if (this._clazzType != null) {
            return this._clazzType;
        }
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == null) continue;
                this._clazzType = this.values[i].getClass();
                return this._clazzType;
            }
        }
        return null;
    }

    public boolean ensureCapacity(int requiredSize, Class<?> clazzType) {
        return this.ensureCapacity(requiredSize, clazzType, false);
    }

    public boolean ensureCapacity(int requiredSize, Class<?> clazzType, boolean increaseStorePos) {
        if (requiredSize <= 0) {
            return false;
        }
        if (this.values == null) {
            if (this._clazzType == null) {
                this._clazzType = clazzType;
            }
            if (this._clazzType == null) {
                throw new IllegalArgumentException("Unknown Class Type!");
            }
            this.values = (Object[])Array.newInstance(this._clazzType, requiredSize);
            if (increaseStorePos) {
                this.__current_store_pos = requiredSize;
            }
        } else if (requiredSize > this.values.length) {
            this.values = clazzType == null || this.values.getClass().equals(Array.newInstance(clazzType, 0).getClass()) ? Arrays.copyOf(this.values, requiredSize) : Arrays.copyOf(this.values, requiredSize, Object[].class);
            if (increaseStorePos) {
                this.__current_store_pos = requiredSize;
            }
        }
        return true;
    }

    @Override
    public V get(int index) {
        return this.validateIndex(index) ? (V)this.values[index] : null;
    }

    @Override
    public V set(int index, V value) {
        return this.ensureCapacity(index + 1, value != null ? value.getClass() : null) ? (V)value : null;
    }

    @Override
    public int addEx(V value) {
        this.set(this.__current_store_pos, value);
        return this.__current_store_pos++;
    }

    protected Class<?> foundClassType(Collection<V> newValues) {
        if (this._clazzType == null) {
            for (V val : newValues) {
                if (val == null) continue;
                this._clazzType = val.getClass();
                break;
            }
        }
        return this._clazzType;
    }

    @Override
    public int batchAdd(Collection<V> newValues) {
        if (newValues == null || newValues.isEmpty()) {
            return -1;
        }
        if (this.ensureCapacity(this.__current_store_pos + newValues.size(), this.foundClassType(newValues))) {
            for (V val : newValues) {
                this.values[this.__current_store_pos++] = val;
            }
        }
        return this.__current_store_pos;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public V[] getValues() {
        return this.values;
    }

    public V[] getValues(V[] reserveColumnDatas, int reserveColumnPosition) {
        if (this.values == null) {
            return null;
        }
        return ArrayUtils.combineArray(reserveColumnDatas, this.values, reserveColumnPosition);
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public IOpenDataStorage memberClone() {
        Object[] newValues = new Object[this.values.length];
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        return new MutableArrayStorage<V>(newValues, this._clazzType);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String toString() {
        return Arrays.asList(this.values).toString();
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public int size() {
        return this.values != null ? this.values.length : 0;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isEmpty() {
        return this.__current_store_pos < 1;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public void clear() {
        if (this.values != null) {
            this.values = (Object[])Array.newInstance(this.values.getClass().getComponentType(), 0);
        }
        this.__current_store_pos = 0;
    }

    @Override
    public void reset(int newSize, Class<V> clazzType) {
        this._clazzType = clazzType;
        this.values = (Object[])Array.newInstance(this._clazzType, newSize);
        this.__current_store_pos = 0;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public Iterator<V> iterator() {
        return new ArrayIterator((Object[])this.values);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public int getCurrentStorePos() {
        return this.__current_store_pos;
    }

    protected V[] createArray(int size) {
        return (Object[])Array.newInstance(this._clazzType, size);
    }

    @Override
    public V removeByIndex(int index) {
        if (this.values == null || index < 0 || index >= this.values.length) {
            return null;
        }
        V result = this.values[index];
        V[] newArray = Arrays.copyOf(this.values, this.values.length - 1);
        if (newArray.length > 0) {
            if (index > 0) {
                System.arraycopy(this.values, 0, newArray, 0, index);
            }
            System.arraycopy(this.values, index + 1, newArray, index, this.values.length - 1 - index);
        }
        this.values = newArray;
        --this.__current_store_pos;
        return result;
    }

    @Override
    public List<V> batchRemoveByRange(int start, int end) {
        List<V> resultList;
        if (this.values == null || start < 0) {
            return Collections.EMPTY_LIST;
        }
        int oldLength = this.values.length;
        if (start >= oldLength) {
            return Collections.EMPTY_LIST;
        }
        int endPos = Math.min(end, oldLength);
        if (oldLength == 1) {
            resultList = Collections.singletonList(this.values[0]);
            this.values[0] = null;
            this.__current_store_pos = 0;
        } else {
            int removeLength = endPos - start + 1;
            if (removeLength >= oldLength) {
                resultList = Arrays.asList(this.values);
                this.values = Arrays.copyOf(this.values, 1);
                this.__current_store_pos = 0;
            } else {
                V[] removed = Arrays.copyOf(this.values, removeLength);
                int j = 0;
                int i = start;
                while (i <= endPos) {
                    removed[j] = this.values[i];
                    ++i;
                    ++j;
                }
                resultList = Arrays.asList(removed);
                this.__current_store_pos -= Math.min(this.__current_store_pos, removeLength);
                if (endPos == oldLength) {
                    this.values = Arrays.copyOf(this.values, start);
                } else {
                    V[] newArray = Arrays.copyOf(this.values, oldLength - removeLength);
                    if (start > 0) {
                        System.arraycopy(this.values, 0, newArray, 0, start);
                    }
                    System.arraycopy(this.values, endPos + 1, newArray, start, oldLength - 1 - endPos);
                    this.values = newArray;
                }
            }
        }
        return resultList;
    }

    @Override
    public boolean sort(Comparator<V> comparator) {
        if (this.values == null) {
            return false;
        }
        Arrays.sort(this.values, comparator);
        return true;
    }

    @Override
    public boolean sort(int fromIndex, int toIndex, Comparator<V> comparator) {
        if (this.values == null) {
            return false;
        }
        Arrays.sort(this.values, fromIndex, toIndex, comparator);
        return true;
    }

    @Override
    @JSONField(name="datas")
    public Object getJsonSerializeV() {
        return this.values;
    }

    @JSONField(name="datas")
    public void setValues(V[] values) {
        this.values = values;
        if (values != null) {
            this.__current_store_pos = values.length;
        }
    }

    @Override
    @JSONField(name="datas")
    public void setJsonSerializeV(Object values, Class clazzType, boolean caseSensitive) {
        this._clazzType = clazzType;
        if (values == null) {
            this.values = null;
            this.__current_store_pos = 0;
        } else {
            boolean i = false;
            if (IDataValueUtil.getObjectEnumType((Object)values) > 0) {
                LinkedList bufList = new LinkedList();
                IDataValueUtil.enumerateObject((Object)values, (index, item) -> bufList.add(item));
                this.values = bufList.toArray((Object[])Array.newInstance(clazzType, 0));
                this.__current_store_pos = this.values.length;
            } else {
                this.values = (Object[])Array.newInstance(clazzType, 1);
                this.values[0] = values;
                this.__current_store_pos = 1;
            }
        }
    }

    @Deprecated
    public Class foundMatchClassType(Object v) {
        if (v == null) {
            this.__current_store_pos = 0;
            this._clazzType = null;
            return null;
        }
        if (IDataValueUtil.getObjectEnumType((Object)v) > 0) {
            HashSet classTypes = new HashSet(4);
            int[] cnt = new int[]{0};
            IDataValueUtil.enumerateObject((Object)v, (index, item) -> {
                cnt[0] = cnt[0] + 1;
                if (item != null) {
                    classTypes.add(item.getClass());
                }
            });
            if (classTypes.size() == 1) {
                this._clazzType = (Class)classTypes.iterator().next();
            } else {
                try {
                    this._clazzType = Object.class;
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Current Storage Type Not Support Object Type, but found multiple class type!", ex);
                }
            }
            Object[] newArray = (Object[])Array.newInstance(this._clazzType, cnt[0]);
            IDataValueUtil.enumerateObject((Object)v, (index, item) -> {
                newArray[index.intValue()] = item;
            });
            this.values = newArray;
        } else {
            this._clazzType = v.getClass();
            Object[] objectArray = (Object[])Array.newInstance(this._clazzType, 1);
            this.values = objectArray;
            objectArray[0] = v;
        }
        this.__current_store_pos = this.values.length;
        return this._clazzType;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public Class getCustomSerializeClass() {
        return this._clazzType;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean needToSerialize() {
        return this.values != null && this.values.length > 0;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public void setCustomSerializeClass(Class<?> _clazzType) {
        this._clazzType = _clazzType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableArrayStorage that = (MutableArrayStorage)o;
        return this.__current_store_pos == that.__current_store_pos && Arrays.equals(this.values, that.values) && Objects.equals(this._clazzType, that._clazzType);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public int hashCode() {
        int result = Objects.hash(this.__current_store_pos, this._clazzType);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }
}

